.TH TANGLE 1 "25 January 2026" "Web2C @VERSION@"
.\"=====================================================================
.if n .ds MF Metafont
.if t .ds MF Metafont
.if t .ds TX \fRT\\h'-0.10m'\\v'0.17v'E\\v'-0.17v'\\h'-0.06m'X\fP
.if n .ds TX TeX
.ie t .ds OX \fIT\h'-0.17m'\v'+0.21m'E\v'-0.21m'\h'-0.04m'X\fP
.el .ds OX TeX
.\"=====================================================================
.SH NAME
tangle, otangle \- translate a literate programming WEB to Pascal
.SH SYNOPSIS
\f[B]tangle\f[R] [\f[I]options\f[R]]
\f[I]webfile\f[R][\f[B].web\f[R]]
[{\f[I]changefile\f[R][\f[B].ch\f[R]]|\f[B]-\f[R]}
[\f[I]outfile\f[R][\f[B].p\f[R]]]]
.\"=====================================================================
.SH DESCRIPTION
The
.B tangle
program converts a WEB literate programming source document into a
Pascal program. In addition to being processed with a Pascal compiler,
nowadays, the Pascal output is often translated to C; this is how the
\*(TX family of programs are compiled in \*(TX Live.
.PP
The WEB language allows you to prepare a single document containing all
the information that is needed to produce both a compilable Pascal
program and a well-formatted document describing the program in as much
detail as the writer may desire. The user of WEB must be familiar with
both \*(TX and Pascal. WEB also provides a relatively simple, although
adequate, macro facility that permits a Pascal program to be written in
small modules, written in an arbitrary order.
.PP
The command line should have one, two or three filenames on it. The
first is taken as the WEB file; ".web" is added if there is no
extension.
.PP
If a second filename is given, it is taken as a change file, and ".ch"
is added if there is no extension. The change file overrides parts of
the WEB file, as described in the WEB system documentation. If no second
filename, there is no change file.
.PP
If a third filename is given, it is taken as the Pascal output file, and
".p" is added if there is no extension. To specify an output file with
no change, you can use "-" for the second argument, meaning an empty
change file (not stdin). If no third filename is given, the name of the
Pascal file is formed by adding ".p" to the root of the WEB file name.
.PP
The output file is packed into lines of 72 characters or
less, with the only concession to readability being the termination of
lines at semicolons when this can be done conveniently.
.PP
If the WEB program uses the built-in string handling feature
(double-quoted strings), a second output file is a string pool file,
whose name is always formed by adding ".pool" to the root of the Pascal
file name.
.PP
The
.B otangle
variant supports a larger character range. It was written for the Omega
project, the first \*(TX supporting Unicode, now provided as the
.BR aleph (1)
descendant program.
.\"=====================================================================
.SH "OPTIONS"
See
.BR tex (1)
for details of command-line parsing.
.PP
Some of these options may render the output unsuitable for processing by
a Pascal compiler.
.TP
.B --help
Print help message and exit.
.TP
.BI --length \ number
Compare only the first
.I number
characters of identifiers when checking for collisions.  The default
is 32; the original
.B tangle
used 7.
.TP
.B --loose
When checking for collisions between identifiers, honor the settings
of the
.BR --lowercase ,
.BR --mixedcase ,
.BR --uppercase ,
and
.B --underline
options. This is the default.
.TP
.B --lowercase
Convert all identifiers to lowercase.
.TP
.B --mixedcase
Retain the case of identifiers.  This is the default.
.TP
.B --strict
When checking for collisions between identifiers, strip underlines and
convert all identifiers to uppercase first.
.TP
.B --underline
Retain underlines (also known as underscores) in identifiers.
.TP
.B --uppercase
Convert all identifiers to uppercase.  This is the behaviour of the
original
.BR tangle .
.TP
.B --version
Print version information and exit.
.PP
.B otangle
supports only the \fB--help\fP and \fB--version\fP options,
.\"=====================================================================
.SH ENVIRONMENT
The programs look for the input files using the environment variable
WEBINPUTS. If it is not set, it uses the system default. See the
Kpathsea manual at https://tug.org/kpathsea for the details of the
searching.
.\"=====================================================================
.SH "SEE ALSO"
Donald E. Knuth,
.IR "The WEB System of Structured Documentation" .
.br
https://mirrors.ctan.org/info/knuth-pdf/web/webman.pdf
.PP
Donald E. Knuth,
.IR Literate Programming,
CSLI Lecture Notes, no. 27.
.br
https://www-cs-faculty.stanford.edu/~knuth/lp.html
.PP
Donald E. Knuth,
.I "\*(OX: The Program"
(Volume B of
.IR "Computers & Typesetting" ).
.br
Donald E. Knuth,
.I "\*(MF: The Program"
(Volume D of
.IR "Computers & Typesetting" ).
.br
These latter two are by far the largest extant examples of WEB programs.
.PP
Literate programming topic on CTAN: https://ctan.org/topic/litprog
.br
Package page on CTAN: https://ctan.org/pkg/tangle
.br
Section in the Web2c manual:
https://tug.org/texinfohtml/web2c.html#tangle-invocation
.br
Typeset source code for all the original Stanford WEB programs:
https://ctan.org/pkg/knuth-pdf
.\"=====================================================================
.SH AUTHORS
WEB was designed by Donald E. Knuth, based on an earlier system called
DOC (implemented by Ignacio Zabala), inspired by considerable earlier
work, notably Pierre-Arnoul de Marneffe's concept of ``holon
programming'' (https://github.com/holon-scribe/holon-programming).
.PP
The updates for Omega were written by John Plaice and Yannis Haralambous.
.PP
The
.B tangle
and
.B weave
programs are themselves written in WEB. The system was originally ported
to Unix at Stanford by Howard Trickey, and at Cornell by Pavel Curtis.
.PP
Public discussion list and bug reports: https://lists.tug.org/tex-k
