.TH DVITYPE 1 "22 January 2026" "Web2C @VERSION@"
.\"=====================================================================
.if t .ds TX \fRT\\h'-0.10m'\\v'0.17v'E\\v'-0.17v'\\h'-0.06m'X\fP
.if n .ds TX TeX
.ie t .ds OX \fIT\h'-0.17m'\v'+0.21m'E\v'-0.21m'\h'-0.04m'X\fP
.el .ds OX TeX
.\"=====================================================================
.SH NAME
dvitype, odvitype \- translate a dvi file for humans to read
.SH SYNOPSIS
.B dvitype
.IR dvi_file [ \fB.dvi\fP ]
.\"=====================================================================
.SH DESCRIPTION
The
.B dvitype
program translates a DVI (DeVice Independent) file output by (for example)
.BR tex (1)
or
.BR gftodvi (1),
to a file that humans can read. It also serves as a DVI file-validating
program (i.e., if
.B dvitype
can read it, it's correct) and as an example of a DVI-processing
program for future device drivers.
.PP
The output from
.B dvitype
can include all commands, just the important ones, or none at all (in
which case only errors are reported). A subinterval of pages may be
selected, the magnification and resolution of the
``output device'' may be changed, and so on.
.PP
The
.B .dvi
extension is supplied if omitted from 
.IR dvi_file .
The output goes to stdout.
.PP
The
.B odvitype
program does the same job for Omega/Aleph's output, modified to support
their \fI.ofm\fP font format.
.\"=====================================================================
.SH OPTIONS
See
.BR tex (1)
for details of command-line parsing.
.TP
.BI -dpi= real
Set resolution to
.I real
pixels per inch; default 300.0.
.TP
.BI -magnification= number
Override existing magnification with
.IR number .
.TP
.BI -max-pages= number
Process
.I number
pages; default one million.
.TP
.BI -output-level= number
Verbosity level, from 0 to 4; default 4.
.TP
.BI -page-start= page-spec
Start at
.IR page-spec ,
for example `2' or `5.*.-2'.
.TP
.B -show-opcodes
Show numeric opcodes (in decimal).
.PP
The standard
.B -help
and
.B -version
options are also supported.
.\"=====================================================================
.SH ENVIRONMENT
The environment variable TEXFONTS is used to search for the TFM files
used in the DVI file.  See
.BR tex (1)
for the details of the searching.
If TEXFONTS is not set, it uses the system default.
.\"=====================================================================
.SH "SEE ALSO"
.BR gftype (1),
.BR pktype (1).
.br
Donald E. Knuth,
.IR "\*(OXware" .
.PP
DVI structure topic on CTAN: https://ctan.org/topic/dvi-struc
.br
Package page on CTAN: https://ctan.org/pkg/dvitype
.br
Section in the Web2c manual:
https://tug.org/texinfohtml/web2c.html#dvitype-invocation
.br
Typeset source code, including the DVI file format description:
https://ctan.org/pkg/knuth-pdf
.\"=====================================================================
.SH AUTHORS
Donald E. Knuth wrote the program, based on work by David Fuchs. It was
published as part of the
.I \*(OXware
technical report from Stanford. Howard Trickey and Pavel Curtis
originally ported it to Unix. Yannis Haralambous and John Plaice created
the Omega version.
.PP
Public discussion list and bug reports: https://lists.tug.org/tex-k
