# Generated by default/object.tt
package Paws::SageMakerEdge::EdgeMetric;
  use Moose;
  has Dimension => (is => 'ro', isa => 'Str');
  has MetricName => (is => 'ro', isa => 'Str');
  has Timestamp => (is => 'ro', isa => 'Str');
  has Value => (is => 'ro', isa => 'Num');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMakerEdge::EdgeMetric

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMakerEdge::EdgeMetric object:

  $service_obj->Method(Att1 => { Dimension => $value, ..., Value => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMakerEdge::EdgeMetric object:

  $result = $service_obj->Method(...);
  $result->Att1->Dimension

=head1 DESCRIPTION

Information required for edge device metrics.

=head1 ATTRIBUTES


=head2 Dimension => Str

The dimension of metrics published.


=head2 MetricName => Str

Returns the name of the metric.


=head2 Timestamp => Str

Timestamp of when the metric was requested.


=head2 Value => Num

Returns the value of the metric.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMakerEdge>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

