
use strict;
use warnings;
use Test::More;


use Crypt::NaCl::Sodium qw(:utils);

my $key = join('', map { chr($_) }
        0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b,
        0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16,
        0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f, 0x20
);

my $c = join('', map { chr($_) }
        0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd,
        0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd,
        0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd,
        0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd,
        0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd
);

my $expected = join('', map { chr($_) }
     0x37,0x2e,0xfc,0xf9,0xb4,0x0b,0x35,0xc2
    ,0x11,0x5b,0x13,0x46,0x90,0x3d,0x2e,0xf4
    ,0x2f,0xce,0xd4,0x6f,0x08,0x46,0xe7,0x25
    ,0x7b,0xb1,0x56,0xd3,0xd7,0xb3,0x0d,0x3f
);

my $crypto_auth = Crypt::NaCl::Sodium->auth();

my $mac = $crypto_auth->hmacsha256($c, $key);

is(bin2hex($mac), bin2hex($expected), "got correct HMAC-SHA-256");

# auth3.c
ok($crypto_auth->hmacsha256_verify($mac, $c, $key), "...and was verified");

done_testing();

