/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.StreamGobbler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;

public class SystemUtils {
    public static void run(ProcessBuilder builder) {
        SystemUtils.run(builder, null, null);
    }

    public static void run(ProcessBuilder builder, Writer output, Writer error) {
        try {
            Process process = builder.start();
            SystemUtils.consume(process, output, error);
            int result = process.waitFor();
            if (result != 0) {
                String msg = "process %s exited with value %d";
                throw new ProcessException(String.format(msg, builder.command(), result));
            }
        }
        catch (InterruptedException e) {
            throw new ProcessException(e);
        }
        catch (IOException e) {
            throw new ProcessException(e);
        }
    }

    private static void consume(Process process, Writer outputWriter, Writer errorWriter) throws IOException, InterruptedException {
        if (outputWriter == null) {
            outputWriter = new OutputStreamWriter(System.out);
        }
        if (errorWriter == null) {
            errorWriter = new OutputStreamWriter(System.err);
        }
        WriterThread outputThread = new WriterThread(process.getInputStream(), outputWriter);
        WriterThread errorThread = new WriterThread(process.getErrorStream(), errorWriter);
        outputThread.start();
        errorThread.start();
        outputThread.join();
        errorThread.join();
    }

    public static void runShellCommand(String[] cmd, StringBuilder outputLines, StringBuilder errorLines) throws IOException {
        String line;
        Process p = Runtime.getRuntime().exec(cmd);
        if (outputLines != null) {
            BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = in.readLine()) != null) {
                outputLines.append(line);
            }
        }
        if (errorLines != null) {
            BufferedReader err2 = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            while ((line = err2.readLine()) != null) {
                errorLines.append(line);
            }
        }
    }

    public static void runShellCommand(String cmd, StringBuilder outputLines, StringBuilder errorLines) throws IOException {
        SystemUtils.runShellCommand(new String[]{cmd}, outputLines, errorLines);
    }

    public static void runShellCommand(String[] cmd, StringBuilder outputLines) throws IOException {
        SystemUtils.runShellCommand(cmd, outputLines, null);
    }

    public static void runShellCommand(String cmd, StringBuilder outputLines) throws IOException {
        SystemUtils.runShellCommand(new String[]{cmd}, outputLines, null);
    }

    public static void runShellCommand(String[] cmd) throws IOException {
        SystemUtils.runShellCommand(cmd, null, null);
    }

    public static void runShellCommand(String cmd) throws IOException {
        SystemUtils.runShellCommand(new String[]{cmd}, null, null);
    }

    public static int getPID() throws IOException {
        String[] cmd = new String[]{"perl", "-e", "print getppid() . \"\\n\";"};
        StringBuilder out2 = new StringBuilder();
        SystemUtils.runShellCommand(cmd, out2);
        return Integer.parseInt(out2.toString());
    }

    public static int getPIDNoExceptions() {
        try {
            return SystemUtils.getPID();
        }
        catch (IOException e) {
            return -1;
        }
    }

    public static int getMemoryInUse() {
        Runtime runtime = Runtime.getRuntime();
        long mb = 0x100000L;
        long total = runtime.totalMemory();
        long free = runtime.freeMemory();
        return (int)((total - free) / mb);
    }

    public static void main(String[] args) throws Exception {
        StringBuilder out2 = new StringBuilder();
        SystemUtils.runShellCommand("date", out2);
        System.out.println("The date is " + out2);
        int pid = SystemUtils.getPID();
        System.out.println("The PID is " + pid);
        System.out.println("The memory in use is " + SystemUtils.getMemoryInUse() + "MB");
        ArrayList<String> foo = new ArrayList<String>();
        for (int i = 0; i < 5000000; ++i) {
            foo.add("0123456789");
        }
        System.out.println("The memory in use is " + SystemUtils.getMemoryInUse() + "MB");
        foo = null;
        System.gc();
        System.out.println("The memory in use is " + SystemUtils.getMemoryInUse() + "MB");
    }

    public static class ProcessOutputStream
    extends OutputStream {
        private Process process;
        private Thread outWriterThread;
        private Thread errWriterThread;

        public ProcessOutputStream(String[] cmd) throws IOException {
            this(new ProcessBuilder(cmd), (Writer)new PrintWriter(System.out), (Writer)new PrintWriter(System.err));
        }

        public ProcessOutputStream(String[] cmd, Writer writer) throws IOException {
            this(new ProcessBuilder(cmd), writer, writer);
        }

        public ProcessOutputStream(String[] cmd, Writer output, Writer error) throws IOException {
            this(new ProcessBuilder(cmd), output, error);
        }

        public ProcessOutputStream(ProcessBuilder builder, Writer output, Writer error) throws IOException {
            this.process = builder.start();
            this.errWriterThread = new StreamGobbler(this.process.getErrorStream(), error);
            this.outWriterThread = new StreamGobbler(this.process.getInputStream(), output);
            this.errWriterThread.start();
            this.outWriterThread.start();
        }

        @Override
        public void flush() throws IOException {
            this.process.getOutputStream().flush();
        }

        @Override
        public void write(int b) throws IOException {
            this.process.getOutputStream().write(b);
        }

        @Override
        public void close() throws IOException {
            this.process.getOutputStream().close();
            try {
                this.errWriterThread.join();
                this.outWriterThread.join();
                this.process.waitFor();
            }
            catch (InterruptedException e) {
                throw new ProcessException(e);
            }
        }
    }

    private static class WriterThread
    extends Thread {
        private Reader reader;
        private Writer writer;

        public WriterThread(InputStream inputStream, Writer writer) {
            this.reader = new InputStreamReader(inputStream);
            this.writer = writer;
        }

        @Override
        public void run() {
            char[] buffer = new char[4096];
            while (true) {
                try {
                    int read = this.reader.read(buffer);
                    if (read == -1) break;
                    this.writer.write(buffer, 0, read);
                    this.writer.flush();
                }
                catch (IOException e) {
                    throw new ProcessException(e);
                }
                Thread.yield();
            }
        }
    }

    public static class ProcessException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ProcessException(String string) {
            super(string);
        }

        public ProcessException(Throwable cause) {
            super(cause);
        }
    }
}

