/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.Comparators;
import edu.stanford.nlp.util.Interval;
import java.util.Comparator;

public interface HasInterval<E extends Comparable<E>> {
    public static final Comparator<HasInterval<Integer>> LENGTH_COMPARATOR = new Comparator<HasInterval<Integer>>(){

        @Override
        public int compare(HasInterval<Integer> e1, HasInterval<Integer> e2) {
            int len2;
            int len1 = e1.getInterval().getEnd() - e1.getInterval().getBegin();
            if (len1 == (len2 = e2.getInterval().getEnd() - e2.getInterval().getBegin())) {
                return 0;
            }
            return len1 > len2 ? -1 : 1;
        }
    };
    public static final Comparator<HasInterval> ENDPOINTS_COMPARATOR = new Comparator<HasInterval>(){

        @Override
        public int compare(HasInterval e1, HasInterval e2) {
            return e1.getInterval().compareTo(e2.getInterval());
        }
    };
    public static final Comparator<HasInterval> NESTED_FIRST_COMPARATOR = new Comparator<HasInterval>(){

        @Override
        public int compare(HasInterval e1, HasInterval e2) {
            Interval.RelType rel = e1.getInterval().getRelation(e2.getInterval());
            if (rel.equals((Object)Interval.RelType.CONTAIN)) {
                return 1;
            }
            if (rel.equals((Object)Interval.RelType.INSIDE)) {
                return -1;
            }
            return e1.getInterval().compareTo(e2.getInterval());
        }
    };
    public static final Comparator<HasInterval> CONTAINS_FIRST_COMPARATOR = new Comparator<HasInterval>(){

        @Override
        public int compare(HasInterval e1, HasInterval e2) {
            Interval.RelType rel = e1.getInterval().getRelation(e2.getInterval());
            if (rel.equals((Object)Interval.RelType.CONTAIN)) {
                return -1;
            }
            if (rel.equals((Object)Interval.RelType.INSIDE)) {
                return 1;
            }
            return 0;
        }
    };
    public static final Comparator<HasInterval> CONTAINS_FIRST_ENDPOINTS_COMPARATOR = Comparators.chain(CONTAINS_FIRST_COMPARATOR, ENDPOINTS_COMPARATOR);
    public static final Comparator<HasInterval> NESTED_FIRST_ENDPOINTS_COMPARATOR = Comparators.chain(NESTED_FIRST_COMPARATOR, ENDPOINTS_COMPARATOR);

    public Interval<E> getInterval();
}

