/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.io.InDataStreamFile;
import edu.stanford.nlp.io.OutDataStreamFile;
import edu.stanford.nlp.tagger.maxent.AmbiguityClasses;
import edu.stanford.nlp.tagger.maxent.CountWrapper;
import edu.stanford.nlp.tagger.maxent.TTags;
import edu.stanford.nlp.tagger.maxent.TagCount;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class Dictionary {
    private final HashMap<String, TagCount> dict = new HashMap();
    private final HashMap<Integer, CountWrapper> partTakingVerbs = new HashMap();
    private static final String naWord = "NA";
    private static final boolean VERBOSE = false;

    protected void add(String word, String tag) {
        if (this.dict.containsKey(word)) {
            TagCount cT = this.dict.get(word);
            cT.add(tag);
            return;
        }
        TagCount cT = new TagCount();
        cT.add(tag);
        this.dict.put(word, cT);
    }

    protected void addVThatTaking(String verb) {
        int i = verb.hashCode();
        if (this.partTakingVerbs.containsKey(i)) {
            this.partTakingVerbs.get(i).incThat();
        } else {
            this.partTakingVerbs.put(i, new CountWrapper(verb, 0, 1, 0, 0));
        }
    }

    protected int getCountPart(String verb) {
        int i = verb.hashCode();
        if (this.partTakingVerbs.containsKey(i)) {
            return this.partTakingVerbs.get(i).getCountPart();
        }
        return 0;
    }

    protected int getCountThat(String verb) {
        int i = verb.hashCode();
        if (this.partTakingVerbs.containsKey(i)) {
            return this.partTakingVerbs.get(i).getCountThat();
        }
        return 0;
    }

    protected int getCountIn(String verb) {
        int i = verb.hashCode();
        if (this.partTakingVerbs.containsKey(i)) {
            return this.partTakingVerbs.get(i).getCountIn();
        }
        return 0;
    }

    protected int getCountRB(String verb) {
        int i = verb.hashCode();
        if (this.partTakingVerbs.containsKey(i)) {
            return this.partTakingVerbs.get(i).getCountRB();
        }
        return 0;
    }

    protected int getCount(String word, String tag) {
        TagCount tc = this.dict.get(word);
        if (tc == null) {
            return 0;
        }
        return tc.get(tag);
    }

    protected String[] getTags(String word) {
        TagCount tC = this.get(word);
        if (tC == null) {
            return null;
        }
        return tC.getTags();
    }

    protected TagCount get(String word) {
        return this.dict.get(word);
    }

    String getFirstTag(String word) {
        if (this.dict.containsKey(word)) {
            return this.dict.get(word).getFirstTag();
        }
        return null;
    }

    protected int sum(String word) {
        if (this.dict.containsKey(word)) {
            return this.dict.get(word).sum();
        }
        return 0;
    }

    boolean isUnknown(String word) {
        return !this.dict.containsKey(word);
    }

    void save(OutDataStreamFile file) {
        String[] arr = this.dict.keySet().toArray(new String[this.dict.keySet().size()]);
        try {
            file.writeInt(arr.length);
            System.err.println("Saving dictionary of " + arr.length + " words ...");
            for (String word : arr) {
                TagCount tC = this.get(word);
                file.writeUTF(word);
                tC.save(file);
            }
            Integer[] arrverbs = this.partTakingVerbs.keySet().toArray(new Integer[this.partTakingVerbs.keySet().size()]);
            file.writeInt(arrverbs.length);
            for (Integer iO : arrverbs) {
                CountWrapper tC = this.partTakingVerbs.get(iO);
                file.writeInt(iO);
                tC.save(file);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void read(DataInputStream rf, String filename) throws IOException {
        int maxNumTags = 0;
        int len = rf.readInt();
        for (int i = 0; i < len; ++i) {
            String word = rf.readUTF();
            TagCount tC = new TagCount();
            tC.read(rf);
            int numTags = tC.numTags();
            if (numTags > maxNumTags) {
                maxNumTags = numTags;
            }
            this.dict.put(word, tC);
        }
    }

    private void readTags(DataInputStream rf) throws IOException {
        int maxNumTags = 0;
        int len = rf.readInt();
        for (int i = 0; i < len; ++i) {
            String word = rf.readUTF();
            TagCount tC = new TagCount();
            tC.read(rf);
            int numTags = tC.numTags();
            if (numTags > maxNumTags) {
                maxNumTags = numTags;
            }
            this.dict.put(word, tC);
        }
    }

    protected void read(String filename) {
        try {
            InDataStreamFile rf = new InDataStreamFile(filename);
            this.read(rf, filename);
            int len1 = rf.readInt();
            for (int i = 0; i < len1; ++i) {
                int iO = rf.readInt();
                CountWrapper tC = new CountWrapper();
                tC.read(rf);
                this.partTakingVerbs.put(iO, tC);
            }
            rf.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void read(DataInputStream file) {
        try {
            this.readTags(file);
            int len1 = file.readInt();
            for (int i = 0; i < len1; ++i) {
                int iO = file.readInt();
                CountWrapper tC = new CountWrapper();
                tC.read(file);
                this.partTakingVerbs.put(iO, tC);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void setAmbClasses(AmbiguityClasses ambClasses, int veryCommonWordThresh, TTags ttags) {
        for (Map.Entry<String, TagCount> entry : this.dict.entrySet()) {
            String w = entry.getKey();
            TagCount tc = entry.getValue();
            int ambClassId = ambClasses.getClass(w, this, veryCommonWordThresh, ttags);
            tc.setAmbClassId(ambClassId);
        }
    }

    protected int getAmbClass(String word) {
        if (word.equals(naWord)) {
            return -2;
        }
        if (this.get(word) == null) {
            return -1;
        }
        return this.get(word).getAmbClassId();
    }

    public static void main(String[] args) {
        String s = "word";
        String tag = "tag";
        Dictionary d = new Dictionary();
        System.out.println(d.getCount(s, tag));
        System.out.println(d.getFirstTag(s));
    }
}

