/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sequences;

import edu.stanford.nlp.util.ArrayUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Clique
implements Serializable {
    private static final long serialVersionUID = -8109637472035159453L;
    private int[] relativeIndices;
    protected static Map<CliqueEqualityWrapper, Clique> interner = new HashMap<CliqueEqualityWrapper, Clique>();
    private int hashCode = -1;

    private static Clique intern(Clique c) {
        CliqueEqualityWrapper wrapper = new CliqueEqualityWrapper(c);
        Clique newC = interner.get(wrapper);
        if (newC == null) {
            interner.put(wrapper, c);
            newC = c;
        }
        return newC;
    }

    private Clique() {
    }

    public static Clique valueOf(int maxLeft, int maxRight) {
        int[] ri = new int[-maxLeft + maxRight + 1];
        int j = maxLeft;
        for (int i = 0; i < ri.length; ++i) {
            ri[i] = j++;
        }
        return Clique.valueOfHelper(ri);
    }

    public static Clique valueOf(int[] relativeIndices) {
        Clique.checkSorted(relativeIndices);
        return Clique.valueOfHelper(ArrayUtils.copy(relativeIndices));
    }

    public static Clique valueOf(Clique c, int offset) {
        int[] ri = new int[c.relativeIndices.length];
        for (int i = 0; i < ri.length; ++i) {
            ri[i] = c.relativeIndices[i] + offset;
        }
        return Clique.valueOfHelper(ri);
    }

    private static Clique valueOfHelper(int[] relativeIndices) {
        Clique c = new Clique();
        c.relativeIndices = relativeIndices;
        return Clique.intern(c);
    }

    private static void checkSorted(int[] sorted) {
        for (int i = 0; i < sorted.length - 1; ++i) {
            if (sorted[i] <= sorted[i + 1]) continue;
            throw new RuntimeException("input must be sorted!");
        }
    }

    public int maxLeft() {
        return this.relativeIndices[0];
    }

    public int maxRight() {
        return this.relativeIndices[this.relativeIndices.length - 1];
    }

    public int size() {
        return this.relativeIndices.length;
    }

    public int relativeIndex(int i) {
        return this.relativeIndices[i];
    }

    public int indexOfRelativeIndex(int relativeIndex) {
        for (int i = 0; i < this.relativeIndices.length; ++i) {
            if (this.relativeIndices[i] != relativeIndex) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < this.relativeIndices.length; ++i) {
            sb.append(this.relativeIndices[i]);
            if (i == this.relativeIndices.length - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public Clique leftMessage() {
        int[] ri = new int[this.relativeIndices.length - 1];
        System.arraycopy(this.relativeIndices, 0, ri, 0, ri.length);
        return Clique.valueOfHelper(ri);
    }

    public Clique rightMessage() {
        int[] ri = new int[this.relativeIndices.length - 1];
        System.arraycopy(this.relativeIndices, 1, ri, 0, ri.length);
        return Clique.valueOfHelper(ri);
    }

    public Clique shift(int shiftAmount) {
        if (shiftAmount == 0) {
            return this;
        }
        int[] ri = new int[this.relativeIndices.length];
        for (int i = 0; i < ri.length; ++i) {
            ri[i] = this.relativeIndices[i] + shiftAmount;
        }
        return Clique.valueOfHelper(ri);
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = this.toString().hashCode();
        }
        return this.hashCode;
    }

    protected Object readResolve() {
        return Clique.intern(this);
    }

    private static class CliqueEqualityWrapper {
        private Clique c;

        public CliqueEqualityWrapper(Clique c) {
            this.c = c;
        }

        public boolean equals(Object o) {
            if (!(o instanceof CliqueEqualityWrapper)) {
                return false;
            }
            CliqueEqualityWrapper otherC = (CliqueEqualityWrapper)o;
            if (otherC.c.relativeIndices.length != this.c.relativeIndices.length) {
                return false;
            }
            for (int i = 0; i < this.c.relativeIndices.length; ++i) {
                if (this.c.relativeIndices[i] == otherC.c.relativeIndices[i]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int h = 1;
            for (int i : this.c.relativeIndices) {
                h *= 17;
                h += i;
            }
            return h;
        }
    }
}

