package XTaTIK::Docs;

use strict;
use warnings;

our $VERSION = '0.003001'; # VERSION

1;
__END__

=encoding utf8

=for stopwords eCommerce conf _conf XTaTIK_conf

=head1 NAME

XTaTIK::Docs - Index of documentation for XTaTIK eCommerce system

=head1 INDEX OF THE DOCUMENTATION

=head2 Getting Started

=over 4

=item * L<XTaTIK::Docs::01_Installation>—Installation instructions

=item * L<XTaTIK::Docs::02_PreparingCompanySilo>—Preparation of company-wide config and files

=item * L<XTaTIK::Docs::03_PreparingSiteSilo>—Preparation of
    site-specific config

=item * L<XTaTIK::Docs::03_PreparingSiteSilo>—Preparation of site-specific config

=item * L<XTaTIK::Docs::04_Launch>—Launching your first XTaTIK website

=back

=head2 Appendices

=over 4

=item * L<XTaTIK::Docs::Appendix::XTaTIK_conf>—Explanation
    of XTaTIK.conf parameters

=item * L<XTaTIK::Docs::Appendix::StaticFiles>—Map of XTaTIK static
    files you can override

=item * L<XTaTIK::Docs::Appendix::Templates>—Map of XTaTIK template
    files you can override

=back

=cut

