# Generated by default/object.tt
package Paws::SageMaker::ProcessingInput;
  use Moose;
  has AppManaged => (is => 'ro', isa => 'Bool');
  has DatasetDefinition => (is => 'ro', isa => 'Paws::SageMaker::DatasetDefinition');
  has InputName => (is => 'ro', isa => 'Str', required => 1);
  has S3Input => (is => 'ro', isa => 'Paws::SageMaker::ProcessingS3Input');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::ProcessingInput

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::ProcessingInput object:

  $service_obj->Method(Att1 => { AppManaged => $value, ..., S3Input => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::ProcessingInput object:

  $result = $service_obj->Method(...);
  $result->Att1->AppManaged

=head1 DESCRIPTION

The inputs for a processing job. The processing input must specify
exactly one of either C<S3Input> or C<DatasetDefinition> types.

=head1 ATTRIBUTES


=head2 AppManaged => Bool

When C<True>, input operations such as data download are managed
natively by the processing job application. When C<False> (default),
input operations are managed by Amazon SageMaker.


=head2 DatasetDefinition => L<Paws::SageMaker::DatasetDefinition>

Configuration for a Dataset Definition input.


=head2 B<REQUIRED> InputName => Str

The name for the processing job input.


=head2 S3Input => L<Paws::SageMaker::ProcessingS3Input>

Configuration for downloading input data from Amazon S3 into the
processing container.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

