# Generated by default/object.tt
package Paws::ACMPCA::EdiPartyName;
  use Moose;
  has NameAssigner => (is => 'ro', isa => 'Str');
  has PartyName => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ACMPCA::EdiPartyName

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ACMPCA::EdiPartyName object:

  $service_obj->Method(Att1 => { NameAssigner => $value, ..., PartyName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ACMPCA::EdiPartyName object:

  $result = $service_obj->Method(...);
  $result->Att1->NameAssigner

=head1 DESCRIPTION

Describes an Electronic Data Interchange (EDI) entity as described in
as defined in Subject Alternative Name
(https://tools.ietf.org/html/rfc5280) in RFC 5280.

=head1 ATTRIBUTES


=head2 NameAssigner => Str

Specifies the name assigner.


=head2 B<REQUIRED> PartyName => Str

Specifies the party name.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ACMPCA>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

