# Generated by default/object.tt
package Paws::SSMContacts::Receipt;
  use Moose;
  has ContactChannelArn => (is => 'ro', isa => 'Str');
  has ReceiptInfo => (is => 'ro', isa => 'Str');
  has ReceiptTime => (is => 'ro', isa => 'Str', required => 1);
  has ReceiptType => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SSMContacts::Receipt

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SSMContacts::Receipt object:

  $service_obj->Method(Att1 => { ContactChannelArn => $value, ..., ReceiptType => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SSMContacts::Receipt object:

  $result = $service_obj->Method(...);
  $result->Att1->ContactChannelArn

=head1 DESCRIPTION

Records events during an engagement.

=head1 ATTRIBUTES


=head2 ContactChannelArn => Str

The Amazon Resource Name (ARN) of the contact channel Incident Manager
engaged.


=head2 ReceiptInfo => Str

Information provided during the page acknowledgement.


=head2 B<REQUIRED> ReceiptTime => Str

The time receipt was C<SENT>, C<DELIVERED>, or C<READ>.


=head2 B<REQUIRED> ReceiptType => Str

The type follows the engagement cycle, C<SENT>, C<DELIVERED>, and
C<READ>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SSMContacts>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

