# APIs for Windows 32-bit ntdll library.
# Format:  rettype, retname, callconv, exactname, arglist(type, name)
#          arglist type is one of ['int', 'void *']
#          arglist name is one of [None, 'funcptr', 'obj', 'ptr']

api_defs = {
    'ntdll.main_entry':( 'int', None, 'stdcall', 'ntdll.main_entry', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.seh3_prolog':('int', None, 'stdcall', 'ntdll.seh3_prolog', (('struct SEH3_SCOPETABLE *','pScopeTable'),('int','dwAllocSize'))),
    'ntdll.seh4_prolog':('int', None, 'stdcall', 'ntdll.seh4_prolog', (('void *','pScopeTable'),('int','dwAllocSize'))),
    'ntdll.seh4_gs_prolog':('int', None, 'stdcall', 'ntdll.seh4_gs_prolog', (('void *','pScopeTable'),('int','dwAllocSize'))),

    'ntdll.seh3_epilog':('int', None, 'stdcall', 'ntdll.seh3_epilog', ()),
    'ntdll.seh4_epilog':('int', None, 'stdcall', 'ntdll.seh4_epilog', ()),

    'ntdll.eh_prolog':('int', None, 'stdcall', 'ntdll.eh_prolog', ()),
    'ntdll.gs_prolog':('int', None, 'stdcall', 'ntdll.gs_prolog', ()),
    'ntdll._alloca_probe':('void', None, 'cdecl', 'ntdll._alloca_probe', ()),

    'ntdll.security_check_cookie':('void', None, 'msfastcall', 'ntdll.security_check_cookie', (('int', None),)),

    'ntdll.csrallocatecapturebuffer':( 'int', None, 'stdcall', 'ntdll.CsrAllocateCaptureBuffer', (('int', None), ('int', None)) ),
    'ntdll.csrallocatemessagepointer':( 'int', None, 'stdcall', 'ntdll.CsrAllocateMessagePointer', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.csrcapturemessagebuffer':( 'int', None, 'stdcall', 'ntdll.CsrCaptureMessageBuffer', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.csrcapturemessagemultiunicodestringsinplace':( 'int', None, 'stdcall', 'ntdll.CsrCaptureMessageMultiUnicodeStringsInPlace', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.csrcapturemessagestring':( 'int', None, 'stdcall', 'ntdll.CsrCaptureMessageString', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.csrcapturetimeout':( 'int', None, 'stdcall', 'ntdll.CsrCaptureTimeout', (('int', None), ('int', None)) ),
    'ntdll.csrclientcallserver':( 'int', None, 'stdcall', 'ntdll.CsrClientCallServer', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.csrclientconnecttoserver':( 'int', None, 'stdcall', 'ntdll.CsrClientConnectToServer', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.csrfreecapturebuffer':( 'int', None, 'stdcall', 'ntdll.CsrFreeCaptureBuffer', (('void *', 'ptr'),) ),
    'ntdll.csrgetprocessid':( 'int', None, 'cdecl', 'ntdll.CsrGetProcessId', () ),
    'ntdll.csridentifyalertablethread':( 'int', None, 'cdecl', 'ntdll.CsrIdentifyAlertableThread', () ),
    'ntdll.csrnewthread':( 'int', None, 'cdecl', 'ntdll.CsrNewThread', () ),
    'ntdll.csrprobeforread':( 'int', None, 'stdcall', 'ntdll.CsrProbeForRead', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.csrprobeforwrite':( 'int', None, 'stdcall', 'ntdll.CsrProbeForWrite', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.csrsetpriorityclass':( 'int', None, 'stdcall', 'ntdll.CsrSetPriorityClass', (('int', None), ('int', None)) ),
    'ntdll.dbgbreakpoint':( 'int', None, 'cdecl', 'ntdll.DbgBreakPoint', () ),
    'ntdll.dbgprint':( 'int', None, 'cdecl', 'ntdll.DbgPrint', (('int', None),) ),
    'ntdll.dbgprintex':( 'int', None, 'cdecl', 'ntdll.DbgPrintEx', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.dbgprintreturncontrolc':( 'int', None, 'cdecl', 'ntdll.DbgPrintReturnControlC', (('int', None),) ),
    'ntdll.dbgprompt':( 'int', None, 'stdcall', 'ntdll.DbgPrompt', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.dbgquerydebugfilterstate':( 'int', None, 'stdcall', 'ntdll.DbgQueryDebugFilterState', (('int', None), ('int', None)) ),
    'ntdll.dbgsetdebugfilterstate':( 'int', None, 'stdcall', 'ntdll.DbgSetDebugFilterState', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.dbguiconnecttodbg':( 'int', None, 'cdecl', 'ntdll.DbgUiConnectToDbg', () ),
    'ntdll.dbguicontinue':( 'int', None, 'stdcall', 'ntdll.DbgUiContinue', (('int', None), ('int', None)) ),
    'ntdll.dbguiconvertstatechangestructure':( 'int', None, 'stdcall', 'ntdll.DbgUiConvertStateChangeStructure', (('int', None), ('int', None)) ),
    'ntdll.dbguidebugactiveprocess':( 'int', None, 'stdcall', 'ntdll.DbgUiDebugActiveProcess', (('int', None),) ),
    'ntdll.dbguigetthreaddebugobject':( 'int', None, 'cdecl', 'ntdll.DbgUiGetThreadDebugObject', () ),
    'ntdll.dbguiissueremotebreakin':( 'int', None, 'stdcall', 'ntdll.DbgUiIssueRemoteBreakin', (('int', None),) ),
    'ntdll.dbguiremotebreakin':( 'int', None, 'stdcall', 'ntdll.DbgUiRemoteBreakin', () ),
    'ntdll.dbguisetthreaddebugobject':( 'int', None, 'stdcall', 'ntdll.DbgUiSetThreadDebugObject', (('int', None),) ),
    'ntdll.dbguistopdebugging':( 'int', None, 'stdcall', 'ntdll.DbgUiStopDebugging', (('int', None),) ),
    'ntdll.dbguiwaitstatechange':( 'int', None, 'stdcall', 'ntdll.DbgUiWaitStateChange', (('int', None), ('int', None)) ),
    'ntdll.dbguserbreakpoint':( 'int', None, 'cdecl', 'ntdll.DbgUserBreakPoint', () ),
    'ntdll.kifastsystemcall':( 'int', None, 'cdecl', 'ntdll.KiFastSystemCall', () ),
    'ntdll.kifastsystemcallret':( 'int', None, 'cdecl', 'ntdll.KiFastSystemCallRet', () ),
    'ntdll.kiintsystemcall':( 'int', None, 'cdecl', 'ntdll.KiIntSystemCall', () ),
    'ntdll.kiraiseuserexceptiondispatcher':( 'int', None, 'cdecl', 'ntdll.KiRaiseUserExceptionDispatcher', () ),
    'ntdll.kiuserapcdispatcher':( 'int', None, 'cdecl', 'ntdll.KiUserApcDispatcher', (('int', None), ('int', None)) ),
    'ntdll.kiusercallbackdispatcher':( 'int', None, 'cdecl', 'ntdll.KiUserCallbackDispatcher', (('int', None),) ),
    'ntdll.kiuserexceptiondispatcher':( 'int', None, 'stdcall', 'ntdll.KiUserExceptionDispatcher', ( ('int', None),) ),
    'ntdll.ldraccessoutofprocessresource':( 'int', None, 'stdcall', 'ntdll.LdrAccessOutOfProcessResource', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.ldraccessresource':( 'int', None, 'stdcall', 'ntdll.LdrAccessResource', (('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.ldraddrefdll':( 'int', None, 'stdcall', 'ntdll.LdrAddRefDll', (('int', None), ('int', None)) ),
    'ntdll.ldralternateresourcesenabled':( 'int', None, 'cdecl', 'ntdll.LdrAlternateResourcesEnabled', () ),
    'ntdll.ldrcreateoutofprocessimage':( 'int', None, 'stdcall', 'ntdll.LdrCreateOutOfProcessImage', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ldrdestroyoutofprocessimage':( 'int', None, 'stdcall', 'ntdll.LdrDestroyOutOfProcessImage', (('int', None),) ),
    'ntdll.ldrdisablethreadcalloutsfordll':( 'int', None, 'stdcall', 'ntdll.LdrDisableThreadCalloutsForDll', (('int', None),) ),
    'ntdll.ldrenumresources':( 'int', None, 'stdcall', 'ntdll.LdrEnumResources', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ldrenumerateloadedmodules':( 'int', None, 'stdcall', 'ntdll.LdrEnumerateLoadedModules', (('int', None), ('void *', 'funcptr'), ('int', None)) ),
    'ntdll.ldrfindcreateprocessmanifest':( 'int', None, 'stdcall', 'ntdll.LdrFindCreateProcessManifest', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ldrfindentryforaddress':( 'int', None, 'stdcall', 'ntdll.LdrFindEntryForAddress', (('int', None), ('void *', 'ptr')) ),
    'ntdll.ldrfindresourcedirectory_u':( 'int', None, 'stdcall', 'ntdll.LdrFindResourceDirectory_U', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ldrfindresourceex_u':( 'int', None, 'stdcall', 'ntdll.LdrFindResourceEx_U', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ldrfindresource_u':( 'int', None, 'stdcall', 'ntdll.LdrFindResource_U', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ldrflushalternateresourcemodules':( 'int', None, 'cdecl', 'ntdll.LdrFlushAlternateResourceModules', () ),
    'ntdll.ldrgetdllhandle':( 'int', None, 'stdcall', 'ntdll.LdrGetDllHandle', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.ldrgetdllhandleex':( 'int', None, 'stdcall', 'ntdll.LdrGetDllHandleEx', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.ldrgetprocedureaddress':( 'int', None, 'stdcall', 'ntdll.LdrGetProcedureAddress', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ldrhotpatchroutine':( 'int', None, 'cdecl', 'ntdll.LdrHotPatchRoutine', (('int', None),) ),
    'ntdll.ldrinitshimenginedynamic':( 'int', None, 'stdcall', 'ntdll.LdrInitShimEngineDynamic', (('int', None),) ),
    'ntdll.ldrinitializethunk':( 'int', None, 'stdcall', 'ntdll.LdrInitializeThunk', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ldrloadalternateresourcemodule':( 'int', None, 'stdcall', 'ntdll.LdrLoadAlternateResourceModule', (('int', None), ('int', None)) ),
    'ntdll.ldrloaddll':( 'int', None, 'stdcall', 'ntdll.LdrLoadDll', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.ldrlockloaderlock':( 'int', None, 'stdcall', 'ntdll.LdrLockLoaderLock', (('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.ldrprocessrelocationblock':( 'int', None, 'stdcall', 'ntdll.LdrProcessRelocationBlock', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ldrqueryimagefileexecutionoptions':( 'int', None, 'stdcall', 'ntdll.LdrQueryImageFileExecutionOptions', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ldrqueryprocessmoduleinformation':( 'int', None, 'stdcall', 'ntdll.LdrQueryProcessModuleInformation', ( ('int', None), ('int', None)) ),
    'ntdll.ldrsetappcompatdllredirectioncallback':( 'int', None, 'stdcall', 'ntdll.LdrSetAppCompatDllRedirectionCallback', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ldrsetdllmanifestprober':( 'int', None, 'stdcall', 'ntdll.LdrSetDllManifestProber', (('int', None),) ),
    'ntdll.ldrshutdownprocess':( 'int', None, 'cdecl', 'ntdll.LdrShutdownProcess', () ),
    'ntdll.ldrshutdownthread':( 'int', None, 'stdcall', 'ntdll.LdrShutdownThread', () ),
    'ntdll.ldrunloadalternateresourcemodule':( 'int', None, 'stdcall', 'ntdll.LdrUnloadAlternateResourceModule', (('int', None),) ),
    'ntdll.ldrunloaddll':( 'int', None, 'stdcall', 'ntdll.LdrUnloadDll', ( ('int', None),) ),
    'ntdll.ldrunlockloaderlock':( 'int', None, 'stdcall', 'ntdll.LdrUnlockLoaderLock', (('int', None), ('int', None)) ),
    'ntdll.ldrverifyimagematcheschecksum':( 'int', None, 'stdcall', 'ntdll.LdrVerifyImageMatchesChecksum', (('int', None), ('void *', 'funcptr'), ('int', None), ('int', None)) ),
    'ntdll.nlsansicodepage':( 'int', None, 'cdecl', 'ntdll.NlsAnsiCodePage', () ),
    'ntdll.nlsmbcodepagetag':( 'int', None, 'cdecl', 'ntdll.NlsMbCodePageTag', () ),
    'ntdll.nlsmboemcodepagetag':( 'int', None, 'cdecl', 'ntdll.NlsMbOemCodePageTag', () ),
    'ntdll.ntacceptconnectport':( 'int', None, 'stdcall', 'ntdll.NtAcceptConnectPort', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntaccesscheck':( 'int', None, 'stdcall', 'ntdll.NtAccessCheck', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntaccesscheckandauditalarm':( 'int', None, 'stdcall', 'ntdll.NtAccessCheckAndAuditAlarm', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntaccesscheckbytype':( 'int', None, 'stdcall', 'ntdll.NtAccessCheckByType', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntaccesscheckbytypeandauditalarm':( 'int', None, 'stdcall', 'ntdll.NtAccessCheckByTypeAndAuditAlarm', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntaccesscheckbytyperesultlist':( 'int', None, 'stdcall', 'ntdll.NtAccessCheckByTypeResultList', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntaccesscheckbytyperesultlistandauditalarm':( 'int', None, 'stdcall', 'ntdll.NtAccessCheckByTypeResultListAndAuditAlarm', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntaccesscheckbytyperesultlistandauditalarmbyhandle':( 'int', None, 'stdcall', 'ntdll.NtAccessCheckByTypeResultListAndAuditAlarmByHandle', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntaddatom':( 'int', None, 'stdcall', 'ntdll.NtAddAtom', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntaddbootentry':( 'int', None, 'stdcall', 'ntdll.NtAddBootEntry', (('int', None), ('int', None)) ),
    'ntdll.ntadjustgroupstoken':( 'int', None, 'stdcall', 'ntdll.NtAdjustGroupsToken', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntadjustprivilegestoken':( 'int', None, 'stdcall', 'ntdll.NtAdjustPrivilegesToken', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.ntalertresumethread':( 'int', None, 'stdcall', 'ntdll.NtAlertResumeThread', (('int', None), ('int', None)) ),
    'ntdll.ntalertthread':( 'int', None, 'stdcall', 'ntdll.NtAlertThread', (('int', None),) ),
    'ntdll.ntallocatelocallyuniqueid':( 'int', None, 'stdcall', 'ntdll.NtAllocateLocallyUniqueId', (('int', None),) ),
    'ntdll.ntallocateuserphysicalpages':( 'int', None, 'stdcall', 'ntdll.NtAllocateUserPhysicalPages', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntallocateuuids':( 'int', None, 'stdcall', 'ntdll.NtAllocateUuids', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.ntallocatevirtualmemory':( 'int', None, 'stdcall', 'ntdll.NtAllocateVirtualMemory', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.ntaremappedfilesthesame':( 'int', None, 'stdcall', 'ntdll.NtAreMappedFilesTheSame', (('int', None), ('int', None)) ),
    'ntdll.ntassignprocesstojobobject':( 'int', None, 'stdcall', 'ntdll.NtAssignProcessToJobObject', (('int', None), ('int', None)) ),
    'ntdll.ntcallbackreturn':( 'int', None, 'stdcall', 'ntdll.NtCallbackReturn', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcanceldevicewakeuprequest':( 'int', None, 'stdcall', 'ntdll.NtCancelDeviceWakeupRequest', (('int', None),) ),
    'ntdll.ntcanceliofile':( 'int', None, 'stdcall', 'ntdll.NtCancelIoFile', (('int', None), ('void *', 'ptr')) ),
    'ntdll.ntcanceltimer':( 'int', None, 'stdcall', 'ntdll.NtCancelTimer', (('int', None), ('int', None)) ),
    'ntdll.ntclearevent':( 'int', None, 'stdcall', 'ntdll.NtClearEvent', (('int', None),) ),
    'ntdll.ntclose':( 'int', None, 'stdcall', 'ntdll.NtClose', (('int', None),) ),
    'ntdll.ntcloseobjectauditalarm':( 'int', None, 'stdcall', 'ntdll.NtCloseObjectAuditAlarm', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcompactkeys':( 'int', None, 'stdcall', 'ntdll.NtCompactKeys', (('int', None), ('int', None)) ),
    'ntdll.ntcomparetokens':( 'int', None, 'stdcall', 'ntdll.NtCompareTokens', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcompleteconnectport':( 'int', None, 'stdcall', 'ntdll.NtCompleteConnectPort', (('int', None),) ),
    'ntdll.ntcompresskey':( 'int', None, 'stdcall', 'ntdll.NtCompressKey', (('int', None),) ),
    'ntdll.ntconnectport':( 'int', None, 'stdcall', 'ntdll.NtConnectPort', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcontinue':( 'int', None, 'stdcall', 'ntdll.NtContinue', (('void *', 'ptr'), ('int', None)) ),
    'ntdll.ntcreatedebugobject':( 'int', None, 'stdcall', 'ntdll.NtCreateDebugObject', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.ntcreatedirectoryobject':( 'int', None, 'stdcall', 'ntdll.NtCreateDirectoryObject', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcreateevent':( 'int', None, 'stdcall', 'ntdll.NtCreateEvent', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcreateeventpair':( 'int', None, 'stdcall', 'ntdll.NtCreateEventPair', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcreatefile':( 'int', None, 'stdcall', 'ntdll.NtCreateFile', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcreateiocompletion':( 'int', None, 'stdcall', 'ntdll.NtCreateIoCompletion', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcreatejobobject':( 'int', None, 'stdcall', 'ntdll.NtCreateJobObject', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcreatejobset':( 'int', None, 'stdcall', 'ntdll.NtCreateJobSet', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcreatekey':( 'int', None, 'stdcall', 'ntdll.NtCreateKey', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntcreatekeyedevent':( 'int', None, 'stdcall', 'ntdll.NtCreateKeyedEvent', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcreatemailslotfile':( 'int', None, 'stdcall', 'ntdll.NtCreateMailslotFile', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcreatemutant':( 'int', None, 'stdcall', 'ntdll.NtCreateMutant', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcreatenamedpipefile':( 'int', None, 'stdcall', 'ntdll.NtCreateNamedPipeFile', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcreatepagingfile':( 'int', None, 'stdcall', 'ntdll.NtCreatePagingFile', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcreateport':( 'int', None, 'stdcall', 'ntdll.NtCreatePort', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcreateprocess':( 'int', None, 'stdcall', 'ntdll.NtCreateProcess', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcreateprocessex':( 'int', None, 'stdcall', 'ntdll.NtCreateProcessEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcreateprofile':( 'int', None, 'stdcall', 'ntdll.NtCreateProfile', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcreatesection':( 'int', None, 'stdcall', 'ntdll.NtCreateSection', (('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcreatesemaphore':( 'int', None, 'stdcall', 'ntdll.NtCreateSemaphore', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcreatesymboliclinkobject':( 'int', None, 'stdcall', 'ntdll.NtCreateSymbolicLinkObject', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcreatethread':( 'int', None, 'stdcall', 'ntdll.NtCreateThread', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.ntcreatetimer':( 'int', None, 'stdcall', 'ntdll.NtCreateTimer', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcreatetoken':( 'int', None, 'stdcall', 'ntdll.NtCreateToken', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcreatewaitableport':( 'int', None, 'stdcall', 'ntdll.NtCreateWaitablePort', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntcurrentteb':( 'int', None, 'cdecl', 'ntdll.NtCurrentTeb', () ),
    'ntdll.ntdebugactiveprocess':( 'int', None, 'stdcall', 'ntdll.NtDebugActiveProcess', (('int', None), ('int', None)) ),
    'ntdll.ntdebugcontinue':( 'int', None, 'stdcall', 'ntdll.NtDebugContinue', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntdelayexecution':( 'int', None, 'stdcall', 'ntdll.NtDelayExecution', (('int', None), ('void *', 'ptr')) ),
    'ntdll.ntdeleteatom':( 'int', None, 'stdcall', 'ntdll.NtDeleteAtom', (('int', None),) ),
    'ntdll.ntdeletebootentry':( 'int', None, 'stdcall', 'ntdll.NtDeleteBootEntry', (('int', None),) ),
    'ntdll.ntdeletefile':( 'int', None, 'stdcall', 'ntdll.NtDeleteFile', (('int', None),) ),
    'ntdll.ntdeletekey':( 'int', None, 'stdcall', 'ntdll.NtDeleteKey', (('int', None),) ),
    'ntdll.ntdeleteobjectauditalarm':( 'int', None, 'stdcall', 'ntdll.NtDeleteObjectAuditAlarm', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntdeletevaluekey':( 'int', None, 'stdcall', 'ntdll.NtDeleteValueKey', (('int', None), ('void *', 'ptr')) ),
    'ntdll.ntdeviceiocontrolfile':( 'int', None, 'stdcall', 'ntdll.NtDeviceIoControlFile', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntdisplaystring':( 'int', None, 'stdcall', 'ntdll.NtDisplayString', (('int', None),) ),
    'ntdll.ntduplicateobject':( 'int', None, 'stdcall', 'ntdll.NtDuplicateObject', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntduplicatetoken':( 'int', None, 'stdcall', 'ntdll.NtDuplicateToken', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntenumeratebootentries':( 'int', None, 'stdcall', 'ntdll.NtEnumerateBootEntries', (('int', None), ('int', None)) ),
    'ntdll.ntenumeratekey':( 'int', None, 'stdcall', 'ntdll.NtEnumerateKey', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntenumeratesystemenvironmentvaluesex':( 'int', None, 'stdcall', 'ntdll.NtEnumerateSystemEnvironmentValuesEx', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntenumeratevaluekey':( 'int', None, 'stdcall', 'ntdll.NtEnumerateValueKey', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntextendsection':( 'int', None, 'stdcall', 'ntdll.NtExtendSection', (('int', None), ('int', None)) ),
    'ntdll.ntfiltertoken':( 'int', None, 'stdcall', 'ntdll.NtFilterToken', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntfindatom':( 'int', None, 'stdcall', 'ntdll.NtFindAtom', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntflushbuffersfile':( 'int', None, 'stdcall', 'ntdll.NtFlushBuffersFile', (('int', None), ('void *', 'ptr')) ),
    'ntdll.ntflushinstructioncache':( 'int', None, 'stdcall', 'ntdll.NtFlushInstructionCache', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntflushkey':( 'int', None, 'stdcall', 'ntdll.NtFlushKey', (('int', None),) ),
    'ntdll.ntflushvirtualmemory':( 'int', None, 'stdcall', 'ntdll.NtFlushVirtualMemory', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntflushwritebuffer':( 'int', None, 'cdecl', 'ntdll.NtFlushWriteBuffer', () ),
    'ntdll.ntfreeuserphysicalpages':( 'int', None, 'stdcall', 'ntdll.NtFreeUserPhysicalPages', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntfreevirtualmemory':( 'int', None, 'stdcall', 'ntdll.NtFreeVirtualMemory', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.ntfscontrolfile':( 'int', None, 'stdcall', 'ntdll.NtFsControlFile', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntgetcontextthread':( 'int', None, 'stdcall', 'ntdll.NtGetContextThread', (('int', None), ('void *', 'ptr')) ),
    'ntdll.ntgetdevicepowerstate':( 'int', None, 'stdcall', 'ntdll.NtGetDevicePowerState', (('int', None), ('int', None)) ),
    'ntdll.ntgetplugplayevent':( 'int', None, 'stdcall', 'ntdll.NtGetPlugPlayEvent', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntgetwritewatch':( 'int', None, 'stdcall', 'ntdll.NtGetWriteWatch', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntimpersonateanonymoustoken':( 'int', None, 'stdcall', 'ntdll.NtImpersonateAnonymousToken', (('int', None),) ),
    'ntdll.ntimpersonateclientofport':( 'int', None, 'stdcall', 'ntdll.NtImpersonateClientOfPort', (('int', None), ('int', None)) ),
    'ntdll.ntimpersonatethread':( 'int', None, 'stdcall', 'ntdll.NtImpersonateThread', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntinitializeregistry':( 'int', None, 'stdcall', 'ntdll.NtInitializeRegistry', (('int', None),) ),
    'ntdll.ntinitiatepoweraction':( 'int', None, 'stdcall', 'ntdll.NtInitiatePowerAction', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntisprocessinjob':( 'int', None, 'stdcall', 'ntdll.NtIsProcessInJob', (('int', None), ('int', None)) ),
    'ntdll.ntissystemresumeautomatic':( 'int', None, 'cdecl', 'ntdll.NtIsSystemResumeAutomatic', () ),
    'ntdll.ntlistenport':( 'int', None, 'stdcall', 'ntdll.NtListenPort', (('int', None), ('int', None)) ),
    'ntdll.ntloaddriver':( 'int', None, 'stdcall', 'ntdll.NtLoadDriver', (('int', None),) ),
    'ntdll.ntloadkey':( 'int', None, 'stdcall', 'ntdll.NtLoadKey', (('int', None), ('int', None)) ),
    'ntdll.ntloadkey2':( 'int', None, 'stdcall', 'ntdll.NtLoadKey2', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntlockfile':( 'int', None, 'stdcall', 'ntdll.NtLockFile', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntlockproductactivationkeys':( 'int', None, 'stdcall', 'ntdll.NtLockProductActivationKeys', (('int', None), ('int', None)) ),
    'ntdll.ntlockregistrykey':( 'int', None, 'stdcall', 'ntdll.NtLockRegistryKey', (('int', None),) ),
    'ntdll.ntlockvirtualmemory':( 'int', None, 'stdcall', 'ntdll.NtLockVirtualMemory', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntmakepermanentobject':( 'int', None, 'stdcall', 'ntdll.NtMakePermanentObject', (('int', None),) ),
    'ntdll.ntmaketemporaryobject':( 'int', None, 'stdcall', 'ntdll.NtMakeTemporaryObject', (('int', None),) ),
    'ntdll.ntmapuserphysicalpages':( 'int', None, 'stdcall', 'ntdll.NtMapUserPhysicalPages', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntmapuserphysicalpagesscatter':( 'int', None, 'stdcall', 'ntdll.NtMapUserPhysicalPagesScatter', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntmapviewofsection':( 'int', None, 'stdcall', 'ntdll.NtMapViewOfSection', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntmodifybootentry':( 'int', None, 'stdcall', 'ntdll.NtModifyBootEntry', (('int', None),) ),
    'ntdll.ntnotifychangedirectoryfile':( 'int', None, 'stdcall', 'ntdll.NtNotifyChangeDirectoryFile', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntnotifychangekey':( 'int', None, 'stdcall', 'ntdll.NtNotifyChangeKey', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntnotifychangemultiplekeys':( 'int', None, 'stdcall', 'ntdll.NtNotifyChangeMultipleKeys', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntopendirectoryobject':( 'int', None, 'stdcall', 'ntdll.NtOpenDirectoryObject', (('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntopenevent':( 'int', None, 'stdcall', 'ntdll.NtOpenEvent', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntopeneventpair':( 'int', None, 'stdcall', 'ntdll.NtOpenEventPair', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntopenfile':( 'int', None, 'stdcall', 'ntdll.NtOpenFile', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.ntopeniocompletion':( 'int', None, 'stdcall', 'ntdll.NtOpenIoCompletion', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntopenjobobject':( 'int', None, 'stdcall', 'ntdll.NtOpenJobObject', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntopenkey':( 'int', None, 'stdcall', 'ntdll.NtOpenKey', (('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntopenkeyedevent':( 'int', None, 'stdcall', 'ntdll.NtOpenKeyedEvent', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntopenmutant':( 'int', None, 'stdcall', 'ntdll.NtOpenMutant', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntopenobjectauditalarm':( 'int', None, 'stdcall', 'ntdll.NtOpenObjectAuditAlarm', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntopenprocess':( 'int', None, 'stdcall', 'ntdll.NtOpenProcess', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.ntopenprocesstoken':( 'int', None, 'stdcall', 'ntdll.NtOpenProcessToken', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntopenprocesstokenex':( 'int', None, 'stdcall', 'ntdll.NtOpenProcessTokenEx', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntopensection':( 'int', None, 'stdcall', 'ntdll.NtOpenSection', (('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntopensemaphore':( 'int', None, 'stdcall', 'ntdll.NtOpenSemaphore', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntopensymboliclinkobject':( 'int', None, 'stdcall', 'ntdll.NtOpenSymbolicLinkObject', (('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntopenthread':( 'int', None, 'stdcall', 'ntdll.NtOpenThread', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.ntopenthreadtoken':( 'int', None, 'stdcall', 'ntdll.NtOpenThreadToken', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntopenthreadtokenex':( 'int', None, 'stdcall', 'ntdll.NtOpenThreadTokenEx', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntopentimer':( 'int', None, 'stdcall', 'ntdll.NtOpenTimer', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntplugplaycontrol':( 'int', None, 'stdcall', 'ntdll.NtPlugPlayControl', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntpowerinformation':( 'int', None, 'stdcall', 'ntdll.NtPowerInformation', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntprivilegecheck':( 'int', None, 'stdcall', 'ntdll.NtPrivilegeCheck', (('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.ntprivilegeobjectauditalarm':( 'int', None, 'stdcall', 'ntdll.NtPrivilegeObjectAuditAlarm', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntprivilegedserviceauditalarm':( 'int', None, 'stdcall', 'ntdll.NtPrivilegedServiceAuditAlarm', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntprotectvirtualmemory':( 'int', None, 'stdcall', 'ntdll.NtProtectVirtualMemory', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntpulseevent':( 'int', None, 'stdcall', 'ntdll.NtPulseEvent', (('int', None), ('int', None)) ),
    'ntdll.ntqueryattributesfile':( 'int', None, 'stdcall', 'ntdll.NtQueryAttributesFile', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.ntquerybootentryorder':( 'int', None, 'stdcall', 'ntdll.NtQueryBootEntryOrder', (('int', None), ('int', None)) ),
    'ntdll.ntquerybootoptions':( 'int', None, 'stdcall', 'ntdll.NtQueryBootOptions', (('int', None), ('int', None)) ),
    'ntdll.ntquerydebugfilterstate':( 'int', None, 'stdcall', 'ntdll.NtQueryDebugFilterState', (('int', None), ('int', None)) ),
    'ntdll.ntquerydefaultlocale':( 'int', None, 'stdcall', 'ntdll.NtQueryDefaultLocale', (('int', None), ('void *', 'ptr')) ),
    'ntdll.ntquerydefaultuilanguage':( 'int', None, 'stdcall', 'ntdll.NtQueryDefaultUILanguage', (('int', None),) ),
    'ntdll.ntquerydirectoryfile':( 'int', None, 'stdcall', 'ntdll.NtQueryDirectoryFile', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntquerydirectoryobject':( 'int', None, 'stdcall', 'ntdll.NtQueryDirectoryObject', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntqueryeafile':( 'int', None, 'stdcall', 'ntdll.NtQueryEaFile', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntqueryevent':( 'int', None, 'stdcall', 'ntdll.NtQueryEvent', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntqueryfullattributesfile':( 'int', None, 'stdcall', 'ntdll.NtQueryFullAttributesFile', (('int', None), ('int', None)) ),
    'ntdll.ntqueryinformationatom':( 'int', None, 'stdcall', 'ntdll.NtQueryInformationAtom', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntqueryinformationfile':( 'int', None, 'stdcall', 'ntdll.NtQueryInformationFile', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.ntqueryinformationjobobject':( 'int', None, 'stdcall', 'ntdll.NtQueryInformationJobObject', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntqueryinformationport':( 'int', None, 'stdcall', 'ntdll.NtQueryInformationPort', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntqueryinformationprocess':( 'int', None, 'stdcall', 'ntdll.NtQueryInformationProcess', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.ntqueryinformationthread':( 'int', None, 'stdcall', 'ntdll.NtQueryInformationThread', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.ntqueryinformationtoken':( 'int', None, 'stdcall', 'ntdll.NtQueryInformationToken', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntqueryinstalluilanguage':( 'int', None, 'stdcall', 'ntdll.NtQueryInstallUILanguage', (('int', None),) ),
    'ntdll.ntqueryintervalprofile':( 'int', None, 'stdcall', 'ntdll.NtQueryIntervalProfile', (('int', None), ('int', None)) ),
    'ntdll.ntqueryiocompletion':( 'int', None, 'stdcall', 'ntdll.NtQueryIoCompletion', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.ntquerykey':( 'int', None, 'stdcall', 'ntdll.NtQueryKey', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntquerymultiplevaluekey':( 'int', None, 'stdcall', 'ntdll.NtQueryMultipleValueKey', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntquerymutant':( 'int', None, 'stdcall', 'ntdll.NtQueryMutant', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntqueryobject':( 'int', None, 'stdcall', 'ntdll.NtQueryObject', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntqueryopensubkeys':( 'int', None, 'stdcall', 'ntdll.NtQueryOpenSubKeys', (('int', None), ('int', None)) ),
    'ntdll.ntqueryperformancecounter':( 'int', None, 'stdcall', 'ntdll.NtQueryPerformanceCounter', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.ntqueryportinformationprocess':( 'int', None, 'cdecl', 'ntdll.NtQueryPortInformationProcess', () ),
    'ntdll.ntqueryquotainformationfile':( 'int', None, 'stdcall', 'ntdll.NtQueryQuotaInformationFile', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntquerysection':( 'int', None, 'stdcall', 'ntdll.NtQuerySection', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.ntquerysecurityobject':( 'int', None, 'stdcall', 'ntdll.NtQuerySecurityObject', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntquerysemaphore':( 'int', None, 'stdcall', 'ntdll.NtQuerySemaphore', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntquerysymboliclinkobject':( 'int', None, 'stdcall', 'ntdll.NtQuerySymbolicLinkObject', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntquerysystemenvironmentvalue':( 'int', None, 'stdcall', 'ntdll.NtQuerySystemEnvironmentValue', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntquerysystemenvironmentvalueex':( 'int', None, 'stdcall', 'ntdll.NtQuerySystemEnvironmentValueEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntquerysysteminformation':( 'int', None, 'stdcall', 'ntdll.NtQuerySystemInformation', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntquerysystemtime':( 'int', None, 'stdcall', 'ntdll.NtQuerySystemTime', (('void *', 'ptr'),) ),
    'ntdll.ntquerytimer':( 'int', None, 'stdcall', 'ntdll.NtQueryTimer', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.ntquerytimerresolution':( 'int', None, 'stdcall', 'ntdll.NtQueryTimerResolution', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntqueryvaluekey':( 'int', None, 'stdcall', 'ntdll.NtQueryValueKey', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntqueryvirtualmemory':( 'int', None, 'stdcall', 'ntdll.NtQueryVirtualMemory', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntqueryvolumeinformationfile':( 'int', None, 'stdcall', 'ntdll.NtQueryVolumeInformationFile', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.ntqueueapcthread':( 'int', None, 'stdcall', 'ntdll.NtQueueApcThread', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntraiseexception':( 'int', None, 'stdcall', 'ntdll.NtRaiseException', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.ntraiseharderror':( 'int', None, 'stdcall', 'ntdll.NtRaiseHardError', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntreadfile':( 'int', None, 'stdcall', 'ntdll.NtReadFile', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.ntreadfilescatter':( 'int', None, 'stdcall', 'ntdll.NtReadFileScatter', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntreadrequestdata':( 'int', None, 'stdcall', 'ntdll.NtReadRequestData', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntreadvirtualmemory':( 'int', None, 'stdcall', 'ntdll.NtReadVirtualMemory', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntregisterthreadterminateport':( 'int', None, 'stdcall', 'ntdll.NtRegisterThreadTerminatePort', (('int', None),) ),
    'ntdll.ntreleasekeyedevent':( 'int', None, 'stdcall', 'ntdll.NtReleaseKeyedEvent', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntreleasemutant':( 'int', None, 'stdcall', 'ntdll.NtReleaseMutant', (('int', None), ('int', None)) ),
    'ntdll.ntreleasesemaphore':( 'int', None, 'stdcall', 'ntdll.NtReleaseSemaphore', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntremoveiocompletion':( 'int', None, 'stdcall', 'ntdll.NtRemoveIoCompletion', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.ntremoveprocessdebug':( 'int', None, 'stdcall', 'ntdll.NtRemoveProcessDebug', (('int', None), ('int', None)) ),
    'ntdll.ntrenamekey':( 'int', None, 'stdcall', 'ntdll.NtRenameKey', (('int', None), ('int', None)) ),
    'ntdll.ntreplacekey':( 'int', None, 'stdcall', 'ntdll.NtReplaceKey', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntreplyport':( 'int', None, 'stdcall', 'ntdll.NtReplyPort', (('int', None), ('int', None)) ),
    'ntdll.ntreplywaitreceiveport':( 'int', None, 'stdcall', 'ntdll.NtReplyWaitReceivePort', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntreplywaitreceiveportex':( 'int', None, 'stdcall', 'ntdll.NtReplyWaitReceivePortEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntreplywaitreplyport':( 'int', None, 'stdcall', 'ntdll.NtReplyWaitReplyPort', (('int', None), ('int', None)) ),
    'ntdll.ntrequestdevicewakeup':( 'int', None, 'stdcall', 'ntdll.NtRequestDeviceWakeup', (('int', None),) ),
    'ntdll.ntrequestport':( 'int', None, 'stdcall', 'ntdll.NtRequestPort', (('int', None), ('int', None)) ),
    'ntdll.ntrequestwaitreplyport':( 'int', None, 'stdcall', 'ntdll.NtRequestWaitReplyPort', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntrequestwakeuplatency':( 'int', None, 'stdcall', 'ntdll.NtRequestWakeupLatency', (('int', None),) ),
    'ntdll.ntresetevent':( 'int', None, 'stdcall', 'ntdll.NtResetEvent', (('int', None), ('int', None)) ),
    'ntdll.ntresetwritewatch':( 'int', None, 'stdcall', 'ntdll.NtResetWriteWatch', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntrestorekey':( 'int', None, 'stdcall', 'ntdll.NtRestoreKey', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntresumeprocess':( 'int', None, 'stdcall', 'ntdll.NtResumeProcess', (('int', None),) ),
    'ntdll.ntresumethread':( 'int', None, 'stdcall', 'ntdll.NtResumeThread', (('int', None), ('int', None)) ),
    'ntdll.ntsavekey':( 'int', None, 'stdcall', 'ntdll.NtSaveKey', (('int', None), ('int', None)) ),
    'ntdll.ntsavekeyex':( 'int', None, 'stdcall', 'ntdll.NtSaveKeyEx', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntsavemergedkeys':( 'int', None, 'stdcall', 'ntdll.NtSaveMergedKeys', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntsecureconnectport':( 'int', None, 'stdcall', 'ntdll.NtSecureConnectPort', (('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.ntsetbootentryorder':( 'int', None, 'stdcall', 'ntdll.NtSetBootEntryOrder', (('int', None), ('int', None)) ),
    'ntdll.ntsetbootoptions':( 'int', None, 'stdcall', 'ntdll.NtSetBootOptions', (('int', None), ('int', None)) ),
    'ntdll.ntsetcontextthread':( 'int', None, 'stdcall', 'ntdll.NtSetContextThread', (('int', None), ('void *', 'ptr')) ),
    'ntdll.ntsetdebugfilterstate':( 'int', None, 'stdcall', 'ntdll.NtSetDebugFilterState', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntsetdefaultharderrorport':( 'int', None, 'stdcall', 'ntdll.NtSetDefaultHardErrorPort', (('int', None),) ),
    'ntdll.ntsetdefaultlocale':( 'int', None, 'stdcall', 'ntdll.NtSetDefaultLocale', (('int', None), ('int', None)) ),
    'ntdll.ntsetdefaultuilanguage':( 'int', None, 'stdcall', 'ntdll.NtSetDefaultUILanguage', (('int', None),) ),
    'ntdll.ntseteafile':( 'int', None, 'stdcall', 'ntdll.NtSetEaFile', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntsetevent':( 'int', None, 'stdcall', 'ntdll.NtSetEvent', (('int', None), ('int', None)) ),
    'ntdll.ntseteventboostpriority':( 'int', None, 'stdcall', 'ntdll.NtSetEventBoostPriority', (('int', None),) ),
    'ntdll.ntsethigheventpair':( 'int', None, 'stdcall', 'ntdll.NtSetHighEventPair', (('int', None),) ),
    'ntdll.ntsethighwaitloweventpair':( 'int', None, 'stdcall', 'ntdll.NtSetHighWaitLowEventPair', (('int', None),) ),
    'ntdll.ntsetinformationdebugobject':( 'int', None, 'stdcall', 'ntdll.NtSetInformationDebugObject', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntsetinformationfile':( 'int', None, 'stdcall', 'ntdll.NtSetInformationFile', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.ntsetinformationjobobject':( 'int', None, 'stdcall', 'ntdll.NtSetInformationJobObject', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntsetinformationkey':( 'int', None, 'stdcall', 'ntdll.NtSetInformationKey', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntsetinformationobject':( 'int', None, 'stdcall', 'ntdll.NtSetInformationObject', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.ntsetinformationprocess':( 'int', None, 'stdcall', 'ntdll.NtSetInformationProcess', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.ntsetinformationthread':( 'int', None, 'stdcall', 'ntdll.NtSetInformationThread', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.ntsetinformationtoken':( 'int', None, 'stdcall', 'ntdll.NtSetInformationToken', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntsetintervalprofile':( 'int', None, 'stdcall', 'ntdll.NtSetIntervalProfile', (('int', None), ('int', None)) ),
    'ntdll.ntsetiocompletion':( 'int', None, 'stdcall', 'ntdll.NtSetIoCompletion', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntsetldtentries':( 'int', None, 'stdcall', 'ntdll.NtSetLdtEntries', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntsetloweventpair':( 'int', None, 'stdcall', 'ntdll.NtSetLowEventPair', (('int', None),) ),
    'ntdll.ntsetlowwaithigheventpair':( 'int', None, 'stdcall', 'ntdll.NtSetLowWaitHighEventPair', (('int', None),) ),
    'ntdll.ntsetquotainformationfile':( 'int', None, 'stdcall', 'ntdll.NtSetQuotaInformationFile', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntsetsecurityobject':( 'int', None, 'stdcall', 'ntdll.NtSetSecurityObject', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntsetsystemenvironmentvalue':( 'int', None, 'stdcall', 'ntdll.NtSetSystemEnvironmentValue', (('int', None), ('int', None)) ),
    'ntdll.ntsetsystemenvironmentvalueex':( 'int', None, 'stdcall', 'ntdll.NtSetSystemEnvironmentValueEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntsetsysteminformation':( 'int', None, 'stdcall', 'ntdll.NtSetSystemInformation', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntsetsystempowerstate':( 'int', None, 'stdcall', 'ntdll.NtSetSystemPowerState', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntsetsystemtime':( 'int', None, 'stdcall', 'ntdll.NtSetSystemTime', (('int', None), ('int', None)) ),
    'ntdll.ntsetthreadexecutionstate':( 'int', None, 'stdcall', 'ntdll.NtSetThreadExecutionState', (('int', None), ('int', None)) ),
    'ntdll.ntsettimer':( 'int', None, 'stdcall', 'ntdll.NtSetTimer', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntsettimerresolution':( 'int', None, 'stdcall', 'ntdll.NtSetTimerResolution', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntsetuuidseed':( 'int', None, 'stdcall', 'ntdll.NtSetUuidSeed', (('int', None),) ),
    'ntdll.ntsetvaluekey':( 'int', None, 'stdcall', 'ntdll.NtSetValueKey', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.ntsetvolumeinformationfile':( 'int', None, 'stdcall', 'ntdll.NtSetVolumeInformationFile', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntshutdownsystem':( 'int', None, 'stdcall', 'ntdll.NtShutdownSystem', (('int', None),) ),
    'ntdll.ntsignalandwaitforsingleobject':( 'int', None, 'stdcall', 'ntdll.NtSignalAndWaitForSingleObject', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntstartprofile':( 'int', None, 'stdcall', 'ntdll.NtStartProfile', (('int', None),) ),
    'ntdll.ntstopprofile':( 'int', None, 'stdcall', 'ntdll.NtStopProfile', (('int', None),) ),
    'ntdll.ntsuspendprocess':( 'int', None, 'stdcall', 'ntdll.NtSuspendProcess', (('int', None),) ),
    'ntdll.ntsuspendthread':( 'int', None, 'stdcall', 'ntdll.NtSuspendThread', (('int', None), ('int', None)) ),
    'ntdll.ntsystemdebugcontrol':( 'int', None, 'stdcall', 'ntdll.NtSystemDebugControl', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntterminatejobobject':( 'int', None, 'stdcall', 'ntdll.NtTerminateJobObject', (('int', None), ('int', None)) ),
    'ntdll.ntterminateprocess':( 'int', None, 'stdcall', 'ntdll.NtTerminateProcess', (('int', None), ('int', None)) ),
    'ntdll.ntterminatethread':( 'int', None, 'stdcall', 'ntdll.NtTerminateThread', (('int', None), ('int', None)) ),
    'ntdll.nttestalert':( 'int', None, 'cdecl', 'ntdll.NtTestAlert', () ),
    'ntdll.nttraceevent':( 'int', None, 'stdcall', 'ntdll.NtTraceEvent', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.nttranslatefilepath':( 'int', None, 'stdcall', 'ntdll.NtTranslateFilePath', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntunloaddriver':( 'int', None, 'stdcall', 'ntdll.NtUnloadDriver', (('int', None),) ),
    'ntdll.ntunloadkey':( 'int', None, 'stdcall', 'ntdll.NtUnloadKey', (('int', None),) ),
    'ntdll.ntunloadkeyex':( 'int', None, 'stdcall', 'ntdll.NtUnloadKeyEx', (('int', None), ('int', None)) ),
    'ntdll.ntunlockfile':( 'int', None, 'stdcall', 'ntdll.NtUnlockFile', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntunlockvirtualmemory':( 'int', None, 'stdcall', 'ntdll.NtUnlockVirtualMemory', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntunmapviewofsection':( 'int', None, 'stdcall', 'ntdll.NtUnmapViewOfSection', (('int', None), ('int', None)) ),
    'ntdll.ntvdmcontrol':( 'int', None, 'stdcall', 'ntdll.NtVdmControl', (('int', None), ('int', None)) ),
    'ntdll.ntwaitfordebugevent':( 'int', None, 'stdcall', 'ntdll.NtWaitForDebugEvent', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntwaitforkeyedevent':( 'int', None, 'stdcall', 'ntdll.NtWaitForKeyedEvent', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntwaitformultipleobjects':( 'int', None, 'stdcall', 'ntdll.NtWaitForMultipleObjects', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntwaitforsingleobject':( 'int', None, 'stdcall', 'ntdll.NtWaitForSingleObject', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.ntwaithigheventpair':( 'int', None, 'stdcall', 'ntdll.NtWaitHighEventPair', (('int', None),) ),
    'ntdll.ntwaitloweventpair':( 'int', None, 'stdcall', 'ntdll.NtWaitLowEventPair', (('int', None),) ),
    'ntdll.ntwritefile':( 'int', None, 'stdcall', 'ntdll.NtWriteFile', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.ntwritefilegather':( 'int', None, 'stdcall', 'ntdll.NtWriteFileGather', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntwriterequestdata':( 'int', None, 'stdcall', 'ntdll.NtWriteRequestData', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.ntwritevirtualmemory':( 'int', None, 'stdcall', 'ntdll.NtWriteVirtualMemory', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.ntyieldexecution':( 'int', None, 'cdecl', 'ntdll.NtYieldExecution', () ),
    'ntdll.pfxfindprefix':( 'int', None, 'stdcall', 'ntdll.PfxFindPrefix', (('int', None), ('int', None)) ),
    'ntdll.pfxinitialize':( 'int', None, 'stdcall', 'ntdll.PfxInitialize', (('int', None),) ),
    'ntdll.pfxinsertprefix':( 'int', None, 'stdcall', 'ntdll.PfxInsertPrefix', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.pfxremoveprefix':( 'int', None, 'stdcall', 'ntdll.PfxRemovePrefix', (('int', None), ('int', None)) ),
    'ntdll.propertylengthasvariant':( 'int', None, 'stdcall', 'ntdll.PropertyLengthAsVariant', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlabortrxact':( 'int', None, 'stdcall', 'ntdll.RtlAbortRXact', (('int', None),) ),
    'ntdll.rtlabsolutetoselfrelativesd':( 'int', None, 'stdcall', 'ntdll.RtlAbsoluteToSelfRelativeSD', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlacquirepeblock':( 'int', None, 'cdecl', 'ntdll.RtlAcquirePebLock', () ),
    'ntdll.rtlacquireresourceexclusive':( 'int', None, 'stdcall', 'ntdll.RtlAcquireResourceExclusive', ( ('int', None), ('int', None)) ),
    'ntdll.rtlacquireresourceshared':( 'int', None, 'stdcall', 'ntdll.RtlAcquireResourceShared', (('int', None), ('int', None)) ),
    'ntdll.rtlactivateactivationcontext':( 'int', None, 'stdcall', 'ntdll.RtlActivateActivationContext', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlactivateactivationcontextex':( 'int', None, 'stdcall', 'ntdll.RtlActivateActivationContextEx', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtlactivateactivationcontextunsafefast':( 'int', None, 'stdcall', 'ntdll.RtlActivateActivationContextUnsafeFast', (('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtladdaccessallowedace':( 'int', None, 'stdcall', 'ntdll.RtlAddAccessAllowedAce', (('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtladdaccessallowedaceex':( 'int', None, 'stdcall', 'ntdll.RtlAddAccessAllowedAceEx', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtladdaccessallowedobjectace':( 'int', None, 'stdcall', 'ntdll.RtlAddAccessAllowedObjectAce', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtladdaccessdeniedace':( 'int', None, 'stdcall', 'ntdll.RtlAddAccessDeniedAce', (('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtladdaccessdeniedaceex':( 'int', None, 'stdcall', 'ntdll.RtlAddAccessDeniedAceEx', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtladdaccessdeniedobjectace':( 'int', None, 'stdcall', 'ntdll.RtlAddAccessDeniedObjectAce', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtladdace':( 'int', None, 'stdcall', 'ntdll.RtlAddAce', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtladdactiontorxact':( 'int', None, 'stdcall', 'ntdll.RtlAddActionToRXact', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtladdatomtoatomtable':( 'int', None, 'stdcall', 'ntdll.RtlAddAtomToAtomTable', ( ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtladdattributeactiontorxact':( 'int', None, 'stdcall', 'ntdll.RtlAddAttributeActionToRXact', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtladdauditaccessace':( 'int', None, 'stdcall', 'ntdll.RtlAddAuditAccessAce', (('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtladdauditaccessaceex':( 'int', None, 'stdcall', 'ntdll.RtlAddAuditAccessAceEx', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtladdauditaccessobjectace':( 'int', None, 'stdcall', 'ntdll.RtlAddAuditAccessObjectAce', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtladdcompoundace':( 'int', None, 'stdcall', 'ntdll.RtlAddCompoundAce', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.rtladdrange':( 'int', None, 'stdcall', 'ntdll.RtlAddRange', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtladdrefactivationcontext':( 'int', None, 'stdcall', 'ntdll.RtlAddRefActivationContext', (('int', None),) ),
    'ntdll.rtladdrefmemorystream':( 'int', None, 'stdcall', 'ntdll.RtlAddRefMemoryStream', (('int', None),) ),
    'ntdll.rtladdvectoredexceptionhandler':( 'int', None, 'stdcall', 'ntdll.RtlAddVectoredExceptionHandler', ( ('int', None), ('int', None)) ),
    'ntdll.rtladdressinsectiontable':( 'int', None, 'stdcall', 'ntdll.RtlAddressInSectionTable', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtladjustprivilege':( 'int', None, 'stdcall', 'ntdll.RtlAdjustPrivilege', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlallocateandinitializesid':( 'int', None, 'stdcall', 'ntdll.RtlAllocateAndInitializeSid', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlallocatehandle':( 'int', None, 'stdcall', 'ntdll.RtlAllocateHandle', (('int', None), ('int', None)) ),
    'ntdll.rtlallocateheap':( 'int', None, 'stdcall', 'ntdll.RtlAllocateHeap', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtlansichartounicodechar':( 'int', None, 'stdcall', 'ntdll.RtlAnsiCharToUnicodeChar', (('void *', 'ptr'),) ),
    'ntdll.rtlansistringtounicodesize':( 'int', None, 'stdcall', 'ntdll.RtlAnsiStringToUnicodeSize', (('int', None),) ),
    'ntdll.rtlansistringtounicodestring':( 'int', None, 'stdcall', 'ntdll.RtlAnsiStringToUnicodeString', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlappendasciiztostring':( 'int', None, 'stdcall', 'ntdll.RtlAppendAsciizToString', (('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlappendpathelement':( 'int', None, 'stdcall', 'ntdll.RtlAppendPathElement', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlappendstringtostring':( 'int', None, 'stdcall', 'ntdll.RtlAppendStringToString', (('int', None), ('int', None)) ),
    'ntdll.rtlappendunicodestringtostring':( 'int', None, 'stdcall', 'ntdll.RtlAppendUnicodeStringToString', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.rtlappendunicodetostring':( 'int', None, 'stdcall', 'ntdll.RtlAppendUnicodeToString', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.rtlapplicationverifierstop':( 'int', None, 'stdcall', 'ntdll.RtlApplicationVerifierStop', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlapplyrxact':( 'int', None, 'stdcall', 'ntdll.RtlApplyRXact', (('int', None),) ),
    'ntdll.rtlapplyrxactnoflush':( 'int', None, 'stdcall', 'ntdll.RtlApplyRXactNoFlush', (('int', None),) ),
    'ntdll.rtlareallaccessesgranted':( 'int', None, 'stdcall', 'ntdll.RtlAreAllAccessesGranted', (('int', None), ('int', None)) ),
    'ntdll.rtlareanyaccessesgranted':( 'int', None, 'stdcall', 'ntdll.RtlAreAnyAccessesGranted', (('int', None), ('int', None)) ),
    'ntdll.rtlarebitsclear':( 'int', None, 'stdcall', 'ntdll.RtlAreBitsClear', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlarebitsset':( 'int', None, 'stdcall', 'ntdll.RtlAreBitsSet', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlassert':( 'int', None, 'stdcall', 'ntdll.RtlAssert', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlassert2':( 'int', None, 'stdcall', 'ntdll.RtlAssert2', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlcanceltimer':( 'int', None, 'stdcall', 'ntdll.RtlCancelTimer', ( ('int', None), ('int', None)) ),
    'ntdll.rtlcapturecontext':( 'int', None, 'stdcall', 'ntdll.RtlCaptureContext', (('void *', 'ptr'),) ),
    'ntdll.rtlcapturestackbacktrace':( 'int', None, 'stdcall', 'ntdll.RtlCaptureStackBackTrace', (('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.rtlcapturestackcontext':( 'int', None, 'stdcall', 'ntdll.RtlCaptureStackContext', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlchartointeger':( 'int', None, 'stdcall', 'ntdll.RtlCharToInteger', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlcheckfororphanedcriticalsections':( 'int', None, 'stdcall', 'ntdll.RtlCheckForOrphanedCriticalSections', ( ('int', None),) ),
    'ntdll.rtlcheckprocessparameters':( 'int', None, 'stdcall', 'ntdll.RtlCheckProcessParameters', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlcheckregistrykey':( 'int', None, 'stdcall', 'ntdll.RtlCheckRegistryKey', (('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlclearallbits':( 'int', None, 'stdcall', 'ntdll.RtlClearAllBits', (('int', None),) ),
    'ntdll.rtlclearbits':( 'int', None, 'stdcall', 'ntdll.RtlClearBits', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlclonememorystream':( 'int', None, 'stdcall', 'ntdll.RtlCloneMemoryStream', (('int', None), ('int', None)) ),
    'ntdll.rtlcommitmemorystream':( 'int', None, 'stdcall', 'ntdll.RtlCommitMemoryStream', (('int', None), ('int', None)) ),
    'ntdll.rtlcompactheap':( 'int', None, 'stdcall', 'ntdll.RtlCompactHeap', ( ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlcomparememory':( 'int', None, 'stdcall', 'ntdll.RtlCompareMemory', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlcomparememoryulong':( 'int', None, 'stdcall', 'ntdll.RtlCompareMemoryUlong', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlcomparestring':( 'int', None, 'stdcall', 'ntdll.RtlCompareString', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlcompareunicodestring':( 'int', None, 'stdcall', 'ntdll.RtlCompareUnicodeString', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlcompressbuffer':( 'int', None, 'stdcall', 'ntdll.RtlCompressBuffer', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlcomputecrc32':( 'int', None, 'stdcall', 'ntdll.RtlComputeCrc32', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlcomputeimporttablehash':( 'int', None, 'stdcall', 'ntdll.RtlComputeImportTableHash', ( ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlcomputeprivatizeddllname_u':( 'int', None, 'stdcall', 'ntdll.RtlComputePrivatizedDllName_U', (('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.rtlconsolemultibytetounicoden':( 'int', None, 'stdcall', 'ntdll.RtlConsoleMultiByteToUnicodeN', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlconvertexclusivetoshared':( 'int', None, 'stdcall', 'ntdll.RtlConvertExclusiveToShared', ( ('int', None),) ),
    'ntdll.rtlconvertlongtolargeinteger':( 'int', None, 'stdcall', 'ntdll.RtlConvertLongToLargeInteger', (('int', None),) ),
    'ntdll.rtlconvertpropertytovariant':( 'int', None, 'stdcall', 'ntdll.RtlConvertPropertyToVariant', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlconvertsharedtoexclusive':( 'int', None, 'stdcall', 'ntdll.RtlConvertSharedToExclusive', ( ('int', None),) ),
    'ntdll.rtlconvertsidtounicodestring':( 'int', None, 'stdcall', 'ntdll.RtlConvertSidToUnicodeString', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtlconverttoautoinheritsecurityobject':( 'int', None, 'stdcall', 'ntdll.RtlConvertToAutoInheritSecurityObject', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlconvertuilisttoapilist':( 'int', None, 'stdcall', 'ntdll.RtlConvertUiListToApiList', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlconvertulongtolargeinteger':( 'int', None, 'stdcall', 'ntdll.RtlConvertUlongToLargeInteger', (('int', None),) ),
    'ntdll.rtlconvertvarianttoproperty':( 'int', None, 'stdcall', 'ntdll.RtlConvertVariantToProperty', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlcopyluid':( 'int', None, 'stdcall', 'ntdll.RtlCopyLuid', (('int', None), ('int', None)) ),
    'ntdll.rtlcopyluidandattributesarray':( 'int', None, 'stdcall', 'ntdll.RtlCopyLuidAndAttributesArray', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlcopymemorystreamto':( 'int', None, 'stdcall', 'ntdll.RtlCopyMemoryStreamTo', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlcopyoutofprocessmemorystreamto':( 'int', None, 'stdcall', 'ntdll.RtlCopyOutOfProcessMemoryStreamTo', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlcopyrangelist':( 'int', None, 'stdcall', 'ntdll.RtlCopyRangeList', (('int', None), ('int', None)) ),
    'ntdll.rtlcopysecuritydescriptor':( 'int', None, 'stdcall', 'ntdll.RtlCopySecurityDescriptor', (('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlcopysid':( 'int', None, 'stdcall', 'ntdll.RtlCopySid', (('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.rtlcopysidandattributesarray':( 'int', None, 'stdcall', 'ntdll.RtlCopySidAndAttributesArray', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtlcopystring':( 'int', None, 'stdcall', 'ntdll.RtlCopyString', (('int', None), ('int', None)) ),
    'ntdll.rtlcopyunicodestring':( 'int', None, 'stdcall', 'ntdll.RtlCopyUnicodeString', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.rtlcreateacl':( 'int', None, 'stdcall', 'ntdll.RtlCreateAcl', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlcreateactivationcontext':( 'int', None, 'stdcall', 'ntdll.RtlCreateActivationContext', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlcreateandsetsd':( 'int', None, 'stdcall', 'ntdll.RtlCreateAndSetSD', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlcreateatomtable':( 'int', None, 'stdcall', 'ntdll.RtlCreateAtomTable', (('int', None), ('int', None)) ),
    'ntdll.rtlcreatebootstatusdatafile':( 'int', None, 'cdecl', 'ntdll.RtlCreateBootStatusDataFile', () ),
    'ntdll.rtlcreateenvironment':( 'int', None, 'stdcall', 'ntdll.RtlCreateEnvironment', (('int', None), ('int', None)) ),
    'ntdll.rtlcreateheap':( 'int', None, 'stdcall', 'ntdll.RtlCreateHeap', ( ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlcreateprocessparameters':( 'int', None, 'stdcall', 'ntdll.RtlCreateProcessParameters', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlcreatequerydebugbuffer':( 'int', None, 'stdcall', 'ntdll.RtlCreateQueryDebugBuffer', (('int', None), ('int', None)) ),
    'ntdll.rtlcreateregistrykey':( 'int', None, 'stdcall', 'ntdll.RtlCreateRegistryKey', (('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlcreatesecuritydescriptor':( 'int', None, 'stdcall', 'ntdll.RtlCreateSecurityDescriptor', (('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlcreateservicesid':( 'int', None, 'stdcall', 'ntdll.RtlCreateServiceSid', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlcreatesystemvolumeinformationfolder':( 'int', None, 'stdcall', 'ntdll.RtlCreateSystemVolumeInformationFolder', (('int', None),) ),
    'ntdll.rtlcreatetagheap':( 'int', None, 'stdcall', 'ntdll.RtlCreateTagHeap', (('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlcreatetimer':( 'int', None, 'stdcall', 'ntdll.RtlCreateTimer', ( ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlcreatetimerqueue':( 'int', None, 'stdcall', 'ntdll.RtlCreateTimerQueue', ( ('void *', 'ptr'),) ),
    'ntdll.rtlcreateunicodestring':( 'int', None, 'stdcall', 'ntdll.RtlCreateUnicodeString', (('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlcreateunicodestringfromasciiz':( 'int', None, 'stdcall', 'ntdll.RtlCreateUnicodeStringFromAsciiz', (('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlcreateuserprocess':( 'int', None, 'stdcall', 'ntdll.RtlCreateUserProcess', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlcreateusersecurityobject':( 'int', None, 'stdcall', 'ntdll.RtlCreateUserSecurityObject', ( ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlcreateuserthread':( 'int', None, 'stdcall', 'ntdll.RtlCreateUserThread', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlcustomcptounicoden':( 'int', None, 'stdcall', 'ntdll.RtlCustomCPToUnicodeN', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlcutovertimetosystemtime':( 'int', None, 'msfastcall', 'ntdll.RtlCutoverTimeToSystemTime', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtldenormalizeprocessparams':( 'int', None, 'stdcall', 'ntdll.RtlDeNormalizeProcessParams', (('int', None),) ),
    'ntdll.rtldeactivateactivationcontext':( 'int', None, 'stdcall', 'ntdll.RtlDeactivateActivationContext', (('int', None), ('int', None)) ),
    'ntdll.rtldeactivateactivationcontextunsafefast':( 'int', None, 'stdcall', 'ntdll.RtlDeactivateActivationContextUnsafeFast', (('int', None),) ),
    'ntdll.rtldebugprinttimes':( 'int', None, 'cdecl', 'ntdll.RtlDebugPrintTimes', () ),
    'ntdll.rtldecodepointer':( 'int', None, 'stdcall', 'ntdll.RtlDecodePointer', (('int', None),) ),
    'ntdll.rtldecodesystempointer':( 'int', None, 'stdcall', 'ntdll.RtlDecodeSystemPointer', (('int', None),) ),
    'ntdll.rtldecompressbuffer':( 'int', None, 'stdcall', 'ntdll.RtlDecompressBuffer', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtldecompressfragment':( 'int', None, 'stdcall', 'ntdll.RtlDecompressFragment', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtldefaultnpacl':( 'int', None, 'stdcall', 'ntdll.RtlDefaultNpAcl', (('int', None),) ),
    'ntdll.rtldelete':( 'int', None, 'stdcall', 'ntdll.RtlDelete', (('int', None),) ),
    'ntdll.rtldeleteace':( 'int', None, 'stdcall', 'ntdll.RtlDeleteAce', (('int', None), ('int', None)) ),
    'ntdll.rtldeleteatomfromatomtable':( 'int', None, 'stdcall', 'ntdll.RtlDeleteAtomFromAtomTable', ( ('int', None), ('int', None)) ),
    'ntdll.rtldeletecriticalsection':( 'int', None, 'stdcall', 'ntdll.RtlDeleteCriticalSection', ( ('int', None),) ),
    'ntdll.rtldeleteelementgenerictable':( 'int', None, 'stdcall', 'ntdll.RtlDeleteElementGenericTable', (('int', None), ('int', None)) ),
    'ntdll.rtldeleteelementgenerictableavl':( 'int', None, 'stdcall', 'ntdll.RtlDeleteElementGenericTableAvl', (('int', None), ('int', None)) ),
    'ntdll.rtldeletenosplay':( 'int', None, 'stdcall', 'ntdll.RtlDeleteNoSplay', (('int', None), ('int', None)) ),
    'ntdll.rtldeleteownersranges':( 'int', None, 'stdcall', 'ntdll.RtlDeleteOwnersRanges', (('int', None), ('int', None)) ),
    'ntdll.rtldeleterange':( 'int', None, 'stdcall', 'ntdll.RtlDeleteRange', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtldeleteregistryvalue':( 'int', None, 'stdcall', 'ntdll.RtlDeleteRegistryValue', (('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.rtldeleteresource':( 'int', None, 'stdcall', 'ntdll.RtlDeleteResource', ( ('int', None),) ),
    'ntdll.rtldeletesecurityobject':( 'int', None, 'stdcall', 'ntdll.RtlDeleteSecurityObject', (('int', None),) ),
    'ntdll.rtldeletetimer':( 'int', None, 'stdcall', 'ntdll.RtlDeleteTimer', ( ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtldeletetimerqueue':( 'int', None, 'stdcall', 'ntdll.RtlDeleteTimerQueue', ( ('int', None),) ),
    'ntdll.rtldeletetimerqueueex':( 'int', None, 'stdcall', 'ntdll.RtlDeleteTimerQueueEx', ( ('int', None), ('int', None)) ),
    'ntdll.rtlderegisterwait':( 'int', None, 'stdcall', 'ntdll.RtlDeregisterWait', () ),
    'ntdll.rtlderegisterwaitex':( 'int', None, 'stdcall', 'ntdll.RtlDeregisterWaitEx', ( ('int', None),) ),
    'ntdll.rtldestroyatomtable':( 'int', None, 'stdcall', 'ntdll.RtlDestroyAtomTable', ( ('int', None),) ),
    'ntdll.rtldestroyenvironment':( 'int', None, 'stdcall', 'ntdll.RtlDestroyEnvironment', (('int', None),) ),
    'ntdll.rtldestroyhandletable':( 'int', None, 'stdcall', 'ntdll.RtlDestroyHandleTable', (('int', None),) ),
    'ntdll.rtldestroyheap':( 'int', None, 'stdcall', 'ntdll.RtlDestroyHeap', (('void *', 'ptr'),) ),
    'ntdll.rtldestroyprocessparameters':( 'int', None, 'stdcall', 'ntdll.RtlDestroyProcessParameters', (('int', None),) ),
    'ntdll.rtldestroyquerydebugbuffer':( 'int', None, 'stdcall', 'ntdll.RtlDestroyQueryDebugBuffer', (('void *', 'ptr'),) ),
    'ntdll.rtldeterminedospathnametype_u':( 'int', None, 'stdcall', 'ntdll.RtlDetermineDosPathNameType_U', (('void *', 'ptr'),) ),
    'ntdll.rtldllshutdowninprogress':( 'int', None, 'cdecl', 'ntdll.RtlDllShutdownInProgress', () ),
    'ntdll.rtldnshostnametocomputername':( 'int', None, 'stdcall', 'ntdll.RtlDnsHostNameToComputerName', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtldoesfileexists_u':( 'int', None, 'stdcall', 'ntdll.RtlDoesFileExists_U', (('int', None),) ),
    'ntdll.rtldosapplyfileisolationredirection_ustr':( 'int', None, 'stdcall', 'ntdll.RtlDosApplyFileIsolationRedirection_Ustr', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtldospathnametontpathname_u':( 'int', None, 'stdcall', 'ntdll.RtlDosPathNameToNtPathName_U', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtldossearchpath_u':( 'int', None, 'stdcall', 'ntdll.RtlDosSearchPath_U', (('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.rtldossearchpath_ustr':( 'int', None, 'stdcall', 'ntdll.RtlDosSearchPath_Ustr', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtldowncaseunicodechar':( 'int', None, 'stdcall', 'ntdll.RtlDowncaseUnicodeChar', (('int', None),) ),
    'ntdll.rtldowncaseunicodestring':( 'int', None, 'stdcall', 'ntdll.RtlDowncaseUnicodeString', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtldumpresource':( 'int', None, 'stdcall', 'ntdll.RtlDumpResource', (('int', None),) ),
    'ntdll.rtlduplicateunicodestring':( 'int', None, 'stdcall', 'ntdll.RtlDuplicateUnicodeString', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlemptyatomtable':( 'int', None, 'stdcall', 'ntdll.RtlEmptyAtomTable', ( ('int', None), ('int', None)) ),
    'ntdll.rtlenableearlycriticalsectioneventcreation':( 'int', None, 'cdecl', 'ntdll.RtlEnableEarlyCriticalSectionEventCreation', () ),
    'ntdll.rtlencodepointer':( 'int', None, 'stdcall', 'ntdll.RtlEncodePointer', (('int', None),) ),
    'ntdll.rtlencodesystempointer':( 'int', None, 'stdcall', 'ntdll.RtlEncodeSystemPointer', (('int', None),) ),
    'ntdll.rtlenlargedintegermultiply':( 'int', None, 'stdcall', 'ntdll.RtlEnlargedIntegerMultiply', (('int', None), ('int', None)) ),
    'ntdll.rtlenlargedunsigneddivide':( 'int', None, 'stdcall', 'ntdll.RtlEnlargedUnsignedDivide', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlenlargedunsignedmultiply':( 'int', None, 'stdcall', 'ntdll.RtlEnlargedUnsignedMultiply', (('int', None), ('int', None)) ),
    'ntdll.rtlentercriticalsection':( 'int', None, 'stdcall', 'ntdll.RtlEnterCriticalSection', (('int', None),) ),
    'ntdll.rtlenumprocessheaps':( 'int', None, 'stdcall', 'ntdll.RtlEnumProcessHeaps', ( ('void *', 'funcptr'), ('int', None)) ),
    'ntdll.rtlenumerategenerictable':( 'int', None, 'stdcall', 'ntdll.RtlEnumerateGenericTable', (('int', None), ('int', None)) ),
    'ntdll.rtlenumerategenerictableavl':( 'int', None, 'stdcall', 'ntdll.RtlEnumerateGenericTableAvl', (('int', None), ('int', None)) ),
    'ntdll.rtlenumerategenerictablelikeadirectory':( 'int', None, 'stdcall', 'ntdll.RtlEnumerateGenericTableLikeADirectory', (('int', None), ('void *', 'funcptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlenumerategenerictablewithoutsplaying':( 'int', None, 'stdcall', 'ntdll.RtlEnumerateGenericTableWithoutSplaying', (('int', None), ('int', None)) ),
    'ntdll.rtlenumerategenerictablewithoutsplayingavl':( 'int', None, 'stdcall', 'ntdll.RtlEnumerateGenericTableWithoutSplayingAvl', (('int', None), ('int', None)) ),
    'ntdll.rtlequalcomputername':( 'int', None, 'stdcall', 'ntdll.RtlEqualComputerName', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.rtlequaldomainname':( 'int', None, 'stdcall', 'ntdll.RtlEqualDomainName', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.rtlequalluid':( 'int', None, 'stdcall', 'ntdll.RtlEqualLuid', (('int', None), ('int', None)) ),
    'ntdll.rtlequalprefixsid':( 'int', None, 'stdcall', 'ntdll.RtlEqualPrefixSid', (('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlequalsid':( 'int', None, 'stdcall', 'ntdll.RtlEqualSid', (('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlequalstring':( 'int', None, 'stdcall', 'ntdll.RtlEqualString', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlequalunicodestring':( 'int', None, 'stdcall', 'ntdll.RtlEqualUnicodeString', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtleraseunicodestring':( 'int', None, 'stdcall', 'ntdll.RtlEraseUnicodeString', (('int', None),) ),
    'ntdll.rtlexituserthread':( 'int', None, 'stdcall', 'ntdll.RtlExitUserThread', ( ('int', None),) ),
    'ntdll.rtlexpandenvironmentstrings_u':( 'int', None, 'stdcall', 'ntdll.RtlExpandEnvironmentStrings_U', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.rtlextendheap':( 'int', None, 'stdcall', 'ntdll.RtlExtendHeap', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlextendedintegermultiply':( 'int', None, 'stdcall', 'ntdll.RtlExtendedIntegerMultiply', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlextendedlargeintegerdivide':( 'int', None, 'stdcall', 'ntdll.RtlExtendedLargeIntegerDivide', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlextendedmagicdivide':( 'int', None, 'stdcall', 'ntdll.RtlExtendedMagicDivide', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlfillmemory':( 'int', None, 'stdcall', 'ntdll.RtlFillMemory', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlfillmemoryulong':( 'int', None, 'stdcall', 'ntdll.RtlFillMemoryUlong', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlfinalreleaseoutofprocessmemorystream':( 'int', None, 'stdcall', 'ntdll.RtlFinalReleaseOutOfProcessMemoryStream', (('int', None),) ),
    'ntdll.rtlfindactivationcontextsectionguid':( 'int', None, 'stdcall', 'ntdll.RtlFindActivationContextSectionGuid', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlfindactivationcontextsectionstring':( 'int', None, 'stdcall', 'ntdll.RtlFindActivationContextSectionString', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.rtlfindcharinunicodestring':( 'int', None, 'stdcall', 'ntdll.RtlFindCharInUnicodeString', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlfindclearbits':( 'int', None, 'stdcall', 'ntdll.RtlFindClearBits', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlfindclearbitsandset':( 'int', None, 'stdcall', 'ntdll.RtlFindClearBitsAndSet', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlfindclearruns':( 'int', None, 'stdcall', 'ntdll.RtlFindClearRuns', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtlfindlastbackwardrunclear':( 'int', None, 'stdcall', 'ntdll.RtlFindLastBackwardRunClear', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlfindleastsignificantbit':( 'int', None, 'stdcall', 'ntdll.RtlFindLeastSignificantBit', (('int', None), ('int', None)) ),
    'ntdll.rtlfindlongestrunclear':( 'int', None, 'stdcall', 'ntdll.RtlFindLongestRunClear', (('int', None), ('int', None)) ),
    'ntdll.rtlfindmessage':( 'int', None, 'stdcall', 'ntdll.RtlFindMessage', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlfindmostsignificantbit':( 'int', None, 'stdcall', 'ntdll.RtlFindMostSignificantBit', (('int', None), ('int', None)) ),
    'ntdll.rtlfindnextforwardrunclear':( 'int', None, 'stdcall', 'ntdll.RtlFindNextForwardRunClear', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlfindrange':( 'int', None, 'stdcall', 'ntdll.RtlFindRange', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'funcptr'), ('int', None)) ),
    'ntdll.rtlfindsetbits':( 'int', None, 'stdcall', 'ntdll.RtlFindSetBits', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlfindsetbitsandclear':( 'int', None, 'stdcall', 'ntdll.RtlFindSetBitsAndClear', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlfirstentryslist':( 'int', None, 'stdcall', 'ntdll.RtlFirstEntrySList', (('int', None),) ),
    'ntdll.rtlfirstfreeace':( 'int', None, 'stdcall', 'ntdll.RtlFirstFreeAce', (('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlflushsecurememorycache':( 'int', None, 'stdcall', 'ntdll.RtlFlushSecureMemoryCache', (('int', None), ('int', None)) ),
    'ntdll.rtlformatcurrentuserkeypath':( 'int', None, 'stdcall', 'ntdll.RtlFormatCurrentUserKeyPath', (('void *', 'ptr'),) ),
    'ntdll.rtlformatmessage':( 'int', None, 'stdcall', 'ntdll.RtlFormatMessage', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtlfreeansistring':( 'int', None, 'stdcall', 'ntdll.RtlFreeAnsiString', (('void *', 'ptr'),) ),
    'ntdll.rtlfreehandle':( 'int', None, 'stdcall', 'ntdll.RtlFreeHandle', (('int', None), ('int', None)) ),
    'ntdll.rtlfreeheap':( 'int', None, 'stdcall', 'ntdll.RtlFreeHeap', (('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlfreeoemstring':( 'int', None, 'stdcall', 'ntdll.RtlFreeOemString', (('void *', 'ptr'),) ),
    'ntdll.rtlfreerangelist':( 'int', None, 'stdcall', 'ntdll.RtlFreeRangeList', (('int', None),) ),
    'ntdll.rtlfreesid':( 'int', None, 'stdcall', 'ntdll.RtlFreeSid', (('void *', 'ptr'),) ),
    'ntdll.rtlfreethreadactivationcontextstack':( 'int', None, 'cdecl', 'ntdll.RtlFreeThreadActivationContextStack', () ),
    'ntdll.rtlfreeunicodestring':( 'int', None, 'stdcall', 'ntdll.RtlFreeUnicodeString', (('void *', 'ptr'),) ),
    'ntdll.rtlfreeuserthreadstack':( 'int', None, 'stdcall', 'ntdll.RtlFreeUserThreadStack', (('int', None), ('int', None)) ),
    'ntdll.rtlguidfromstring':( 'int', None, 'stdcall', 'ntdll.RtlGUIDFromString', (('int', None), ('int', None)) ),
    'ntdll.rtlgenerate8dot3name':( 'int', None, 'stdcall', 'ntdll.RtlGenerate8dot3Name', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlgetace':( 'int', None, 'stdcall', 'ntdll.RtlGetAce', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlgetactiveactivationcontext':( 'int', None, 'stdcall', 'ntdll.RtlGetActiveActivationContext', (('int', None),) ),
    'ntdll.rtlgetcallersaddress':( 'int', None, 'stdcall', 'ntdll.RtlGetCallersAddress', (('int', None), ('int', None)) ),
    'ntdll.rtlgetcompressionworkspacesize':( 'int', None, 'stdcall', 'ntdll.RtlGetCompressionWorkSpaceSize', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlgetcontrolsecuritydescriptor':( 'int', None, 'stdcall', 'ntdll.RtlGetControlSecurityDescriptor', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlgetcurrentdirectory_u':( 'int', None, 'stdcall', 'ntdll.RtlGetCurrentDirectory_U', (('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlgetcurrentpeb':( 'int', None, 'cdecl', 'ntdll.RtlGetCurrentPeb', () ),
    'ntdll.rtlgetdaclsecuritydescriptor':( 'int', None, 'stdcall', 'ntdll.RtlGetDaclSecurityDescriptor', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.rtlgetelementgenerictable':( 'int', None, 'stdcall', 'ntdll.RtlGetElementGenericTable', (('int', None), ('int', None)) ),
    'ntdll.rtlgetelementgenerictableavl':( 'int', None, 'stdcall', 'ntdll.RtlGetElementGenericTableAvl', (('int', None), ('int', None)) ),
    'ntdll.rtlgetfirstrange':( 'int', None, 'stdcall', 'ntdll.RtlGetFirstRange', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlgetframe':( 'int', None, 'cdecl', 'ntdll.RtlGetFrame', () ),
    'ntdll.rtlgetfullpathname_u':( 'int', None, 'stdcall', 'ntdll.RtlGetFullPathName_U', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.rtlgetgroupsecuritydescriptor':( 'int', None, 'stdcall', 'ntdll.RtlGetGroupSecurityDescriptor', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlgetlastntstatus':( 'int', None, 'cdecl', 'ntdll.RtlGetLastNtStatus', () ),
    'ntdll.rtlgetlastwin32error':( 'int', None, 'cdecl', 'ntdll.RtlGetLastWin32Error', () ),
    'ntdll.rtlgetlengthwithoutlastfulldosorntpathelement':( 'int', None, 'stdcall', 'ntdll.RtlGetLengthWithoutLastFullDosOrNtPathElement', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlgetlengthwithouttrailingpathseperators':( 'int', None, 'stdcall', 'ntdll.RtlGetLengthWithoutTrailingPathSeperators', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlgetlongestntpathlength':( 'int', None, 'cdecl', 'ntdll.RtlGetLongestNtPathLength', () ),
    'ntdll.rtlgetnativesysteminformation':( 'int', None, 'stdcall', 'ntdll.RtlGetNativeSystemInformation', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlgetnextrange':( 'int', None, 'stdcall', 'ntdll.RtlGetNextRange', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlgetntglobalflags':( 'int', None, 'cdecl', 'ntdll.RtlGetNtGlobalFlags', () ),
    'ntdll.rtlgetntproducttype':( 'int', None, 'stdcall', 'ntdll.RtlGetNtProductType', (('void *', 'ptr'),) ),
    'ntdll.rtlgetntversionnumbers':( 'int', None, 'stdcall', 'ntdll.RtlGetNtVersionNumbers', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlgetownersecuritydescriptor':( 'int', None, 'stdcall', 'ntdll.RtlGetOwnerSecurityDescriptor', (('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.rtlgetprocessheaps':( 'int', None, 'stdcall', 'ntdll.RtlGetProcessHeaps', (('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlgetsaclsecuritydescriptor':( 'int', None, 'stdcall', 'ntdll.RtlGetSaclSecurityDescriptor', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlgetsecuritydescriptorrmcontrol':( 'int', None, 'stdcall', 'ntdll.RtlGetSecurityDescriptorRMControl', (('int', None), ('int', None)) ),
    'ntdll.rtlgetsetbootstatusdata':( 'int', None, 'stdcall', 'ntdll.RtlGetSetBootStatusData', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtlgetunloadeventtrace':( 'int', None, 'cdecl', 'ntdll.RtlGetUnloadEventTrace', () ),
    'ntdll.rtlgetuserinfoheap':( 'int', None, 'stdcall', 'ntdll.RtlGetUserInfoHeap', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('void *', 'obj')) ),
    'ntdll.rtlgetversion':( 'int', None, 'stdcall', 'ntdll.RtlGetVersion', (('void *', 'ptr'),) ),
    'ntdll.rtlhashunicodestring':( 'int', None, 'stdcall', 'ntdll.RtlHashUnicodeString', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlidentifierauthoritysid':( 'int', None, 'stdcall', 'ntdll.RtlIdentifierAuthoritySid', (('int', None),) ),
    'ntdll.rtlimagedirectoryentrytodata':( 'int', None, 'stdcall', 'ntdll.RtlImageDirectoryEntryToData', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlimagentheader':( 'int', None, 'stdcall', 'ntdll.RtlImageNtHeader', (('int', None),) ),
    'ntdll.rtlimagervatosection':( 'int', None, 'stdcall', 'ntdll.RtlImageRvaToSection', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlimagervatova':( 'int', None, 'stdcall', 'ntdll.RtlImageRvaToVa', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlimpersonateself':( 'int', None, 'stdcall', 'ntdll.RtlImpersonateSelf', (('int', None),) ),
    'ntdll.rtlinitansistring':( 'int', None, 'stdcall', 'ntdll.RtlInitAnsiString', (('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlinitcodepagetable':( 'int', None, 'stdcall', 'ntdll.RtlInitCodePageTable', (('int', None), ('int', None)) ),
    'ntdll.rtlinitmemorystream':( 'int', None, 'stdcall', 'ntdll.RtlInitMemoryStream', (('int', None),) ),
    'ntdll.rtlinitnlstables':( 'int', None, 'stdcall', 'ntdll.RtlInitNlsTables', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlinitoutofprocessmemorystream':( 'int', None, 'stdcall', 'ntdll.RtlInitOutOfProcessMemoryStream', (('int', None),) ),
    'ntdll.rtlinitstring':( 'int', None, 'stdcall', 'ntdll.RtlInitString', (('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlinitunicodestring':( 'int', None, 'stdcall', 'ntdll.RtlInitUnicodeString', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.rtlinitunicodestringex':( 'int', None, 'stdcall', 'ntdll.RtlInitUnicodeStringEx', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.rtlinitializeatompackage':( 'int', None, 'stdcall', 'ntdll.RtlInitializeAtomPackage', (('int', None),) ),
    'ntdll.rtlinitializebitmap':( 'int', None, 'stdcall', 'ntdll.RtlInitializeBitMap', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlinitializecontext':( 'int', None, 'stdcall', 'ntdll.RtlInitializeContext', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlinitializecriticalsection':( 'int', None, 'stdcall', 'ntdll.RtlInitializeCriticalSection', (('int', None),) ),
    'ntdll.rtlinitializecriticalsectionandspincount':( 'int', None, 'stdcall', 'ntdll.RtlInitializeCriticalSectionAndSpinCount', ( ('int', None),) ),
    'ntdll.rtlinitializegenerictable':( 'int', None, 'stdcall', 'ntdll.RtlInitializeGenericTable', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlinitializegenerictableavl':( 'int', None, 'stdcall', 'ntdll.RtlInitializeGenericTableAvl', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlinitializehandletable':( 'int', None, 'stdcall', 'ntdll.RtlInitializeHandleTable', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlinitializerxact':( 'int', None, 'stdcall', 'ntdll.RtlInitializeRXact', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlinitializerangelist':( 'int', None, 'stdcall', 'ntdll.RtlInitializeRangeList', (('int', None),) ),
    'ntdll.rtlinitializeresource':( 'int', None, 'stdcall', 'ntdll.RtlInitializeResource', () ),
    'ntdll.rtlinitializeslisthead':( 'int', None, 'stdcall', 'ntdll.RtlInitializeSListHead', (('int', None),) ),
    'ntdll.rtlinitializesid':( 'int', None, 'stdcall', 'ntdll.RtlInitializeSid', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlinitializestacktracedatabase':( 'int', None, 'stdcall', 'ntdll.RtlInitializeStackTraceDataBase', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlinsertelementgenerictable':( 'int', None, 'stdcall', 'ntdll.RtlInsertElementGenericTable', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlinsertelementgenerictableavl':( 'int', None, 'stdcall', 'ntdll.RtlInsertElementGenericTableAvl', ( ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlint64tounicodestring':( 'int', None, 'stdcall', 'ntdll.RtlInt64ToUnicodeString', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlintegertochar':( 'int', None, 'stdcall', 'ntdll.RtlIntegerToChar', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlintegertounicodestring':( 'int', None, 'stdcall', 'ntdll.RtlIntegerToUnicodeString', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlinterlockedflushslist':( 'int', None, 'stdcall', 'ntdll.RtlInterlockedFlushSList', () ),
    'ntdll.rtlinterlockedpopentryslist':( 'int', None, 'stdcall', 'ntdll.RtlInterlockedPopEntrySList', () ),
    'ntdll.rtlinterlockedpushentryslist':( 'int', None, 'stdcall', 'ntdll.RtlInterlockedPushEntrySList', (('int', None), ('int', None)) ),
    'ntdll.rtlinterlockedpushlistslist':( 'int', None, 'stdcall', 'ntdll.RtlInterlockedPushListSList', ( ('int', None), ('int', None)) ),
    'ntdll.rtlinvertrangelist':( 'int', None, 'stdcall', 'ntdll.RtlInvertRangeList', (('int', None), ('int', None)) ),
    'ntdll.rtlipv4addresstostringa':( 'int', None, 'stdcall', 'ntdll.RtlIpv4AddressToStringA', (('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlipv4addresstostringexa':( 'int', None, 'stdcall', 'ntdll.RtlIpv4AddressToStringExA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlipv4addresstostringexw':( 'int', None, 'stdcall', 'ntdll.RtlIpv4AddressToStringExW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlipv4addresstostringw':( 'int', None, 'stdcall', 'ntdll.RtlIpv4AddressToStringW', (('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlipv4stringtoaddressa':( 'int', None, 'stdcall', 'ntdll.RtlIpv4StringToAddressA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlipv4stringtoaddressexa':( 'int', None, 'stdcall', 'ntdll.RtlIpv4StringToAddressExA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlipv4stringtoaddressexw':( 'int', None, 'stdcall', 'ntdll.RtlIpv4StringToAddressExW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlipv4stringtoaddressw':( 'int', None, 'stdcall', 'ntdll.RtlIpv4StringToAddressW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlipv6addresstostringa':( 'int', None, 'stdcall', 'ntdll.RtlIpv6AddressToStringA', (('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlipv6addresstostringexa':( 'int', None, 'stdcall', 'ntdll.RtlIpv6AddressToStringExA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlipv6addresstostringexw':( 'int', None, 'stdcall', 'ntdll.RtlIpv6AddressToStringExW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlipv6addresstostringw':( 'int', None, 'stdcall', 'ntdll.RtlIpv6AddressToStringW', (('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlipv6stringtoaddressa':( 'int', None, 'stdcall', 'ntdll.RtlIpv6StringToAddressA', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlipv6stringtoaddressexa':( 'int', None, 'stdcall', 'ntdll.RtlIpv6StringToAddressExA', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtlipv6stringtoaddressexw':( 'int', None, 'stdcall', 'ntdll.RtlIpv6StringToAddressExW', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtlipv6stringtoaddressw':( 'int', None, 'stdcall', 'ntdll.RtlIpv6StringToAddressW', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlisactivationcontextactive':( 'int', None, 'stdcall', 'ntdll.RtlIsActivationContextActive', (('int', None),) ),
    'ntdll.rtlisdosdevicename_u':( 'int', None, 'stdcall', 'ntdll.RtlIsDosDeviceName_U', (('void *', 'ptr'),) ),
    'ntdll.rtlisgenerictableempty':( 'int', None, 'stdcall', 'ntdll.RtlIsGenericTableEmpty', (('int', None),) ),
    'ntdll.rtlisgenerictableemptyavl':( 'int', None, 'stdcall', 'ntdll.RtlIsGenericTableEmptyAvl', (('int', None),) ),
    'ntdll.rtlisnamelegaldos8dot3':( 'int', None, 'stdcall', 'ntdll.RtlIsNameLegalDOS8Dot3', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlisrangeavailable':( 'int', None, 'stdcall', 'ntdll.RtlIsRangeAvailable', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'funcptr'), ('int', None)) ),
    'ntdll.rtlistextunicode':( 'int', None, 'stdcall', 'ntdll.RtlIsTextUnicode', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlisthreadwithinloadercallout':( 'int', None, 'cdecl', 'ntdll.RtlIsThreadWithinLoaderCallout', () ),
    'ntdll.rtlisvalidhandle':( 'int', None, 'stdcall', 'ntdll.RtlIsValidHandle', (('int', None), ('int', None)) ),
    'ntdll.rtlisvalidindexhandle':( 'int', None, 'stdcall', 'ntdll.RtlIsValidIndexHandle', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtllargeintegeradd':( 'int', None, 'stdcall', 'ntdll.RtlLargeIntegerAdd', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtllargeintegerarithmeticshift':( 'int', None, 'stdcall', 'ntdll.RtlLargeIntegerArithmeticShift', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtllargeintegerdivide':( 'int', None, 'stdcall', 'ntdll.RtlLargeIntegerDivide', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtllargeintegernegate':( 'int', None, 'stdcall', 'ntdll.RtlLargeIntegerNegate', (('int', None), ('int', None)) ),
    'ntdll.rtllargeintegershiftleft':( 'int', None, 'stdcall', 'ntdll.RtlLargeIntegerShiftLeft', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtllargeintegershiftright':( 'int', None, 'stdcall', 'ntdll.RtlLargeIntegerShiftRight', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtllargeintegersubtract':( 'int', None, 'stdcall', 'ntdll.RtlLargeIntegerSubtract', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtllargeintegertochar':( 'int', None, 'stdcall', 'ntdll.RtlLargeIntegerToChar', (('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlleavecriticalsection':( 'int', None, 'stdcall', 'ntdll.RtlLeaveCriticalSection', ( ('int', None),) ),
    'ntdll.rtllengthrequiredsid':( 'int', None, 'stdcall', 'ntdll.RtlLengthRequiredSid', (('int', None),) ),
    'ntdll.rtllengthsecuritydescriptor':( 'int', None, 'stdcall', 'ntdll.RtlLengthSecurityDescriptor', (('int', None),) ),
    'ntdll.rtllengthsid':( 'int', None, 'stdcall', 'ntdll.RtlLengthSid', (('void *', 'ptr'),) ),
    'ntdll.rtllocaltimetosystemtime':( 'int', None, 'stdcall', 'ntdll.RtlLocalTimeToSystemTime', (('int', None), ('int', None)) ),
    'ntdll.rtllockbootstatusdata':( 'int', None, 'stdcall', 'ntdll.RtlLockBootStatusData', (('int', None),) ),
    'ntdll.rtllockheap':( 'int', None, 'stdcall', 'ntdll.RtlLockHeap', ( ('int', None),) ),
    'ntdll.rtllockmemorystreamregion':( 'int', None, 'stdcall', 'ntdll.RtlLockMemoryStreamRegion', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtllogstackbacktrace':( 'int', None, 'cdecl', 'ntdll.RtlLogStackBackTrace', () ),
    'ntdll.rtllookupatominatomtable':( 'int', None, 'stdcall', 'ntdll.RtlLookupAtomInAtomTable', ( ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtllookupelementgenerictable':( 'int', None, 'stdcall', 'ntdll.RtlLookupElementGenericTable', (('int', None), ('int', None)) ),
    'ntdll.rtllookupelementgenerictableavl':( 'int', None, 'stdcall', 'ntdll.RtlLookupElementGenericTableAvl', (('int', None), ('int', None)) ),
    'ntdll.rtlmakeselfrelativesd':( 'int', None, 'stdcall', 'ntdll.RtlMakeSelfRelativeSD', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlmapgenericmask':( 'int', None, 'stdcall', 'ntdll.RtlMapGenericMask', (('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlmapsecurityerrortontstatus':( 'int', None, 'stdcall', 'ntdll.RtlMapSecurityErrorToNtStatus', (('int', None),) ),
    'ntdll.rtlmergerangelists':( 'int', None, 'stdcall', 'ntdll.RtlMergeRangeLists', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlmovememory':( 'int', None, 'stdcall', 'ntdll.RtlMoveMemory', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlmultiappendunicodestringbuffer':( 'int', None, 'stdcall', 'ntdll.RtlMultiAppendUnicodeStringBuffer', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlmultibytetounicoden':( 'int', None, 'stdcall', 'ntdll.RtlMultiByteToUnicodeN', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlmultibytetounicodesize':( 'int', None, 'stdcall', 'ntdll.RtlMultiByteToUnicodeSize', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlnewinstancesecurityobject':( 'int', None, 'stdcall', 'ntdll.RtlNewInstanceSecurityObject', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlnewsecuritygrantedaccess':( 'int', None, 'stdcall', 'ntdll.RtlNewSecurityGrantedAccess', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlnewsecurityobject':( 'int', None, 'stdcall', 'ntdll.RtlNewSecurityObject', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlnewsecurityobjectex':( 'int', None, 'stdcall', 'ntdll.RtlNewSecurityObjectEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlnewsecurityobjectwithmultipleinheritance':( 'int', None, 'stdcall', 'ntdll.RtlNewSecurityObjectWithMultipleInheritance', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlnormalizeprocessparams':( 'int', None, 'stdcall', 'ntdll.RtlNormalizeProcessParams', (('int', None),) ),
    'ntdll.rtlntpathnametodospathname':( 'int', None, 'stdcall', 'ntdll.RtlNtPathNameToDosPathName', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtlntstatustodoserror':( 'int', None, 'stdcall', 'ntdll.RtlNtStatusToDosError', (('int', None),) ),
    'ntdll.rtlntstatustodoserrornoteb':( 'int', None, 'stdcall', 'ntdll.RtlNtStatusToDosErrorNoTeb', (('int', None),) ),
    'ntdll.rtlnumbergenerictableelements':( 'int', None, 'stdcall', 'ntdll.RtlNumberGenericTableElements', (('int', None),) ),
    'ntdll.rtlnumbergenerictableelementsavl':( 'int', None, 'stdcall', 'ntdll.RtlNumberGenericTableElementsAvl', (('int', None),) ),
    'ntdll.rtlnumberofclearbits':( 'int', None, 'stdcall', 'ntdll.RtlNumberOfClearBits', (('int', None),) ),
    'ntdll.rtlnumberofsetbits':( 'int', None, 'stdcall', 'ntdll.RtlNumberOfSetBits', (('int', None),) ),
    'ntdll.rtloemstringtounicodesize':( 'int', None, 'stdcall', 'ntdll.RtlOemStringToUnicodeSize', (('int', None),) ),
    'ntdll.rtloemstringtounicodestring':( 'int', None, 'stdcall', 'ntdll.RtlOemStringToUnicodeString', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtloemtounicoden':( 'int', None, 'stdcall', 'ntdll.RtlOemToUnicodeN', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlopencurrentuser':( 'int', None, 'stdcall', 'ntdll.RtlOpenCurrentUser', (('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlpctofileheader':( 'int', None, 'stdcall', 'ntdll.RtlPcToFileHeader', (('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlpinatominatomtable':( 'int', None, 'stdcall', 'ntdll.RtlPinAtomInAtomTable', ( ('int', None), ('int', None)) ),
    'ntdll.rtlpopframe':( 'int', None, 'stdcall', 'ntdll.RtlPopFrame', (('int', None),) ),
    'ntdll.rtlprefixstring':( 'int', None, 'stdcall', 'ntdll.RtlPrefixString', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlprefixunicodestring':( 'int', None, 'stdcall', 'ntdll.RtlPrefixUnicodeString', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtlprotectheap':( 'int', None, 'stdcall', 'ntdll.RtlProtectHeap', (('int', None), ('int', None)) ),
    'ntdll.rtlpushframe':( 'int', None, 'stdcall', 'ntdll.RtlPushFrame', (('int', None),) ),
    'ntdll.rtlqueryatominatomtable':( 'int', None, 'stdcall', 'ntdll.RtlQueryAtomInAtomTable', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'obj'), ('int', None)) ),
    'ntdll.rtlquerydepthslist':( 'int', None, 'stdcall', 'ntdll.RtlQueryDepthSList', (('int', None),) ),
    'ntdll.rtlqueryenvironmentvariable_u':( 'int', None, 'stdcall', 'ntdll.RtlQueryEnvironmentVariable_U', (('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.rtlqueryheapinformation':( 'int', None, 'stdcall', 'ntdll.RtlQueryHeapInformation', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlqueryinformationacl':( 'int', None, 'stdcall', 'ntdll.RtlQueryInformationAcl', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlqueryinformationactivationcontext':( 'int', None, 'stdcall', 'ntdll.RtlQueryInformationActivationContext', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtlqueryinformationactiveactivationcontext':( 'int', None, 'stdcall', 'ntdll.RtlQueryInformationActiveActivationContext', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtlqueryinterfacememorystream':( 'int', None, 'stdcall', 'ntdll.RtlQueryInterfaceMemoryStream', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlqueryprocessbacktraceinformation':( 'int', None, 'stdcall', 'ntdll.RtlQueryProcessBackTraceInformation', (('int', None),) ),
    'ntdll.rtlqueryprocessdebuginformation':( 'int', None, 'stdcall', 'ntdll.RtlQueryProcessDebugInformation', ( ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlqueryprocessheapinformation':( 'int', None, 'stdcall', 'ntdll.RtlQueryProcessHeapInformation', ( ('int', None),) ),
    'ntdll.rtlqueryprocesslockinformation':( 'int', None, 'stdcall', 'ntdll.RtlQueryProcessLockInformation', ( ('int', None),) ),
    'ntdll.rtlqueryregistryvalues':( 'int', None, 'stdcall', 'ntdll.RtlQueryRegistryValues', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtlquerysecurityobject':( 'int', None, 'stdcall', 'ntdll.RtlQuerySecurityObject', (('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtlquerytagheap':( 'int', None, 'stdcall', 'ntdll.RtlQueryTagHeap', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlquerytimezoneinformation':( 'int', None, 'stdcall', 'ntdll.RtlQueryTimeZoneInformation', (('int', None),) ),
    'ntdll.rtlqueueapcwow64thread':( 'int', None, 'stdcall', 'ntdll.RtlQueueApcWow64Thread', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlqueueworkitem':( 'int', None, 'stdcall', 'ntdll.RtlQueueWorkItem', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlraiseexception':( 'int', None, 'cdecl', 'ntdll.RtlRaiseException', (('void *', 'ptr'),) ),
    'ntdll.rtlraisestatus':( 'int', None, 'stdcall', 'ntdll.RtlRaiseStatus', (('int', None),) ),
    'ntdll.rtlrandom':( 'int', None, 'stdcall', 'ntdll.RtlRandom', (('int', None),) ),
    'ntdll.rtlrandomex':( 'int', None, 'stdcall', 'ntdll.RtlRandomEx', (('void *', 'ptr'),) ),
    'ntdll.rtlreallocateheap':( 'int', None, 'stdcall', 'ntdll.RtlReAllocateHeap', ( ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlreadmemorystream':( 'int', None, 'stdcall', 'ntdll.RtlReadMemoryStream', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlreadoutofprocessmemorystream':( 'int', None, 'stdcall', 'ntdll.RtlReadOutOfProcessMemoryStream', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtlrealpredecessor':( 'int', None, 'stdcall', 'ntdll.RtlRealPredecessor', (('int', None),) ),
    'ntdll.rtlrealsuccessor':( 'int', None, 'stdcall', 'ntdll.RtlRealSuccessor', (('int', None),) ),
    'ntdll.rtlregistersecurememorycachecallback':( 'int', None, 'stdcall', 'ntdll.RtlRegisterSecureMemoryCacheCallback', (('int', None),) ),
    'ntdll.rtlregisterwait':( 'int', None, 'stdcall', 'ntdll.RtlRegisterWait', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlreleaseactivationcontext':( 'int', None, 'stdcall', 'ntdll.RtlReleaseActivationContext', (('int', None),) ),
    'ntdll.rtlreleasememorystream':( 'int', None, 'stdcall', 'ntdll.RtlReleaseMemoryStream', (('int', None),) ),
    'ntdll.rtlreleasepeblock':( 'int', None, 'cdecl', 'ntdll.RtlReleasePebLock', () ),
    'ntdll.rtlreleaseresource':( 'int', None, 'stdcall', 'ntdll.RtlReleaseResource', ( ('int', None),) ),
    'ntdll.rtlremotecall':( 'int', None, 'stdcall', 'ntdll.RtlRemoteCall', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlremovevectoredexceptionhandler':( 'int', None, 'stdcall', 'ntdll.RtlRemoveVectoredExceptionHandler', ( ('int', None),) ),
    'ntdll.rtlresetrtltranslations':( 'int', None, 'stdcall', 'ntdll.RtlResetRtlTranslations', (('void *', 'ptr'),) ),
    'ntdll.rtlrestorelastwin32error':( 'int', None, 'stdcall', 'ntdll.RtlRestoreLastWin32Error', (('int', None),) ),
    'ntdll.rtlrevertmemorystream':( 'int', None, 'stdcall', 'ntdll.RtlRevertMemoryStream', (('int', None),) ),
    'ntdll.rtlrundecodeunicodestring':( 'int', None, 'stdcall', 'ntdll.RtlRunDecodeUnicodeString', (('int', None), ('int', None)) ),
    'ntdll.rtlrunencodeunicodestring':( 'int', None, 'stdcall', 'ntdll.RtlRunEncodeUnicodeString', (('int', None), ('int', None)) ),
    'ntdll.rtlsecondssince1970totime':( 'int', None, 'stdcall', 'ntdll.RtlSecondsSince1970ToTime', (('int', None), ('int', None)) ),
    'ntdll.rtlsecondssince1980totime':( 'int', None, 'stdcall', 'ntdll.RtlSecondsSince1980ToTime', (('int', None), ('int', None)) ),
    'ntdll.rtlseekmemorystream':( 'int', None, 'stdcall', 'ntdll.RtlSeekMemoryStream', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlselfrelativetoabsolutesd':( 'int', None, 'stdcall', 'ntdll.RtlSelfRelativeToAbsoluteSD', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlselfrelativetoabsolutesd2':( 'int', None, 'stdcall', 'ntdll.RtlSelfRelativeToAbsoluteSD2', (('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlsetallbits':( 'int', None, 'stdcall', 'ntdll.RtlSetAllBits', (('int', None),) ),
    'ntdll.rtlsetattributessecuritydescriptor':( 'int', None, 'stdcall', 'ntdll.RtlSetAttributesSecurityDescriptor', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlsetbits':( 'int', None, 'stdcall', 'ntdll.RtlSetBits', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlsetcontrolsecuritydescriptor':( 'int', None, 'stdcall', 'ntdll.RtlSetControlSecurityDescriptor', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlsetcriticalsectionspincount':( 'int', None, 'stdcall', 'ntdll.RtlSetCriticalSectionSpinCount', (('int', None), ('int', None)) ),
    'ntdll.rtlsetcurrentdirectory_u':( 'int', None, 'stdcall', 'ntdll.RtlSetCurrentDirectory_U', (('void *', 'ptr'),) ),
    'ntdll.rtlsetcurrentenvironment':( 'int', None, 'stdcall', 'ntdll.RtlSetCurrentEnvironment', (('int', None), ('int', None)) ),
    'ntdll.rtlsetdaclsecuritydescriptor':( 'int', None, 'stdcall', 'ntdll.RtlSetDaclSecurityDescriptor', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlsetenvironmentvariable':( 'int', None, 'stdcall', 'ntdll.RtlSetEnvironmentVariable', (('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.rtlsetgroupsecuritydescriptor':( 'int', None, 'stdcall', 'ntdll.RtlSetGroupSecurityDescriptor', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlsetheapinformation':( 'int', None, 'stdcall', 'ntdll.RtlSetHeapInformation', ( ('void *', 'obj'), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlsetinformationacl':( 'int', None, 'stdcall', 'ntdll.RtlSetInformationAcl', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlsetiocompletioncallback':( 'int', None, 'stdcall', 'ntdll.RtlSetIoCompletionCallback', ( ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlsetlastwin32error':( 'int', None, 'stdcall', 'ntdll.RtlSetLastWin32Error', (('int', None),) ),
    'ntdll.rtlsetlastwin32errorandntstatusfromntstatus':( 'int', None, 'stdcall', 'ntdll.RtlSetLastWin32ErrorAndNtStatusFromNtStatus', (('int', None),) ),
    'ntdll.rtlsetmemorystreamsize':( 'int', None, 'stdcall', 'ntdll.RtlSetMemoryStreamSize', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlsetownersecuritydescriptor':( 'int', None, 'stdcall', 'ntdll.RtlSetOwnerSecurityDescriptor', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlsetprocessiscritical':( 'int', None, 'cdecl', 'ntdll.RtlSetProcessIsCritical', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlsetsaclsecuritydescriptor':( 'int', None, 'stdcall', 'ntdll.RtlSetSaclSecurityDescriptor', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlsetsecuritydescriptorrmcontrol':( 'int', None, 'stdcall', 'ntdll.RtlSetSecurityDescriptorRMControl', (('int', None), ('int', None)) ),
    'ntdll.rtlsetsecurityobject':( 'int', None, 'stdcall', 'ntdll.RtlSetSecurityObject', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlsetsecurityobjectex':( 'int', None, 'stdcall', 'ntdll.RtlSetSecurityObjectEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlsetthreadiscritical':( 'int', None, 'cdecl', 'ntdll.RtlSetThreadIsCritical', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlsetthreadpoolstartfunc':( 'int', None, 'stdcall', 'ntdll.RtlSetThreadPoolStartFunc', (('int', None), ('int', None)) ),
    'ntdll.rtlsettimezoneinformation':( 'int', None, 'stdcall', 'ntdll.RtlSetTimeZoneInformation', ( ('void *', 'ptr'),) ),
    'ntdll.rtlsettimer':( 'int', None, 'stdcall', 'ntdll.RtlSetTimer', ( ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlsetunicodecallouts':( 'int', None, 'stdcall', 'ntdll.RtlSetUnicodeCallouts', (('int', None),) ),
    'ntdll.rtlsetuserflagsheap':( 'int', None, 'stdcall', 'ntdll.RtlSetUserFlagsHeap', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlsetuservalueheap':( 'int', None, 'stdcall', 'ntdll.RtlSetUserValueHeap', (('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'obj')) ),
    'ntdll.rtlsizeheap':( 'int', None, 'stdcall', 'ntdll.RtlSizeHeap', ( ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtlsplay':( 'int', None, 'stdcall', 'ntdll.RtlSplay', (('int', None),) ),
    'ntdll.rtlstartrxact':( 'int', None, 'stdcall', 'ntdll.RtlStartRXact', (('int', None),) ),
    'ntdll.rtlstatmemorystream':( 'int', None, 'stdcall', 'ntdll.RtlStatMemoryStream', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlstringfromguid':( 'int', None, 'stdcall', 'ntdll.RtlStringFromGUID', (('int', None), ('int', None)) ),
    'ntdll.rtlsubauthoritycountsid':( 'int', None, 'stdcall', 'ntdll.RtlSubAuthorityCountSid', (('int', None),) ),
    'ntdll.rtlsubauthoritysid':( 'int', None, 'stdcall', 'ntdll.RtlSubAuthoritySid', (('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlsubtreepredecessor':( 'int', None, 'stdcall', 'ntdll.RtlSubtreePredecessor', (('int', None),) ),
    'ntdll.rtlsubtreesuccessor':( 'int', None, 'stdcall', 'ntdll.RtlSubtreeSuccessor', (('int', None),) ),
    'ntdll.rtlsystemtimetolocaltime':( 'int', None, 'stdcall', 'ntdll.RtlSystemTimeToLocalTime', (('int', None), ('int', None)) ),
    'ntdll.rtltimefieldstotime':( 'int', None, 'stdcall', 'ntdll.RtlTimeFieldsToTime', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.rtltimetoelapsedtimefields':( 'int', None, 'msfastcall', 'ntdll.RtlTimeToElapsedTimeFields', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtltimetosecondssince1970':( 'int', None, 'stdcall', 'ntdll.RtlTimeToSecondsSince1970', (('int', None), ('int', None)) ),
    'ntdll.rtltimetosecondssince1980':( 'int', None, 'stdcall', 'ntdll.RtlTimeToSecondsSince1980', (('int', None), ('int', None)) ),
    'ntdll.rtltimetotimefields':( 'int', None, 'msfastcall', 'ntdll.RtlTimeToTimeFields', (('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.rtltracedatabaseadd':( 'int', None, 'stdcall', 'ntdll.RtlTraceDatabaseAdd', ( ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtltracedatabasecreate':( 'int', None, 'stdcall', 'ntdll.RtlTraceDatabaseCreate', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtltracedatabasedestroy':( 'int', None, 'stdcall', 'ntdll.RtlTraceDatabaseDestroy', ( ('int', None),) ),
    'ntdll.rtltracedatabaseenumerate':( 'int', None, 'stdcall', 'ntdll.RtlTraceDatabaseEnumerate', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtltracedatabasefind':( 'int', None, 'stdcall', 'ntdll.RtlTraceDatabaseFind', ( ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtltracedatabaselock':( 'int', None, 'stdcall', 'ntdll.RtlTraceDatabaseLock', (('int', None),) ),
    'ntdll.rtltracedatabaseunlock':( 'int', None, 'stdcall', 'ntdll.RtlTraceDatabaseUnlock', ( ('int', None),) ),
    'ntdll.rtltracedatabasevalidate':( 'int', None, 'stdcall', 'ntdll.RtlTraceDatabaseValidate', ( ('int', None),) ),
    'ntdll.rtltryentercriticalsection':( 'int', None, 'stdcall', 'ntdll.RtlTryEnterCriticalSection', (('int', None),) ),
    'ntdll.rtlulongbyteswap':( 'int', None, 'cdecl', 'ntdll.RtlUlongByteSwap', () ),
    'ntdll.rtlulonglongbyteswap':( 'int', None, 'cdecl', 'ntdll.RtlUlonglongByteSwap', (('int', None), ('int', None)) ),
    'ntdll.rtlunhandledexceptionfilter':( 'int', None, 'stdcall', 'ntdll.RtlUnhandledExceptionFilter', (('void *', 'ptr'),) ),
    'ntdll.rtlunhandledexceptionfilter2':( 'int', None, 'stdcall', 'ntdll.RtlUnhandledExceptionFilter2', (('int', None), ('int', None)) ),
    'ntdll.rtlunicodestringtoansisize':( 'int', None, 'stdcall', 'ntdll.RtlUnicodeStringToAnsiSize', (('int', None),) ),
    'ntdll.rtlunicodestringtoansistring':( 'int', None, 'stdcall', 'ntdll.RtlUnicodeStringToAnsiString', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlunicodestringtocountedoemstring':( 'int', None, 'stdcall', 'ntdll.RtlUnicodeStringToCountedOemString', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlunicodestringtointeger':( 'int', None, 'stdcall', 'ntdll.RtlUnicodeStringToInteger', (('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlunicodestringtooemsize':( 'int', None, 'stdcall', 'ntdll.RtlUnicodeStringToOemSize', (('int', None),) ),
    'ntdll.rtlunicodestringtooemstring':( 'int', None, 'stdcall', 'ntdll.RtlUnicodeStringToOemString', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlunicodetocustomcpn':( 'int', None, 'stdcall', 'ntdll.RtlUnicodeToCustomCPN', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlunicodetomultibyten':( 'int', None, 'stdcall', 'ntdll.RtlUnicodeToMultiByteN', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtlunicodetomultibytesize':( 'int', None, 'stdcall', 'ntdll.RtlUnicodeToMultiByteSize', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtlunicodetooemn':( 'int', None, 'stdcall', 'ntdll.RtlUnicodeToOemN', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtluniform':( 'int', None, 'stdcall', 'ntdll.RtlUniform', (('int', None),) ),
    'ntdll.rtlunlockbootstatusdata':( 'int', None, 'stdcall', 'ntdll.RtlUnlockBootStatusData', (('int', None),) ),
    'ntdll.rtlunlockheap':( 'int', None, 'stdcall', 'ntdll.RtlUnlockHeap', ( ('int', None),) ),
    'ntdll.rtlunlockmemorystreamregion':( 'int', None, 'stdcall', 'ntdll.RtlUnlockMemoryStreamRegion', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlunwind':( 'int', None, 'stdcall', 'ntdll.RtlUnwind', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlupcaseunicodechar':( 'int', None, 'stdcall', 'ntdll.RtlUpcaseUnicodeChar', (('int', None),) ),
    'ntdll.rtlupcaseunicodestring':( 'int', None, 'stdcall', 'ntdll.RtlUpcaseUnicodeString', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtlupcaseunicodestringtoansistring':( 'int', None, 'stdcall', 'ntdll.RtlUpcaseUnicodeStringToAnsiString', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlupcaseunicodestringtocountedoemstring':( 'int', None, 'stdcall', 'ntdll.RtlUpcaseUnicodeStringToCountedOemString', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlupcaseunicodestringtooemstring':( 'int', None, 'stdcall', 'ntdll.RtlUpcaseUnicodeStringToOemString', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlupcaseunicodetocustomcpn':( 'int', None, 'stdcall', 'ntdll.RtlUpcaseUnicodeToCustomCPN', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlupcaseunicodetomultibyten':( 'int', None, 'stdcall', 'ntdll.RtlUpcaseUnicodeToMultiByteN', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlupcaseunicodetooemn':( 'int', None, 'stdcall', 'ntdll.RtlUpcaseUnicodeToOemN', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtlupdatetimer':( 'int', None, 'stdcall', 'ntdll.RtlUpdateTimer', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlupperchar':( 'int', None, 'stdcall', 'ntdll.RtlUpperChar', (('int', None),) ),
    'ntdll.rtlupperstring':( 'int', None, 'stdcall', 'ntdll.RtlUpperString', (('int', None), ('int', None)) ),
    'ntdll.rtlusageheap':( 'int', None, 'stdcall', 'ntdll.RtlUsageHeap', (('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlushortbyteswap':( 'int', None, 'cdecl', 'ntdll.RtlUshortByteSwap', () ),
    'ntdll.rtlvalidacl':( 'int', None, 'stdcall', 'ntdll.RtlValidAcl', (('int', None),) ),
    'ntdll.rtlvalidrelativesecuritydescriptor':( 'int', None, 'stdcall', 'ntdll.RtlValidRelativeSecurityDescriptor', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlvalidsecuritydescriptor':( 'int', None, 'stdcall', 'ntdll.RtlValidSecurityDescriptor', (('int', None),) ),
    'ntdll.rtlvalidsid':( 'int', None, 'stdcall', 'ntdll.RtlValidSid', (('int', None),) ),
    'ntdll.rtlvalidateheap':( 'int', None, 'stdcall', 'ntdll.RtlValidateHeap', ( ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtlvalidateprocessheaps':( 'int', None, 'stdcall', 'ntdll.RtlValidateProcessHeaps', () ),
    'ntdll.rtlvalidateunicodestring':( 'int', None, 'stdcall', 'ntdll.RtlValidateUnicodeString', (('int', None), ('int', None)) ),
    'ntdll.rtlverifyversioninfo':( 'int', None, 'stdcall', 'ntdll.RtlVerifyVersionInfo', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlwalkframechain':( 'int', None, 'stdcall', 'ntdll.RtlWalkFrameChain', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.rtlwalkheap':( 'int', None, 'stdcall', 'ntdll.RtlWalkHeap', ( ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlwritememorystream':( 'int', None, 'stdcall', 'ntdll.RtlWriteMemoryStream', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlwriteregistryvalue':( 'int', None, 'stdcall', 'ntdll.RtlWriteRegistryValue', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlzeroheap':( 'int', None, 'stdcall', 'ntdll.RtlZeroHeap', (('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlzeromemory':( 'int', None, 'stdcall', 'ntdll.RtlZeroMemory', (('int', None), ('int', None)) ),
    'ntdll.rtlzombifyactivationcontext':( 'int', None, 'stdcall', 'ntdll.RtlZombifyActivationContext', (('int', None),) ),
    'ntdll.rtlpapplylengthfunction':( 'int', None, 'stdcall', 'ntdll.RtlpApplyLengthFunction', (('int', None), ('int', None), ('int', None), ('void *', 'funcptr')) ),
    'ntdll.rtlpensurebuffersize':( 'int', None, 'stdcall', 'ntdll.RtlpEnsureBufferSize', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlpnotownercriticalsection':( 'int', None, 'stdcall', 'ntdll.RtlpNotOwnerCriticalSection', (('int', None),) ),
    'ntdll.rtlpntcreatekey':( 'int', None, 'stdcall', 'ntdll.RtlpNtCreateKey', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.rtlpntenumeratesubkey':( 'int', None, 'stdcall', 'ntdll.RtlpNtEnumerateSubKey', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.rtlpntmaketemporarykey':( 'int', None, 'stdcall', 'ntdll.RtlpNtMakeTemporaryKey', (('int', None),) ),
    'ntdll.rtlpntopenkey':( 'int', None, 'stdcall', 'ntdll.RtlpNtOpenKey', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlpntqueryvaluekey':( 'int', None, 'stdcall', 'ntdll.RtlpNtQueryValueKey', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.rtlpntsetvaluekey':( 'int', None, 'stdcall', 'ntdll.RtlpNtSetValueKey', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.rtlpunwaitcriticalsection':( 'int', None, 'stdcall', 'ntdll.RtlpUnWaitCriticalSection', ( ('int', None),) ),
    'ntdll.rtlpwaitforcriticalsection':( 'int', None, 'stdcall', 'ntdll.RtlpWaitForCriticalSection', (('int', None),) ),
    'ntdll.rtlxansistringtounicodesize':( 'int', None, 'stdcall', 'ntdll.RtlxAnsiStringToUnicodeSize', (('int', None),) ),
    'ntdll.rtlxoemstringtounicodesize':( 'int', None, 'stdcall', 'ntdll.RtlxOemStringToUnicodeSize', (('int', None),) ),
    'ntdll.rtlxunicodestringtoansisize':( 'int', None, 'stdcall', 'ntdll.RtlxUnicodeStringToAnsiSize', (('int', None),) ),
    'ntdll.rtlxunicodestringtooemsize':( 'int', None, 'stdcall', 'ntdll.RtlxUnicodeStringToOemSize', (('int', None),) ),
    'ntdll.versetconditionmask':( 'int', None, 'stdcall', 'ntdll.VerSetConditionMask', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwacceptconnectport':( 'int', None, 'stdcall', 'ntdll.ZwAcceptConnectPort', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwaccesscheck':( 'int', None, 'stdcall', 'ntdll.ZwAccessCheck', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwaccesscheckandauditalarm':( 'int', None, 'stdcall', 'ntdll.ZwAccessCheckAndAuditAlarm', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwaccesscheckbytype':( 'int', None, 'stdcall', 'ntdll.ZwAccessCheckByType', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwaccesscheckbytypeandauditalarm':( 'int', None, 'stdcall', 'ntdll.ZwAccessCheckByTypeAndAuditAlarm', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwaccesscheckbytyperesultlist':( 'int', None, 'stdcall', 'ntdll.ZwAccessCheckByTypeResultList', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwaccesscheckbytyperesultlistandauditalarm':( 'int', None, 'stdcall', 'ntdll.ZwAccessCheckByTypeResultListAndAuditAlarm', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwaccesscheckbytyperesultlistandauditalarmbyhandle':( 'int', None, 'stdcall', 'ntdll.ZwAccessCheckByTypeResultListAndAuditAlarmByHandle', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwaddatom':( 'int', None, 'stdcall', 'ntdll.ZwAddAtom', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwaddbootentry':( 'int', None, 'stdcall', 'ntdll.ZwAddBootEntry', (('int', None), ('int', None)) ),
    'ntdll.zwadjustgroupstoken':( 'int', None, 'stdcall', 'ntdll.ZwAdjustGroupsToken', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwadjustprivilegestoken':( 'int', None, 'stdcall', 'ntdll.ZwAdjustPrivilegesToken', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.zwalertresumethread':( 'int', None, 'stdcall', 'ntdll.ZwAlertResumeThread', (('int', None), ('int', None)) ),
    'ntdll.zwalertthread':( 'int', None, 'stdcall', 'ntdll.ZwAlertThread', (('int', None),) ),
    'ntdll.zwallocatelocallyuniqueid':( 'int', None, 'stdcall', 'ntdll.ZwAllocateLocallyUniqueId', (('int', None),) ),
    'ntdll.zwallocateuserphysicalpages':( 'int', None, 'stdcall', 'ntdll.ZwAllocateUserPhysicalPages', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwallocateuuids':( 'int', None, 'stdcall', 'ntdll.ZwAllocateUuids', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.zwallocatevirtualmemory':( 'int', None, 'stdcall', 'ntdll.ZwAllocateVirtualMemory', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.zwaremappedfilesthesame':( 'int', None, 'stdcall', 'ntdll.ZwAreMappedFilesTheSame', (('int', None), ('int', None)) ),
    'ntdll.zwassignprocesstojobobject':( 'int', None, 'stdcall', 'ntdll.ZwAssignProcessToJobObject', (('int', None), ('int', None)) ),
    'ntdll.zwcallbackreturn':( 'int', None, 'stdcall', 'ntdll.ZwCallbackReturn', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcanceldevicewakeuprequest':( 'int', None, 'stdcall', 'ntdll.ZwCancelDeviceWakeupRequest', (('int', None),) ),
    'ntdll.zwcanceliofile':( 'int', None, 'stdcall', 'ntdll.ZwCancelIoFile', (('int', None), ('void *', 'ptr')) ),
    'ntdll.zwcanceltimer':( 'int', None, 'stdcall', 'ntdll.ZwCancelTimer', (('int', None), ('int', None)) ),
    'ntdll.zwclearevent':( 'int', None, 'stdcall', 'ntdll.ZwClearEvent', (('int', None),) ),
    'ntdll.zwclose':( 'int', None, 'stdcall', 'ntdll.ZwClose', (('int', None),) ),
    'ntdll.zwcloseobjectauditalarm':( 'int', None, 'stdcall', 'ntdll.ZwCloseObjectAuditAlarm', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcompactkeys':( 'int', None, 'stdcall', 'ntdll.ZwCompactKeys', (('int', None), ('int', None)) ),
    'ntdll.zwcomparetokens':( 'int', None, 'stdcall', 'ntdll.ZwCompareTokens', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcompleteconnectport':( 'int', None, 'stdcall', 'ntdll.ZwCompleteConnectPort', (('int', None),) ),
    'ntdll.zwcompresskey':( 'int', None, 'stdcall', 'ntdll.ZwCompressKey', (('int', None),) ),
    'ntdll.zwconnectport':( 'int', None, 'stdcall', 'ntdll.ZwConnectPort', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcontinue':( 'int', None, 'stdcall', 'ntdll.ZwContinue', (('void *', 'ptr'), ('int', None)) ),
    'ntdll.zwcreatedebugobject':( 'int', None, 'stdcall', 'ntdll.ZwCreateDebugObject', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.zwcreatedirectoryobject':( 'int', None, 'stdcall', 'ntdll.ZwCreateDirectoryObject', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcreateevent':( 'int', None, 'stdcall', 'ntdll.ZwCreateEvent', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcreateeventpair':( 'int', None, 'stdcall', 'ntdll.ZwCreateEventPair', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcreatefile':( 'int', None, 'stdcall', 'ntdll.ZwCreateFile', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcreateiocompletion':( 'int', None, 'stdcall', 'ntdll.ZwCreateIoCompletion', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcreatejobobject':( 'int', None, 'stdcall', 'ntdll.ZwCreateJobObject', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcreatejobset':( 'int', None, 'stdcall', 'ntdll.ZwCreateJobSet', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcreatekey':( 'int', None, 'stdcall', 'ntdll.ZwCreateKey', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwcreatekeyedevent':( 'int', None, 'stdcall', 'ntdll.ZwCreateKeyedEvent', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcreatemailslotfile':( 'int', None, 'stdcall', 'ntdll.ZwCreateMailslotFile', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcreatemutant':( 'int', None, 'stdcall', 'ntdll.ZwCreateMutant', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcreatenamedpipefile':( 'int', None, 'stdcall', 'ntdll.ZwCreateNamedPipeFile', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcreatepagingfile':( 'int', None, 'stdcall', 'ntdll.ZwCreatePagingFile', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcreateport':( 'int', None, 'stdcall', 'ntdll.ZwCreatePort', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcreateprocess':( 'int', None, 'stdcall', 'ntdll.ZwCreateProcess', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcreateprocessex':( 'int', None, 'stdcall', 'ntdll.ZwCreateProcessEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcreateprofile':( 'int', None, 'stdcall', 'ntdll.ZwCreateProfile', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcreatesection':( 'int', None, 'stdcall', 'ntdll.ZwCreateSection', (('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcreatesemaphore':( 'int', None, 'stdcall', 'ntdll.ZwCreateSemaphore', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcreatesymboliclinkobject':( 'int', None, 'stdcall', 'ntdll.ZwCreateSymbolicLinkObject', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcreatethread':( 'int', None, 'stdcall', 'ntdll.ZwCreateThread', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.zwcreatetimer':( 'int', None, 'stdcall', 'ntdll.ZwCreateTimer', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcreatetoken':( 'int', None, 'stdcall', 'ntdll.ZwCreateToken', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwcreatewaitableport':( 'int', None, 'stdcall', 'ntdll.ZwCreateWaitablePort', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwdebugactiveprocess':( 'int', None, 'stdcall', 'ntdll.ZwDebugActiveProcess', (('int', None), ('int', None)) ),
    'ntdll.zwdebugcontinue':( 'int', None, 'stdcall', 'ntdll.ZwDebugContinue', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwdelayexecution':( 'int', None, 'stdcall', 'ntdll.ZwDelayExecution', (('int', None), ('void *', 'ptr')) ),
    'ntdll.zwdeleteatom':( 'int', None, 'stdcall', 'ntdll.ZwDeleteAtom', (('int', None),) ),
    'ntdll.zwdeletebootentry':( 'int', None, 'stdcall', 'ntdll.ZwDeleteBootEntry', (('int', None),) ),
    'ntdll.zwdeletefile':( 'int', None, 'stdcall', 'ntdll.ZwDeleteFile', (('int', None),) ),
    'ntdll.zwdeletekey':( 'int', None, 'stdcall', 'ntdll.ZwDeleteKey', (('int', None),) ),
    'ntdll.zwdeleteobjectauditalarm':( 'int', None, 'stdcall', 'ntdll.ZwDeleteObjectAuditAlarm', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwdeletevaluekey':( 'int', None, 'stdcall', 'ntdll.ZwDeleteValueKey', (('int', None), ('void *', 'ptr')) ),
    'ntdll.zwdeviceiocontrolfile':( 'int', None, 'stdcall', 'ntdll.ZwDeviceIoControlFile', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwdisplaystring':( 'int', None, 'stdcall', 'ntdll.ZwDisplayString', (('int', None),) ),
    'ntdll.zwduplicateobject':( 'int', None, 'stdcall', 'ntdll.ZwDuplicateObject', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwduplicatetoken':( 'int', None, 'stdcall', 'ntdll.ZwDuplicateToken', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwenumeratebootentries':( 'int', None, 'stdcall', 'ntdll.ZwEnumerateBootEntries', (('int', None), ('int', None)) ),
    'ntdll.zwenumeratekey':( 'int', None, 'stdcall', 'ntdll.ZwEnumerateKey', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwenumeratesystemenvironmentvaluesex':( 'int', None, 'stdcall', 'ntdll.ZwEnumerateSystemEnvironmentValuesEx', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwenumeratevaluekey':( 'int', None, 'stdcall', 'ntdll.ZwEnumerateValueKey', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwextendsection':( 'int', None, 'stdcall', 'ntdll.ZwExtendSection', (('int', None), ('int', None)) ),
    'ntdll.zwfiltertoken':( 'int', None, 'stdcall', 'ntdll.ZwFilterToken', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwfindatom':( 'int', None, 'stdcall', 'ntdll.ZwFindAtom', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwflushbuffersfile':( 'int', None, 'stdcall', 'ntdll.ZwFlushBuffersFile', (('int', None), ('void *', 'ptr')) ),
    'ntdll.zwflushinstructioncache':( 'int', None, 'stdcall', 'ntdll.ZwFlushInstructionCache', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwflushkey':( 'int', None, 'stdcall', 'ntdll.ZwFlushKey', (('int', None),) ),
    'ntdll.zwflushvirtualmemory':( 'int', None, 'stdcall', 'ntdll.ZwFlushVirtualMemory', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwflushwritebuffer':( 'int', None, 'cdecl', 'ntdll.ZwFlushWriteBuffer', () ),
    'ntdll.zwfreeuserphysicalpages':( 'int', None, 'stdcall', 'ntdll.ZwFreeUserPhysicalPages', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwfreevirtualmemory':( 'int', None, 'stdcall', 'ntdll.ZwFreeVirtualMemory', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.zwfscontrolfile':( 'int', None, 'stdcall', 'ntdll.ZwFsControlFile', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwgetcontextthread':( 'int', None, 'stdcall', 'ntdll.ZwGetContextThread', (('int', None), ('void *', 'ptr')) ),
    'ntdll.zwgetdevicepowerstate':( 'int', None, 'stdcall', 'ntdll.ZwGetDevicePowerState', (('int', None), ('int', None)) ),
    'ntdll.zwgetplugplayevent':( 'int', None, 'stdcall', 'ntdll.ZwGetPlugPlayEvent', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwgetwritewatch':( 'int', None, 'stdcall', 'ntdll.ZwGetWriteWatch', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwimpersonateanonymoustoken':( 'int', None, 'stdcall', 'ntdll.ZwImpersonateAnonymousToken', (('int', None),) ),
    'ntdll.zwimpersonateclientofport':( 'int', None, 'stdcall', 'ntdll.ZwImpersonateClientOfPort', (('int', None), ('int', None)) ),
    'ntdll.zwimpersonatethread':( 'int', None, 'stdcall', 'ntdll.ZwImpersonateThread', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwinitializeregistry':( 'int', None, 'stdcall', 'ntdll.ZwInitializeRegistry', (('int', None),) ),
    'ntdll.zwinitiatepoweraction':( 'int', None, 'stdcall', 'ntdll.ZwInitiatePowerAction', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwisprocessinjob':( 'int', None, 'stdcall', 'ntdll.ZwIsProcessInJob', (('int', None), ('int', None)) ),
    'ntdll.zwissystemresumeautomatic':( 'int', None, 'cdecl', 'ntdll.ZwIsSystemResumeAutomatic', () ),
    'ntdll.zwlistenport':( 'int', None, 'stdcall', 'ntdll.ZwListenPort', (('int', None), ('int', None)) ),
    'ntdll.zwloaddriver':( 'int', None, 'stdcall', 'ntdll.ZwLoadDriver', (('int', None),) ),
    'ntdll.zwloadkey':( 'int', None, 'stdcall', 'ntdll.ZwLoadKey', (('int', None), ('int', None)) ),
    'ntdll.zwloadkey2':( 'int', None, 'stdcall', 'ntdll.ZwLoadKey2', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwlockfile':( 'int', None, 'stdcall', 'ntdll.ZwLockFile', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwlockproductactivationkeys':( 'int', None, 'stdcall', 'ntdll.ZwLockProductActivationKeys', (('int', None), ('int', None)) ),
    'ntdll.zwlockregistrykey':( 'int', None, 'stdcall', 'ntdll.ZwLockRegistryKey', (('int', None),) ),
    'ntdll.zwlockvirtualmemory':( 'int', None, 'stdcall', 'ntdll.ZwLockVirtualMemory', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwmakepermanentobject':( 'int', None, 'stdcall', 'ntdll.ZwMakePermanentObject', (('int', None),) ),
    'ntdll.zwmaketemporaryobject':( 'int', None, 'stdcall', 'ntdll.ZwMakeTemporaryObject', (('int', None),) ),
    'ntdll.zwmapuserphysicalpages':( 'int', None, 'stdcall', 'ntdll.ZwMapUserPhysicalPages', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwmapuserphysicalpagesscatter':( 'int', None, 'stdcall', 'ntdll.ZwMapUserPhysicalPagesScatter', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwmapviewofsection':( 'int', None, 'stdcall', 'ntdll.ZwMapViewOfSection', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwmodifybootentry':( 'int', None, 'stdcall', 'ntdll.ZwModifyBootEntry', (('int', None),) ),
    'ntdll.zwnotifychangedirectoryfile':( 'int', None, 'stdcall', 'ntdll.ZwNotifyChangeDirectoryFile', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwnotifychangekey':( 'int', None, 'stdcall', 'ntdll.ZwNotifyChangeKey', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwnotifychangemultiplekeys':( 'int', None, 'stdcall', 'ntdll.ZwNotifyChangeMultipleKeys', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwopendirectoryobject':( 'int', None, 'stdcall', 'ntdll.ZwOpenDirectoryObject', (('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwopenevent':( 'int', None, 'stdcall', 'ntdll.ZwOpenEvent', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwopeneventpair':( 'int', None, 'stdcall', 'ntdll.ZwOpenEventPair', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwopenfile':( 'int', None, 'stdcall', 'ntdll.ZwOpenFile', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.zwopeniocompletion':( 'int', None, 'stdcall', 'ntdll.ZwOpenIoCompletion', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwopenjobobject':( 'int', None, 'stdcall', 'ntdll.ZwOpenJobObject', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwopenkey':( 'int', None, 'stdcall', 'ntdll.ZwOpenKey', (('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwopenkeyedevent':( 'int', None, 'stdcall', 'ntdll.ZwOpenKeyedEvent', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwopenmutant':( 'int', None, 'stdcall', 'ntdll.ZwOpenMutant', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwopenobjectauditalarm':( 'int', None, 'stdcall', 'ntdll.ZwOpenObjectAuditAlarm', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwopenprocess':( 'int', None, 'stdcall', 'ntdll.ZwOpenProcess', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.zwopenprocesstoken':( 'int', None, 'stdcall', 'ntdll.ZwOpenProcessToken', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwopenprocesstokenex':( 'int', None, 'stdcall', 'ntdll.ZwOpenProcessTokenEx', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwopensection':( 'int', None, 'stdcall', 'ntdll.ZwOpenSection', (('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwopensemaphore':( 'int', None, 'stdcall', 'ntdll.ZwOpenSemaphore', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwopensymboliclinkobject':( 'int', None, 'stdcall', 'ntdll.ZwOpenSymbolicLinkObject', (('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwopenthread':( 'int', None, 'stdcall', 'ntdll.ZwOpenThread', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.zwopenthreadtoken':( 'int', None, 'stdcall', 'ntdll.ZwOpenThreadToken', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwopenthreadtokenex':( 'int', None, 'stdcall', 'ntdll.ZwOpenThreadTokenEx', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwopentimer':( 'int', None, 'stdcall', 'ntdll.ZwOpenTimer', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwplugplaycontrol':( 'int', None, 'stdcall', 'ntdll.ZwPlugPlayControl', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwpowerinformation':( 'int', None, 'stdcall', 'ntdll.ZwPowerInformation', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwprivilegecheck':( 'int', None, 'stdcall', 'ntdll.ZwPrivilegeCheck', (('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.zwprivilegeobjectauditalarm':( 'int', None, 'stdcall', 'ntdll.ZwPrivilegeObjectAuditAlarm', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwprivilegedserviceauditalarm':( 'int', None, 'stdcall', 'ntdll.ZwPrivilegedServiceAuditAlarm', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwprotectvirtualmemory':( 'int', None, 'stdcall', 'ntdll.ZwProtectVirtualMemory', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwpulseevent':( 'int', None, 'stdcall', 'ntdll.ZwPulseEvent', (('int', None), ('int', None)) ),
    'ntdll.zwqueryattributesfile':( 'int', None, 'stdcall', 'ntdll.ZwQueryAttributesFile', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.zwquerybootentryorder':( 'int', None, 'stdcall', 'ntdll.ZwQueryBootEntryOrder', (('int', None), ('int', None)) ),
    'ntdll.zwquerybootoptions':( 'int', None, 'stdcall', 'ntdll.ZwQueryBootOptions', (('int', None), ('int', None)) ),
    'ntdll.zwquerydebugfilterstate':( 'int', None, 'stdcall', 'ntdll.ZwQueryDebugFilterState', (('int', None), ('int', None)) ),
    'ntdll.zwquerydefaultlocale':( 'int', None, 'stdcall', 'ntdll.ZwQueryDefaultLocale', (('int', None), ('void *', 'ptr')) ),
    'ntdll.zwquerydefaultuilanguage':( 'int', None, 'stdcall', 'ntdll.ZwQueryDefaultUILanguage', (('int', None),) ),
    'ntdll.zwquerydirectoryfile':( 'int', None, 'stdcall', 'ntdll.ZwQueryDirectoryFile', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwquerydirectoryobject':( 'int', None, 'stdcall', 'ntdll.ZwQueryDirectoryObject', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwqueryeafile':( 'int', None, 'stdcall', 'ntdll.ZwQueryEaFile', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwqueryevent':( 'int', None, 'stdcall', 'ntdll.ZwQueryEvent', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwqueryfullattributesfile':( 'int', None, 'stdcall', 'ntdll.ZwQueryFullAttributesFile', (('int', None), ('int', None)) ),
    'ntdll.zwqueryinformationatom':( 'int', None, 'stdcall', 'ntdll.ZwQueryInformationAtom', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwqueryinformationfile':( 'int', None, 'stdcall', 'ntdll.ZwQueryInformationFile', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.zwqueryinformationjobobject':( 'int', None, 'stdcall', 'ntdll.ZwQueryInformationJobObject', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwqueryinformationport':( 'int', None, 'stdcall', 'ntdll.ZwQueryInformationPort', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwqueryinformationprocess':( 'int', None, 'stdcall', 'ntdll.ZwQueryInformationProcess', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.zwqueryinformationthread':( 'int', None, 'stdcall', 'ntdll.ZwQueryInformationThread', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.zwqueryinformationtoken':( 'int', None, 'stdcall', 'ntdll.ZwQueryInformationToken', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwqueryinstalluilanguage':( 'int', None, 'stdcall', 'ntdll.ZwQueryInstallUILanguage', (('int', None),) ),
    'ntdll.zwqueryintervalprofile':( 'int', None, 'stdcall', 'ntdll.ZwQueryIntervalProfile', (('int', None), ('int', None)) ),
    'ntdll.zwqueryiocompletion':( 'int', None, 'stdcall', 'ntdll.ZwQueryIoCompletion', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.zwquerykey':( 'int', None, 'stdcall', 'ntdll.ZwQueryKey', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwquerymultiplevaluekey':( 'int', None, 'stdcall', 'ntdll.ZwQueryMultipleValueKey', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwquerymutant':( 'int', None, 'stdcall', 'ntdll.ZwQueryMutant', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwqueryobject':( 'int', None, 'stdcall', 'ntdll.ZwQueryObject', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwqueryopensubkeys':( 'int', None, 'stdcall', 'ntdll.ZwQueryOpenSubKeys', (('int', None), ('int', None)) ),
    'ntdll.zwqueryperformancecounter':( 'int', None, 'stdcall', 'ntdll.ZwQueryPerformanceCounter', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.zwqueryportinformationprocess':( 'int', None, 'cdecl', 'ntdll.ZwQueryPortInformationProcess', () ),
    'ntdll.zwqueryquotainformationfile':( 'int', None, 'stdcall', 'ntdll.ZwQueryQuotaInformationFile', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwquerysection':( 'int', None, 'stdcall', 'ntdll.ZwQuerySection', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.zwquerysecurityobject':( 'int', None, 'stdcall', 'ntdll.ZwQuerySecurityObject', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwquerysemaphore':( 'int', None, 'stdcall', 'ntdll.ZwQuerySemaphore', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwquerysymboliclinkobject':( 'int', None, 'stdcall', 'ntdll.ZwQuerySymbolicLinkObject', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwquerysystemenvironmentvalue':( 'int', None, 'stdcall', 'ntdll.ZwQuerySystemEnvironmentValue', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwquerysystemenvironmentvalueex':( 'int', None, 'stdcall', 'ntdll.ZwQuerySystemEnvironmentValueEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwquerysysteminformation':( 'int', None, 'stdcall', 'ntdll.ZwQuerySystemInformation', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwquerysystemtime':( 'int', None, 'stdcall', 'ntdll.ZwQuerySystemTime', (('void *', 'ptr'),) ),
    'ntdll.zwquerytimer':( 'int', None, 'stdcall', 'ntdll.ZwQueryTimer', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.zwquerytimerresolution':( 'int', None, 'stdcall', 'ntdll.ZwQueryTimerResolution', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwqueryvaluekey':( 'int', None, 'stdcall', 'ntdll.ZwQueryValueKey', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwqueryvirtualmemory':( 'int', None, 'stdcall', 'ntdll.ZwQueryVirtualMemory', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwqueryvolumeinformationfile':( 'int', None, 'stdcall', 'ntdll.ZwQueryVolumeInformationFile', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.zwqueueapcthread':( 'int', None, 'stdcall', 'ntdll.ZwQueueApcThread', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwraiseexception':( 'int', None, 'stdcall', 'ntdll.ZwRaiseException', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.zwraiseharderror':( 'int', None, 'stdcall', 'ntdll.ZwRaiseHardError', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwreadfile':( 'int', None, 'stdcall', 'ntdll.ZwReadFile', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.zwreadfilescatter':( 'int', None, 'stdcall', 'ntdll.ZwReadFileScatter', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwreadrequestdata':( 'int', None, 'stdcall', 'ntdll.ZwReadRequestData', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwreadvirtualmemory':( 'int', None, 'stdcall', 'ntdll.ZwReadVirtualMemory', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwregisterthreadterminateport':( 'int', None, 'stdcall', 'ntdll.ZwRegisterThreadTerminatePort', (('int', None),) ),
    'ntdll.zwreleasekeyedevent':( 'int', None, 'stdcall', 'ntdll.ZwReleaseKeyedEvent', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwreleasemutant':( 'int', None, 'stdcall', 'ntdll.ZwReleaseMutant', (('int', None), ('int', None)) ),
    'ntdll.zwreleasesemaphore':( 'int', None, 'stdcall', 'ntdll.ZwReleaseSemaphore', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwremoveiocompletion':( 'int', None, 'stdcall', 'ntdll.ZwRemoveIoCompletion', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.zwremoveprocessdebug':( 'int', None, 'stdcall', 'ntdll.ZwRemoveProcessDebug', (('int', None), ('int', None)) ),
    'ntdll.zwrenamekey':( 'int', None, 'stdcall', 'ntdll.ZwRenameKey', (('int', None), ('int', None)) ),
    'ntdll.zwreplacekey':( 'int', None, 'stdcall', 'ntdll.ZwReplaceKey', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwreplyport':( 'int', None, 'stdcall', 'ntdll.ZwReplyPort', (('int', None), ('int', None)) ),
    'ntdll.zwreplywaitreceiveport':( 'int', None, 'stdcall', 'ntdll.ZwReplyWaitReceivePort', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwreplywaitreceiveportex':( 'int', None, 'stdcall', 'ntdll.ZwReplyWaitReceivePortEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwreplywaitreplyport':( 'int', None, 'stdcall', 'ntdll.ZwReplyWaitReplyPort', (('int', None), ('int', None)) ),
    'ntdll.zwrequestdevicewakeup':( 'int', None, 'stdcall', 'ntdll.ZwRequestDeviceWakeup', (('int', None),) ),
    'ntdll.zwrequestport':( 'int', None, 'stdcall', 'ntdll.ZwRequestPort', (('int', None), ('int', None)) ),
    'ntdll.zwrequestwaitreplyport':( 'int', None, 'stdcall', 'ntdll.ZwRequestWaitReplyPort', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwrequestwakeuplatency':( 'int', None, 'stdcall', 'ntdll.ZwRequestWakeupLatency', (('int', None),) ),
    'ntdll.zwresetevent':( 'int', None, 'stdcall', 'ntdll.ZwResetEvent', (('int', None), ('int', None)) ),
    'ntdll.zwresetwritewatch':( 'int', None, 'stdcall', 'ntdll.ZwResetWriteWatch', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwrestorekey':( 'int', None, 'stdcall', 'ntdll.ZwRestoreKey', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwresumeprocess':( 'int', None, 'stdcall', 'ntdll.ZwResumeProcess', (('int', None),) ),
    'ntdll.zwresumethread':( 'int', None, 'stdcall', 'ntdll.ZwResumeThread', (('int', None), ('int', None)) ),
    'ntdll.zwsavekey':( 'int', None, 'stdcall', 'ntdll.ZwSaveKey', (('int', None), ('int', None)) ),
    'ntdll.zwsavekeyex':( 'int', None, 'stdcall', 'ntdll.ZwSaveKeyEx', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwsavemergedkeys':( 'int', None, 'stdcall', 'ntdll.ZwSaveMergedKeys', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwsecureconnectport':( 'int', None, 'stdcall', 'ntdll.ZwSecureConnectPort', (('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.zwsetbootentryorder':( 'int', None, 'stdcall', 'ntdll.ZwSetBootEntryOrder', (('int', None), ('int', None)) ),
    'ntdll.zwsetbootoptions':( 'int', None, 'stdcall', 'ntdll.ZwSetBootOptions', (('int', None), ('int', None)) ),
    'ntdll.zwsetcontextthread':( 'int', None, 'stdcall', 'ntdll.ZwSetContextThread', (('int', None), ('void *', 'ptr')) ),
    'ntdll.zwsetdebugfilterstate':( 'int', None, 'stdcall', 'ntdll.ZwSetDebugFilterState', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwsetdefaultharderrorport':( 'int', None, 'stdcall', 'ntdll.ZwSetDefaultHardErrorPort', (('int', None),) ),
    'ntdll.zwsetdefaultlocale':( 'int', None, 'stdcall', 'ntdll.ZwSetDefaultLocale', (('int', None), ('int', None)) ),
    'ntdll.zwsetdefaultuilanguage':( 'int', None, 'stdcall', 'ntdll.ZwSetDefaultUILanguage', (('int', None),) ),
    'ntdll.zwseteafile':( 'int', None, 'stdcall', 'ntdll.ZwSetEaFile', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwsetevent':( 'int', None, 'stdcall', 'ntdll.ZwSetEvent', (('int', None), ('int', None)) ),
    'ntdll.zwseteventboostpriority':( 'int', None, 'stdcall', 'ntdll.ZwSetEventBoostPriority', (('int', None),) ),
    'ntdll.zwsethigheventpair':( 'int', None, 'stdcall', 'ntdll.ZwSetHighEventPair', (('int', None),) ),
    'ntdll.zwsethighwaitloweventpair':( 'int', None, 'stdcall', 'ntdll.ZwSetHighWaitLowEventPair', (('int', None),) ),
    'ntdll.zwsetinformationdebugobject':( 'int', None, 'stdcall', 'ntdll.ZwSetInformationDebugObject', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwsetinformationfile':( 'int', None, 'stdcall', 'ntdll.ZwSetInformationFile', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.zwsetinformationjobobject':( 'int', None, 'stdcall', 'ntdll.ZwSetInformationJobObject', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwsetinformationkey':( 'int', None, 'stdcall', 'ntdll.ZwSetInformationKey', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwsetinformationobject':( 'int', None, 'stdcall', 'ntdll.ZwSetInformationObject', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.zwsetinformationprocess':( 'int', None, 'stdcall', 'ntdll.ZwSetInformationProcess', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.zwsetinformationthread':( 'int', None, 'stdcall', 'ntdll.ZwSetInformationThread', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.zwsetinformationtoken':( 'int', None, 'stdcall', 'ntdll.ZwSetInformationToken', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwsetintervalprofile':( 'int', None, 'stdcall', 'ntdll.ZwSetIntervalProfile', (('int', None), ('int', None)) ),
    'ntdll.zwsetiocompletion':( 'int', None, 'stdcall', 'ntdll.ZwSetIoCompletion', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwsetldtentries':( 'int', None, 'stdcall', 'ntdll.ZwSetLdtEntries', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwsetloweventpair':( 'int', None, 'stdcall', 'ntdll.ZwSetLowEventPair', (('int', None),) ),
    'ntdll.zwsetlowwaithigheventpair':( 'int', None, 'stdcall', 'ntdll.ZwSetLowWaitHighEventPair', (('int', None),) ),
    'ntdll.zwsetquotainformationfile':( 'int', None, 'stdcall', 'ntdll.ZwSetQuotaInformationFile', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwsetsecurityobject':( 'int', None, 'stdcall', 'ntdll.ZwSetSecurityObject', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwsetsystemenvironmentvalue':( 'int', None, 'stdcall', 'ntdll.ZwSetSystemEnvironmentValue', (('int', None), ('int', None)) ),
    'ntdll.zwsetsystemenvironmentvalueex':( 'int', None, 'stdcall', 'ntdll.ZwSetSystemEnvironmentValueEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwsetsysteminformation':( 'int', None, 'stdcall', 'ntdll.ZwSetSystemInformation', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwsetsystempowerstate':( 'int', None, 'stdcall', 'ntdll.ZwSetSystemPowerState', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwsetsystemtime':( 'int', None, 'stdcall', 'ntdll.ZwSetSystemTime', (('int', None), ('int', None)) ),
    'ntdll.zwsetthreadexecutionstate':( 'int', None, 'stdcall', 'ntdll.ZwSetThreadExecutionState', (('int', None), ('int', None)) ),
    'ntdll.zwsettimer':( 'int', None, 'stdcall', 'ntdll.ZwSetTimer', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwsettimerresolution':( 'int', None, 'stdcall', 'ntdll.ZwSetTimerResolution', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwsetuuidseed':( 'int', None, 'stdcall', 'ntdll.ZwSetUuidSeed', (('int', None),) ),
    'ntdll.zwsetvaluekey':( 'int', None, 'stdcall', 'ntdll.ZwSetValueKey', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.zwsetvolumeinformationfile':( 'int', None, 'stdcall', 'ntdll.ZwSetVolumeInformationFile', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwshutdownsystem':( 'int', None, 'stdcall', 'ntdll.ZwShutdownSystem', (('int', None),) ),
    'ntdll.zwsignalandwaitforsingleobject':( 'int', None, 'stdcall', 'ntdll.ZwSignalAndWaitForSingleObject', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwstartprofile':( 'int', None, 'stdcall', 'ntdll.ZwStartProfile', (('int', None),) ),
    'ntdll.zwstopprofile':( 'int', None, 'stdcall', 'ntdll.ZwStopProfile', (('int', None),) ),
    'ntdll.zwsuspendprocess':( 'int', None, 'stdcall', 'ntdll.ZwSuspendProcess', (('int', None),) ),
    'ntdll.zwsuspendthread':( 'int', None, 'stdcall', 'ntdll.ZwSuspendThread', (('int', None), ('int', None)) ),
    'ntdll.zwsystemdebugcontrol':( 'int', None, 'stdcall', 'ntdll.ZwSystemDebugControl', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwterminatejobobject':( 'int', None, 'stdcall', 'ntdll.ZwTerminateJobObject', (('int', None), ('int', None)) ),
    'ntdll.zwterminateprocess':( 'int', None, 'stdcall', 'ntdll.ZwTerminateProcess', (('int', None), ('int', None)) ),
    'ntdll.zwterminatethread':( 'int', None, 'stdcall', 'ntdll.ZwTerminateThread', (('int', None), ('int', None)) ),
    'ntdll.zwtestalert':( 'int', None, 'cdecl', 'ntdll.ZwTestAlert', () ),
    'ntdll.zwtraceevent':( 'int', None, 'stdcall', 'ntdll.ZwTraceEvent', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwtranslatefilepath':( 'int', None, 'stdcall', 'ntdll.ZwTranslateFilePath', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwunloaddriver':( 'int', None, 'stdcall', 'ntdll.ZwUnloadDriver', (('int', None),) ),
    'ntdll.zwunloadkey':( 'int', None, 'stdcall', 'ntdll.ZwUnloadKey', (('int', None),) ),
    'ntdll.zwunloadkeyex':( 'int', None, 'stdcall', 'ntdll.ZwUnloadKeyEx', (('int', None), ('int', None)) ),
    'ntdll.zwunlockfile':( 'int', None, 'stdcall', 'ntdll.ZwUnlockFile', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwunlockvirtualmemory':( 'int', None, 'stdcall', 'ntdll.ZwUnlockVirtualMemory', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwunmapviewofsection':( 'int', None, 'stdcall', 'ntdll.ZwUnmapViewOfSection', (('int', None), ('int', None)) ),
    'ntdll.zwvdmcontrol':( 'int', None, 'stdcall', 'ntdll.ZwVdmControl', (('int', None), ('int', None)) ),
    'ntdll.zwwaitfordebugevent':( 'int', None, 'stdcall', 'ntdll.ZwWaitForDebugEvent', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwwaitforkeyedevent':( 'int', None, 'stdcall', 'ntdll.ZwWaitForKeyedEvent', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwwaitformultipleobjects':( 'int', None, 'stdcall', 'ntdll.ZwWaitForMultipleObjects', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwwaitforsingleobject':( 'int', None, 'stdcall', 'ntdll.ZwWaitForSingleObject', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'ntdll.zwwaithigheventpair':( 'int', None, 'stdcall', 'ntdll.ZwWaitHighEventPair', (('int', None),) ),
    'ntdll.zwwaitloweventpair':( 'int', None, 'stdcall', 'ntdll.ZwWaitLowEventPair', (('int', None),) ),
    'ntdll.zwwritefile':( 'int', None, 'stdcall', 'ntdll.ZwWriteFile', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.zwwritefilegather':( 'int', None, 'stdcall', 'ntdll.ZwWriteFileGather', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwwriterequestdata':( 'int', None, 'stdcall', 'ntdll.ZwWriteRequestData', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.zwwritevirtualmemory':( 'int', None, 'stdcall', 'ntdll.ZwWriteVirtualMemory', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.zwyieldexecution':( 'int', None, 'cdecl', 'ntdll.ZwYieldExecution', () ),
    'ntdll._cicos':( 'int', None, 'cdecl', 'ntdll._CIcos', () ),
    'ntdll._cilog':( 'int', None, 'cdecl', 'ntdll._CIlog', () ),
    'ntdll._cipow':( 'int', None, 'cdecl', 'ntdll._CIpow', () ),
    'ntdll._cisin':( 'int', None, 'cdecl', 'ntdll._CIsin', () ),
    'ntdll._cisqrt':( 'int', None, 'cdecl', 'ntdll._CIsqrt', () ),
    'ntdll.__isascii':( 'int', None, 'cdecl', 'ntdll.__isascii', (('int', None),) ),
    'ntdll.__iscsym':( 'int', None, 'cdecl', 'ntdll.__iscsym', (('int', None),) ),
    'ntdll.__iscsymf':( 'int', None, 'cdecl', 'ntdll.__iscsymf', (('int', None),) ),
    'ntdll.__toascii':( 'int', None, 'cdecl', 'ntdll.__toascii', (('int', None),) ),
    'ntdll._alldiv':( 'int', None, 'stdcall', 'ntdll._alldiv', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll._alldvrm':( 'int', None, 'stdcall', 'ntdll._alldvrm', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll._allmul':( 'int', None, 'stdcall', 'ntdll._allmul', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll._allrem':( 'int', None, 'stdcall', 'ntdll._allrem', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll._allshl':( 'int', None, 'cdecl', 'ntdll._allshl', () ),
    'ntdll._allshr':( 'int', None, 'cdecl', 'ntdll._allshr', () ),
    'ntdll._atoi64':( 'int', None, 'cdecl', 'ntdll._atoi64', (('int', None),) ),
    'ntdll._aulldiv':( 'int', None, 'stdcall', 'ntdll._aulldiv', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll._aulldvrm':( 'int', None, 'stdcall', 'ntdll._aulldvrm', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll._aullrem':( 'int', None, 'stdcall', 'ntdll._aullrem', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll._aullshr':( 'int', None, 'cdecl', 'ntdll._aullshr', () ),
    'ntdll._chkstk':( 'int', None, 'cdecl', 'ntdll._chkstk', () ),
    'ntdll._fltused':( 'int', None, 'cdecl', 'ntdll._fltused', () ),
    'ntdll._ftol':( 'int', None, 'cdecl', 'ntdll._ftol', () ),
    'ntdll._i64toa':( 'int', None, 'msfastcall', 'ntdll._i64toa', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll._i64tow':( 'int', None, 'msfastcall', 'ntdll._i64tow', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll._itoa':( 'int', None, 'cdecl', 'ntdll._itoa', (('int', None), ('void *', 'obj'), ('int', None)) ),
    'ntdll._itow':( 'int', None, 'cdecl', 'ntdll._itow', (('int', None), ('void *', 'obj'), ('int', None)) ),
    'ntdll._lfind':( 'int', None, 'cdecl', 'ntdll._lfind', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'funcptr')) ),
    'ntdll._ltoa':( 'int', None, 'cdecl', 'ntdll._ltoa', (('int', None), ('void *', 'obj'), ('int', None)) ),
    'ntdll._ltow':( 'int', None, 'cdecl', 'ntdll._ltow', (('int', None), ('void *', 'obj'), ('int', None)) ),
    'ntdll._memccpy':( 'int', None, 'cdecl', 'ntdll._memccpy', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll._memicmp':( 'int', None, 'cdecl', 'ntdll._memicmp', (('int', None), ('int', None), ('int', None)) ),
    'ntdll._snprintf':( 'int', None, 'cdecl', 'ntdll._snprintf', (('int', None), ('int', None), ('int', None)) ),
    'ntdll._snwprintf':( 'int', None, 'cdecl', 'ntdll._snwprintf', (('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ntdll._splitpath':( 'int', None, 'cdecl', 'ntdll._splitpath', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll._strcmpi':( 'int', None, 'cdecl', 'ntdll._strcmpi', (('int', None), ('int', None)) ),
    'ntdll._stricmp':( 'int', None, 'cdecl', 'ntdll._stricmp', (('int', None), ('int', None)) ),
    'ntdll._strlwr':( 'int', None, 'cdecl', 'ntdll._strlwr', (('int', None),) ),
    'ntdll._strnicmp':( 'int', None, 'cdecl', 'ntdll._strnicmp', (('int', None), ('int', None), ('int', None)) ),
    'ntdll._strupr':( 'int', None, 'cdecl', 'ntdll._strupr', (('int', None),) ),
    'ntdll._tolower':( 'int', None, 'cdecl', 'ntdll._tolower', (('int', None),) ),
    'ntdll._toupper':( 'int', None, 'cdecl', 'ntdll._toupper', (('int', None),) ),
    'ntdll._ui64toa':( 'int', None, 'msfastcall', 'ntdll._ui64toa', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll._ui64tow':( 'int', None, 'msfastcall', 'ntdll._ui64tow', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll._ultoa':( 'int', None, 'cdecl', 'ntdll._ultoa', (('int', None), ('void *', 'obj'), ('int', None)) ),
    'ntdll._ultow':( 'int', None, 'cdecl', 'ntdll._ultow', (('int', None), ('void *', 'obj'), ('int', None)) ),
    'ntdll._vsnprintf':( 'int', None, 'cdecl', 'ntdll._vsnprintf', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'ntdll._vsnwprintf':( 'int', None, 'cdecl', 'ntdll._vsnwprintf', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll._wcsicmp':( 'int', None, 'cdecl', 'ntdll._wcsicmp', (('int', None), ('int', None)) ),
    'ntdll._wcslwr':( 'int', None, 'cdecl', 'ntdll._wcslwr', (('int', None),) ),
    'ntdll._wcsnicmp':( 'int', None, 'cdecl', 'ntdll._wcsnicmp', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll._wcsupr':( 'int', None, 'cdecl', 'ntdll._wcsupr', (('int', None),) ),
    'ntdll._wtoi':( 'int', None, 'cdecl', 'ntdll._wtoi', (('int', None),) ),
    'ntdll._wtoi64':( 'int', None, 'cdecl', 'ntdll._wtoi64', (('int', None),) ),
    'ntdll._wtol':( 'int', None, 'cdecl', 'ntdll._wtol', (('int', None),) ),
    'ntdll.abs':( 'int', None, 'cdecl', 'ntdll.abs', (('int', None),) ),
    'ntdll.atan':( 'int', None, 'cdecl', 'ntdll.atan', () ),
    'ntdll.atoi':( 'int', None, 'cdecl', 'ntdll.atoi', (('int', None),) ),
    'ntdll.atol':( 'int', None, 'cdecl', 'ntdll.atol', (('int', None),) ),
    'ntdll.bsearch':( 'int', None, 'cdecl', 'ntdll.bsearch', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('void *', 'funcptr')) ),
    'ntdll.ceil':( 'int', None, 'cdecl', 'ntdll.ceil', () ),
    'ntdll.cos':( 'int', None, 'cdecl', 'ntdll.cos', () ),
    'ntdll.fabs':( 'int', None, 'cdecl', 'ntdll.fabs', (('int', None), ('int', None)) ),
    'ntdll.floor':( 'int', None, 'cdecl', 'ntdll.floor', () ),
    'ntdll.isalnum':( 'int', None, 'cdecl', 'ntdll.isalnum', (('int', None),) ),
    'ntdll.isalpha':( 'int', None, 'cdecl', 'ntdll.isalpha', (('int', None),) ),
    'ntdll.iscntrl':( 'int', None, 'cdecl', 'ntdll.iscntrl', (('int', None),) ),
    'ntdll.isdigit':( 'int', None, 'cdecl', 'ntdll.isdigit', (('int', None),) ),
    'ntdll.isgraph':( 'int', None, 'cdecl', 'ntdll.isgraph', (('int', None),) ),
    'ntdll.islower':( 'int', None, 'cdecl', 'ntdll.islower', (('int', None),) ),
    'ntdll.isprint':( 'int', None, 'cdecl', 'ntdll.isprint', (('int', None),) ),
    'ntdll.ispunct':( 'int', None, 'cdecl', 'ntdll.ispunct', (('int', None),) ),
    'ntdll.isspace':( 'int', None, 'cdecl', 'ntdll.isspace', (('int', None),) ),
    'ntdll.isupper':( 'int', None, 'cdecl', 'ntdll.isupper', (('int', None),) ),
    'ntdll.iswalpha':( 'int', None, 'cdecl', 'ntdll.iswalpha', (('int', None),) ),
    'ntdll.iswctype':( 'int', None, 'cdecl', 'ntdll.iswctype', (('int', None), ('int', None)) ),
    'ntdll.iswdigit':( 'int', None, 'cdecl', 'ntdll.iswdigit', (('int', None),) ),
    'ntdll.iswlower':( 'int', None, 'cdecl', 'ntdll.iswlower', (('int', None),) ),
    'ntdll.iswspace':( 'int', None, 'cdecl', 'ntdll.iswspace', (('int', None),) ),
    'ntdll.iswxdigit':( 'int', None, 'cdecl', 'ntdll.iswxdigit', (('int', None),) ),
    'ntdll.isxdigit':( 'int', None, 'cdecl', 'ntdll.isxdigit', (('int', None),) ),
    'ntdll.labs':( 'int', None, 'cdecl', 'ntdll.labs', (('int', None),) ),
    'ntdll.log':( 'int', None, 'cdecl', 'ntdll.log', () ),
    'ntdll.mbstowcs':( 'int', None, 'cdecl', 'ntdll.mbstowcs', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.memchr':( 'int', None, 'cdecl', 'ntdll.memchr', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.memcmp':( 'int', None, 'cdecl', 'ntdll.memcmp', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.memcpy':( 'int', None, 'cdecl', 'ntdll.memcpy', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.memmove':( 'int', None, 'cdecl', 'ntdll.memmove', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.memset':( 'int', None, 'cdecl', 'ntdll.memset', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.pow':( 'int', None, 'cdecl', 'ntdll.pow', () ),
    'ntdll.qsort':( 'int', None, 'stdcall', 'ntdll.qsort', ( ('void *', 'funcptr'), ('int', None), ('int', None), ('void *', 'funcptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.sin':( 'int', None, 'cdecl', 'ntdll.sin', () ),
    'ntdll.sprintf':( 'int', None, 'cdecl', 'ntdll.sprintf', (('void *', 'ptr'), ('int', None)) ),
    'ntdll.sqrt':( 'int', None, 'cdecl', 'ntdll.sqrt', () ),
    'ntdll.sscanf':( 'int', None, 'cdecl', 'ntdll.sscanf', (('int', None), ('int', None)) ),
    'ntdll.strcat':( 'int', None, 'cdecl', 'ntdll.strcat', (('int', None), ('int', None)) ),
    'ntdll.strchr':( 'int', None, 'cdecl', 'ntdll.strchr', (('int', None), ('int', None)) ),
    'ntdll.strcmp':( 'int', None, 'cdecl', 'ntdll.strcmp', (('int', None), ('int', None)) ),
    'ntdll.strcpy':( 'int', None, 'cdecl', 'ntdll.strcpy', (('int', None), ('int', None)) ),
    'ntdll.strcspn':( 'int', None, 'cdecl', 'ntdll.strcspn', (('int', None), ('int', None)) ),
    'ntdll.strlen':( 'int', None, 'cdecl', 'ntdll.strlen', (('int', None),) ),
    'ntdll.strncat':( 'int', None, 'cdecl', 'ntdll.strncat', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.strncmp':( 'int', None, 'cdecl', 'ntdll.strncmp', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.strncpy':( 'int', None, 'cdecl', 'ntdll.strncpy', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.strpbrk':( 'int', None, 'cdecl', 'ntdll.strpbrk', (('int', None), ('int', None)) ),
    'ntdll.strrchr':( 'int', None, 'cdecl', 'ntdll.strrchr', (('int', None), ('int', None)) ),
    'ntdll.strspn':( 'int', None, 'cdecl', 'ntdll.strspn', (('int', None), ('int', None)) ),
    'ntdll.strstr':( 'int', None, 'cdecl', 'ntdll.strstr', (('int', None), ('int', None)) ),
    'ntdll.strtol':( 'int', None, 'cdecl', 'ntdll.strtol', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.strtoul':( 'int', None, 'cdecl', 'ntdll.strtoul', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.swprintf':( 'int', None, 'cdecl', 'ntdll.swprintf', (('wchar *', 'ptr'), ('int', None)) ),
    'ntdll.tan':( 'int', None, 'cdecl', 'ntdll.tan', () ),
    'ntdll.tolower':( 'int', None, 'cdecl', 'ntdll.tolower', (('int', None),) ),
    'ntdll.toupper':( 'int', None, 'cdecl', 'ntdll.toupper', (('int', None),) ),
    'ntdll.towlower':( 'int', None, 'cdecl', 'ntdll.towlower', (('int', None),) ),
    'ntdll.towupper':( 'int', None, 'cdecl', 'ntdll.towupper', (('int', None),) ),
    'ntdll.vdbgprintex':( 'int', None, 'stdcall', 'ntdll.vDbgPrintEx', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.vdbgprintexwithprefix':( 'int', None, 'stdcall', 'ntdll.vDbgPrintExWithPrefix', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ntdll.vsprintf':( 'int', None, 'cdecl', 'ntdll.vsprintf', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.wcscat':( 'int', None, 'cdecl', 'ntdll.wcscat', (('int', None), ('void *', 'ptr')) ),
    'ntdll.wcschr':( 'int', None, 'cdecl', 'ntdll.wcschr', (('void *', 'ptr'), ('int', None)) ),
    'ntdll.wcscmp':( 'int', None, 'cdecl', 'ntdll.wcscmp', (('void *', 'ptr'), ('int', None)) ),
    'ntdll.wcscpy':( 'int', None, 'cdecl', 'ntdll.wcscpy', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'ntdll.wcscspn':( 'int', None, 'cdecl', 'ntdll.wcscspn', (('void *', 'ptr'), ('int', None)) ),
    'ntdll.wcslen':( 'int', None, 'cdecl', 'ntdll.wcslen', (('void *', 'ptr'),) ),
    'ntdll.wcsncat':( 'int', None, 'cdecl', 'ntdll.wcsncat', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.wcsncmp':( 'int', None, 'cdecl', 'ntdll.wcsncmp', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.wcsncpy':( 'int', None, 'cdecl', 'ntdll.wcsncpy', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ntdll.wcspbrk':( 'int', None, 'cdecl', 'ntdll.wcspbrk', (('int', None), ('int', None)) ),
    'ntdll.wcsrchr':( 'int', None, 'cdecl', 'ntdll.wcsrchr', (('int', None), ('int', None)) ),
    'ntdll.wcsspn':( 'int', None, 'cdecl', 'ntdll.wcsspn', (('int', None), ('int', None)) ),
    'ntdll.wcsstr':( 'int', None, 'cdecl', 'ntdll.wcsstr', (('void *', 'ptr'), ('int', None)) ),
    'ntdll.wcstol':( 'int', None, 'cdecl', 'ntdll.wcstol', (('int', None), ('int', None), ('int', None)) ),
    'ntdll.wcstombs':( 'int', None, 'cdecl', 'ntdll.wcstombs', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ntdll.wcstoul':( 'int', None, 'cdecl', 'ntdll.wcstoul', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    }
