/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.util;

import java.util.List;
import org.ow2.asmdex.AnnotationVisitor;
import org.ow2.asmdex.MethodVisitor;
import org.ow2.asmdex.structureCommon.Label;

public class RegisterShiftMethodAdapter
extends MethodVisitor {
    private int nbRegistersToShift;

    public RegisterShiftMethodAdapter(int api, MethodVisitor mv, int nbRegistersToShift) {
        super(api, mv);
        this.nbRegistersToShift = nbRegistersToShift;
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        super.visitMaxs(maxStack + this.nbRegistersToShift, maxLocals);
    }

    @Override
    public void visitArrayLengthInsn(int destinationRegister, int arrayReferenceBearing) {
        super.visitArrayLengthInsn(destinationRegister + this.nbRegistersToShift, arrayReferenceBearing + this.nbRegistersToShift);
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc, int valueRegister, int objectRegister) {
        super.visitFieldInsn(opcode, owner, name, desc, valueRegister + this.nbRegistersToShift, objectRegister + this.nbRegistersToShift);
    }

    @Override
    public void visitIntInsn(int opcode, int register) {
        super.visitIntInsn(opcode, register + this.nbRegistersToShift);
    }

    @Override
    public void visitJumpInsn(int opcode, Label label, int registerA, int registerB) {
        super.visitJumpInsn(opcode, label, registerA + this.nbRegistersToShift, registerB + this.nbRegistersToShift);
    }

    @Override
    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        super.visitLocalVariable(name, desc, signature, start, end, index + this.nbRegistersToShift);
    }

    @Override
    public void visitLocalVariable(String name, String desc, String signature, Label start, List<Label> ends, List<Label> restarts, int index) {
        super.visitLocalVariable(name, desc, signature, start, ends, restarts, index + this.nbRegistersToShift);
    }

    @Override
    public void visitFillArrayDataInsn(int arrayReference, Object[] arrayData) {
        super.visitFillArrayDataInsn(arrayReference + this.nbRegistersToShift, arrayData);
    }

    @Override
    public void visitArrayOperationInsn(int opcode, int valueRegister, int arrayRegister, int indexRegister) {
        super.visitArrayOperationInsn(opcode, valueRegister + this.nbRegistersToShift, arrayRegister + this.nbRegistersToShift, indexRegister + this.nbRegistersToShift);
    }

    @Override
    public void visitLookupSwitchInsn(int register, Label dflt, int[] keys, Label[] labels) {
        super.visitLookupSwitchInsn(register + this.nbRegistersToShift, dflt, keys, labels);
    }

    @Override
    public void visitTableSwitchInsn(int register, int min, int max, Label dflt, Label[] labels) {
        super.visitTableSwitchInsn(register + this.nbRegistersToShift, min, max, dflt, labels);
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int[] registers) {
        int[] registersCopy = RegisterShiftMethodAdapter.cloneAndShift(registers, this.nbRegistersToShift);
        super.visitMultiANewArrayInsn(desc, registersCopy);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, int[] arguments) {
        super.visitMethodInsn(opcode, owner, name, desc, RegisterShiftMethodAdapter.cloneAndShift(arguments, this.nbRegistersToShift));
    }

    @Override
    public void visitOperationInsn(int opcode, int destinationRegister, int firstSourceRegister, int secondSourceRegister, int value) {
        super.visitOperationInsn(opcode, destinationRegister + this.nbRegistersToShift, firstSourceRegister + this.nbRegistersToShift, secondSourceRegister + this.nbRegistersToShift, value);
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        return super.visitParameterAnnotation(parameter + this.nbRegistersToShift, desc, visible);
    }

    @Override
    public void visitStringInsn(int opcode, int destinationRegister, String string) {
        super.visitStringInsn(opcode, destinationRegister + this.nbRegistersToShift, string);
    }

    @Override
    public void visitTypeInsn(int opcode, int destinationRegister, int referenceBearingRegister, int sizeRegister, String type) {
        super.visitTypeInsn(opcode, destinationRegister + this.nbRegistersToShift, referenceBearingRegister + this.nbRegistersToShift, sizeRegister + this.nbRegistersToShift, type);
    }

    @Override
    public void visitVarInsn(int opcode, int destinationRegister, int var) {
        super.visitVarInsn(opcode, destinationRegister + this.nbRegistersToShift, var);
    }

    @Override
    public void visitVarInsn(int opcode, int destinationRegister, long var) {
        super.visitVarInsn(opcode, destinationRegister + this.nbRegistersToShift, var);
    }

    private static int[] cloneAndShift(int[] sourceArray, int shift) {
        int size = sourceArray.length;
        int[] destArray = new int[size];
        int i = 0;
        while (i < size) {
            destArray[i] = sourceArray[i] + shift;
            ++i;
        }
        return destArray;
    }
}

