/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.ow2.asmdex.AnnotationVisitor;
import org.ow2.asmdex.MethodVisitor;
import org.ow2.asmdex.structureCommon.Label;
import org.ow2.asmdex.util.AsmDexPrinter;
import org.ow2.asmdex.util.AsmDexifierAnnotationVisitor;
import org.ow2.asmdex.util.TextComponent;

public class AsmDexifierMethodVisitor
extends MethodVisitor {
    private final AsmDexPrinter pr;
    private HashMap<Label, String> labelNames = new HashMap();

    public AsmDexifierMethodVisitor(int api, int nbTabulations) {
        super(api);
        this.pr = new AsmDexPrinter();
        this.pr.currentTabulation = nbTabulations;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.pr.addTabulation();
        this.pr.addText("{\n");
        this.pr.addTabulation();
        this.pr.addText("\tav0 = mv.visitAnnotation(");
        this.pr.addConstant(desc, true);
        this.pr.addBoolean(visible, false);
        this.pr.addText(");");
        this.pr.addEOL();
        this.pr.closeText();
        AsmDexifierAnnotationVisitor av = new AsmDexifierAnnotationVisitor(this.api, 0, this.pr.currentTabulation + 1);
        this.pr.addTextToList(av.getTextComponent());
        this.pr.addTabulation();
        this.pr.addText("}\n");
        this.pr.closeText();
        return av;
    }

    @Override
    public AnnotationVisitor visitAnnotationDefault() {
        this.pr.addTabulation();
        this.pr.addText("{\n");
        this.pr.addTabulation();
        this.pr.addText("\tav0 = mv.visitAnnotationDefault();");
        this.pr.addEOL();
        this.pr.closeText();
        AsmDexifierAnnotationVisitor av = new AsmDexifierAnnotationVisitor(this.api, 0, this.pr.currentTabulation + 1);
        this.pr.addTextToList(av.getTextComponent());
        this.pr.addTabulation();
        this.pr.addText("}\n");
        this.pr.closeText();
        return av;
    }

    @Override
    public void visitArrayLengthInsn(int destinationRegister, int arrayReferenceBearing) {
        this.pr.addTabulation();
        this.pr.addText("mv.visitArrayLengthInsn(");
        this.pr.addNumber(destinationRegister, true);
        this.pr.addNumber(arrayReferenceBearing, false);
        this.pr.addText(");");
        this.pr.addEOL();
        this.pr.closeText();
    }

    @Override
    public void visitArrayOperationInsn(int opcode, int valueRegister, int arrayRegister, int indexRegister) {
        this.pr.addTabulation();
        this.pr.addText("mv.visitArrayOperationInsn(");
        this.pr.addOpcode(opcode, true);
        this.pr.addNumber(valueRegister, true);
        this.pr.addNumber(arrayRegister, true);
        this.pr.addNumber(indexRegister, false);
        this.pr.addText(");");
        this.pr.addEOL();
        this.pr.closeText();
    }

    @Override
    public void visitAttribute(Object attr) {
    }

    @Override
    public void visitCode() {
        this.pr.addTabulation();
        this.pr.addText("mv.visitCode();\n");
        this.pr.closeText();
    }

    @Override
    public void visitEnd() {
        this.pr.addTabulation();
        this.pr.addText("mv.visitEnd();\n");
        this.pr.closeText();
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc, int valueRegister, int objectRegister) {
        this.pr.addTabulation();
        this.pr.addText("mv.visitFieldInsn(");
        this.pr.addOpcode(opcode, true);
        this.pr.addConstant(owner, true);
        this.pr.addConstant(name, true);
        this.pr.addConstant(desc, true);
        this.pr.addNumber(valueRegister, true);
        this.pr.addNumber(objectRegister, false);
        this.pr.addText(");");
        this.pr.addEOL();
        this.pr.closeText();
    }

    @Override
    public void visitFillArrayDataInsn(int arrayReference, Object[] arrayData) {
        this.pr.addTabulation();
        this.pr.addText("mv.visitFillArrayDataInsn(");
        this.pr.addNumber(arrayReference, true);
        this.pr.addConstant(arrayData, false);
        this.pr.addText(");");
        this.pr.addEOL();
        this.pr.closeText();
    }

    @Override
    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
    }

    @Override
    public void visitInsn(int opcode) {
        this.pr.addTabulation();
        this.pr.addText("mv.visitInsn(");
        this.pr.addOpcode(opcode, false);
        this.pr.addText(");");
        this.pr.addEOL();
        this.pr.closeText();
    }

    @Override
    public void visitIntInsn(int opcode, int register) {
        this.pr.addTabulation();
        this.pr.addText("mv.visitIntInsn(");
        this.pr.addOpcode(opcode, true);
        this.pr.addNumber(register, false);
        this.pr.addText(");");
        this.pr.addEOL();
        this.pr.closeText();
    }

    @Override
    public void visitJumpInsn(int opcode, Label label, int registerA, int registerB) {
        String name = this.declareLabel(label);
        this.pr.addTabulation();
        this.pr.addText("mv.visitJumpInsn(");
        this.pr.addOpcode(opcode, true);
        this.pr.addText(name, true);
        this.pr.addNumber(registerA, true);
        this.pr.addNumber(registerB, false);
        this.pr.addText(");");
        this.pr.addEOL();
        this.pr.closeText();
    }

    @Override
    public void visitLabel(Label label) {
        String name = this.declareLabel(label);
        this.pr.addTabulation();
        this.pr.addText("mv.visitLabel(" + name + ");\n");
        this.pr.closeText();
    }

    @Override
    public void visitLineNumber(int line, Label start) {
        String name = this.declareLabel(start);
        this.pr.addTabulation();
        this.pr.addText("mv.visitLineNumber(");
        this.pr.addNumber(line, true);
        this.pr.addText(String.valueOf(name) + ");");
        this.pr.addEOL();
        this.pr.closeText();
    }

    @Override
    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        String nameStart = this.declareLabel(start);
        String nameEnd = this.declareLabel(end);
        this.pr.addTabulation();
        this.pr.addText("mv.visitLocalVariable(");
        this.pr.addConstant(name, true);
        this.pr.addConstant(desc, true);
        this.pr.addConstant(signature, true);
        this.pr.addText(nameStart, true);
        this.pr.addText(nameEnd, true);
        this.pr.addNumber(index, false);
        this.pr.addText(");");
        this.pr.addEOL();
        this.pr.closeText();
    }

    @Override
    public void visitLocalVariable(String name, String desc, String signature, Label start, List<Label> ends, List<Label> restarts, int index) {
        String nameStart = this.declareLabel(start);
        List<String> nameEnds = this.declareLabelsToList(ends);
        List<String> nameRestarts = this.declareLabelsToList(restarts);
        this.pr.addTabulation();
        this.pr.addText("mv.visitLocalVariable(");
        this.pr.addConstant(name, true);
        this.pr.addConstant(desc, true);
        this.pr.addConstant(signature, true);
        this.pr.addText(nameStart, true);
        this.pr.addStringArrayList(nameEnds, true);
        this.pr.addStringArrayList(nameRestarts, true);
        this.pr.addNumber(index, false);
        this.pr.addText(");");
        this.pr.addEOL();
        this.pr.closeText();
    }

    @Override
    public void visitLookupSwitchInsn(int register, Label dflt, int[] keys, Label[] labels) {
        String nameDefault = this.declareLabel(dflt);
        String[] nameLabels = this.declareLabels(labels);
        this.pr.addTabulation();
        this.pr.addText("mv.visitLookupSwitchInsn(");
        this.pr.addNumber(register, true);
        this.pr.addText(nameDefault, true);
        this.pr.addConstant(keys, true);
        this.pr.addLabelArray(nameLabels, false);
        this.pr.addText(");");
        this.pr.addEOL();
        this.pr.closeText();
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        this.pr.addTabulation();
        this.pr.addText("mv.visitMaxs(");
        this.pr.addNumber(maxStack, true);
        this.pr.addNumber(maxLocals, false);
        this.pr.addText(");");
        this.pr.addEOL();
        this.pr.closeText();
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, int[] arguments) {
        this.pr.addTabulation();
        this.pr.addText("mv.visitMethodInsn(");
        this.pr.addOpcode(opcode, true);
        this.pr.addConstant(owner, true);
        this.pr.addConstant(name, true);
        this.pr.addConstant(desc, true);
        this.pr.addConstant(arguments, false);
        this.pr.addText(");");
        this.pr.addEOL();
        this.pr.closeText();
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int[] registers) {
        this.pr.addTabulation();
        this.pr.addText("mv.visitMultiANewArrayInsn(");
        this.pr.addConstant(desc, true);
        this.pr.addConstant(registers, false);
        this.pr.addText(");");
        this.pr.addEOL();
        this.pr.closeText();
    }

    @Override
    public void visitOperationInsn(int opcode, int destinationRegister, int firstSourceRegister, int secondSourceRegister, int value) {
        this.pr.addTabulation();
        this.pr.addText("mv.visitOperationInsn(");
        this.pr.addOpcode(opcode, true);
        this.pr.addNumber(destinationRegister, true);
        this.pr.addNumber(firstSourceRegister, true);
        this.pr.addNumber(secondSourceRegister, true);
        this.pr.addNumber(value, false);
        this.pr.addText(");");
        this.pr.addEOL();
        this.pr.closeText();
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        this.pr.addTabulation();
        this.pr.addText("{\n");
        this.pr.addTabulation();
        this.pr.addText("\tav0 = mv.visitParameterAnnotation(");
        this.pr.addNumber(parameter, true);
        this.pr.addConstant(desc, true);
        this.pr.addBoolean(visible, false);
        this.pr.addText(");");
        this.pr.addEOL();
        this.pr.closeText();
        AsmDexifierAnnotationVisitor av = new AsmDexifierAnnotationVisitor(this.api, 0, this.pr.currentTabulation + 1);
        this.pr.addTextToList(av.getTextComponent());
        this.pr.addTabulation();
        this.pr.addText("}\n");
        this.pr.closeText();
        return av;
    }

    @Override
    public void visitParameters(String[] parameters) {
        this.pr.addTabulation();
        this.pr.addText("mv.visitParameters(");
        this.pr.addConstant(parameters, false);
        this.pr.addText(");");
        this.pr.addEOL();
        this.pr.closeText();
    }

    @Override
    public void visitStringInsn(int opcode, int destinationRegister, String string) {
        this.pr.addTabulation();
        this.pr.addText("mv.visitStringInsn(");
        this.pr.addOpcode(opcode, true);
        this.pr.addNumber(destinationRegister, true);
        this.pr.addConstant(string, false);
        this.pr.addText(");");
        this.pr.addEOL();
        this.pr.closeText();
    }

    @Override
    public void visitTableSwitchInsn(int register, int min, int max, Label dflt, Label[] labels) {
        String nameDefault = this.declareLabel(dflt);
        String[] nameLabels = this.declareLabels(labels);
        this.pr.addTabulation();
        this.pr.addText("mv.visitTableSwitchInsn(");
        this.pr.addNumber(register, true);
        this.pr.addNumber(min, true);
        this.pr.addNumber(max, true);
        this.pr.addText(nameDefault, true);
        this.pr.addLabelArray(nameLabels, false);
        this.pr.addText(");");
        this.pr.addEOL();
        this.pr.closeText();
    }

    @Override
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        String nameStart = this.declareLabel(start);
        String nameEnd = this.declareLabel(end);
        String nameHandler = this.declareLabel(handler);
        this.pr.addTabulation();
        this.pr.addText("mv.visitTryCatchBlock(");
        this.pr.addText(nameStart, true);
        this.pr.addText(nameEnd, true);
        this.pr.addText(nameHandler, true);
        this.pr.addConstant(type, false);
        this.pr.addText(");");
        this.pr.addEOL();
        this.pr.closeText();
    }

    @Override
    public void visitTypeInsn(int opcode, int destinationRegister, int referenceBearingRegister, int sizeRegister, String type) {
        this.pr.addTabulation();
        this.pr.addText("mv.visitTypeInsn(");
        this.pr.addOpcode(opcode, true);
        this.pr.addNumber(destinationRegister, true);
        this.pr.addNumber(referenceBearingRegister, true);
        this.pr.addNumber(sizeRegister, true);
        this.pr.addConstant(type, false);
        this.pr.addText(");");
        this.pr.addEOL();
        this.pr.closeText();
    }

    @Override
    public void visitVarInsn(int opcode, int destinationRegister, int var) {
        this.pr.addTabulation();
        this.pr.addText("mv.visitVarInsn(");
        this.pr.addOpcode(opcode, true);
        this.pr.addNumber(destinationRegister, true);
        this.pr.addNumber(var, false);
        this.pr.addText(");");
        this.pr.addEOL();
        this.pr.closeText();
    }

    @Override
    public void visitVarInsn(int opcode, int destinationRegister, long var) {
        this.pr.addTabulation();
        this.pr.addText("mv.visitVarInsn(");
        this.pr.addOpcode(opcode, true);
        this.pr.addNumber(destinationRegister, true);
        this.pr.addNumber(var, false);
        this.pr.addText(");");
        this.pr.addEOL();
        this.pr.closeText();
    }

    private String declareLabel(Label label) {
        String name = null;
        if (label != null) {
            if (!this.labelNames.containsKey(label)) {
                this.pr.addTabulation();
                name = "l" + this.labelNames.size();
                this.labelNames.put(label, name);
                this.pr.addText("Label " + name + " = new Label();\n");
            } else {
                name = this.labelNames.get(label);
            }
        }
        return name;
    }

    private String[] declareLabels(Label[] labels) {
        String[] names = new String[labels.length];
        int i = 0;
        Label[] labelArray = labels;
        int n = labels.length;
        int n2 = 0;
        while (n2 < n) {
            Label label = labelArray[n2];
            names[i] = this.declareLabel(label);
            ++i;
            ++n2;
        }
        return names;
    }

    private List<String> declareLabelsToList(List<Label> labels) {
        ArrayList<String> names = null;
        if (labels != null) {
            names = new ArrayList<String>(labels.size());
            for (Label label : labels) {
                names.add(this.declareLabel(label));
            }
        }
        return names;
    }

    public TextComponent getTextComponent() {
        return this.pr.getTextComponent();
    }
}

