/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.util;

import java.util.List;
import org.ow2.asmdex.util.AsmDexifierApplicationVisitor;
import org.ow2.asmdex.util.TextComponent;
import org.ow2.asmdex.util.TextComposite;
import org.ow2.asmdex.util.TextLeaf;

public class AsmDexPrinter {
    private static String[] accessStrings = new String[]{"ACC_PUBLIC", "ACC_PRIVATE", "ACC_PROTECTED", "ACC_STATIC", "ACC_FINAL", "ACC_SYNCHRONIZED", "ACC_VOLATILE", "ACC_TRANSIENT", "ACC_NATIVE", "ACC_INTERFACE", "ACC_ABSTRACT", "ACC_STRICT", "ACC_SYNTHETIC", "ACC_ANNOTATION", "ACC_ENUM", "", "ACC_CONSTRUCTOR", "ACC_DECLARED_SYNCHRONIZED"};
    protected int currentTabulation = 0;
    protected StringBuffer text = new StringBuffer();
    private TextComposite textComposite = new TextComposite();

    protected TextComponent getTextComponent() {
        return this.textComposite;
    }

    public void closeText() {
        TextLeaf component = new TextLeaf(this.text);
        this.textComposite.addComponent(component);
        this.text = new StringBuffer();
    }

    public void addTextToList(TextComponent tc) {
        this.textComposite.addComponent(tc);
    }

    public void addComma() {
        this.text.append(", ");
    }

    public void addEOL() {
        this.text.append("\n");
    }

    public void addBoolean(boolean bool, boolean addComma) {
        this.addText(bool ? "true" : "false", addComma);
    }

    public void addText(String textToAdd) {
        this.text.append(textToAdd);
    }

    public void addText(String textToAdd, boolean addComma) {
        this.addText(textToAdd);
        if (addComma) {
            this.addComma();
        }
    }

    public void addConstant(Object cst, boolean addComma) {
        if (cst == null) {
            this.text.append("null");
        } else if (cst instanceof String) {
            this.appendString((String)cst);
        } else if (cst instanceof Integer) {
            this.text.append(cst);
        } else if (cst instanceof Boolean) {
            this.text.append(cst);
        } else if (cst instanceof Byte) {
            this.text.append("Byte.valueOf((byte)").append(cst).append(')');
        } else if (cst instanceof Character) {
            char c = ((Character)cst).charValue();
            this.text.append("Character.valueOf((char)").append((int)c).append(')');
        } else if (cst instanceof Short) {
            this.text.append("Short.valueOf((short)").append(cst).append(')');
        } else if (cst instanceof Double) {
            this.addNumber((Double)cst, false);
        } else if (cst instanceof Float) {
            this.addNumber(((Float)cst).floatValue(), false);
        } else if (cst instanceof Long) {
            this.addNumber((Long)cst, false);
        } else if (cst instanceof int[]) {
            this.text.append("new int[] { ");
            int[] ints = (int[])cst;
            int i = 0;
            int size = ints.length;
            while (i < size) {
                this.addNumber(ints[i], i != size - 1);
                ++i;
            }
            this.text.append(" }");
        } else if (cst instanceof boolean[]) {
            this.text.append("new boolean[] { ");
            boolean[] array = (boolean[])cst;
            int i = 0;
            int size = array.length;
            while (i < size) {
                this.addBoolean(array[i], i != size - 1);
                ++i;
            }
            this.text.append(" }");
        } else if (cst instanceof byte[]) {
            this.text.append("new byte[] { ");
            byte[] array = (byte[])cst;
            int i = 0;
            int size = array.length;
            while (i < size) {
                this.addNumber(array[i], i != size - 1);
                ++i;
            }
            this.text.append(" }");
        } else if (cst instanceof short[]) {
            this.text.append("new short[] { ");
            short[] array = (short[])cst;
            int i = 0;
            int size = array.length;
            while (i < size) {
                this.addNumber(array[i], i != size - 1);
                ++i;
            }
            this.text.append(" }");
        } else if (cst instanceof char[]) {
            this.text.append("new char[] { ");
            char[] array = (char[])cst;
            int i = 0;
            int size = array.length;
            while (i < size) {
                this.addNumber(array[i], i != size - 1);
                ++i;
            }
            this.text.append(" }");
        } else if (cst instanceof float[]) {
            this.text.append("new float[] { ");
            float[] array = (float[])cst;
            int i = 0;
            int size = array.length;
            while (i < size) {
                this.addNumber(array[i], i != size - 1);
                ++i;
            }
            this.text.append(" }");
        } else if (cst instanceof double[]) {
            this.text.append("new double[] { ");
            double[] array = (double[])cst;
            int i = 0;
            int size = array.length;
            while (i < size) {
                this.addNumber(array[i], i != size - 1);
                ++i;
            }
            this.text.append(" }");
        } else if (cst instanceof long[]) {
            this.text.append("new long[] { ");
            long[] array = (long[])cst;
            int i = 0;
            int size = array.length;
            while (i < size) {
                this.addNumber(array[i], i != size - 1);
                ++i;
            }
            this.text.append(" }");
        } else if (cst instanceof String[]) {
            this.text.append("new String[] { ");
            String[] strings = (String[])cst;
            int i = 0;
            int size = strings.length;
            while (i < size) {
                this.addConstant(strings[i], i != size - 1);
                ++i;
            }
            this.text.append(" }");
        } else if (cst instanceof Byte[]) {
            this.text.append("new Byte[] { ");
            Byte[] array = (Byte[])cst;
            int i = 0;
            int size = array.length;
            while (i < size) {
                this.addNumber(array[i].byteValue(), i != size - 1);
                ++i;
            }
            this.text.append(" }");
        } else if (cst instanceof Integer[]) {
            this.text.append("new Integer[] { ");
            Integer[] ints = (Integer[])cst;
            int i = 0;
            int size = ints.length;
            while (i < size) {
                this.addNumber(ints[i], i != size - 1);
                ++i;
            }
            this.text.append(" }");
        } else if (cst instanceof Boolean[]) {
            this.text.append("new Boolean[] { ");
            Boolean[] array = (Boolean[])cst;
            int i = 0;
            int size = array.length;
            while (i < size) {
                this.addBoolean(array[i], i != size - 1);
                ++i;
            }
            this.text.append(" }");
        } else if (cst instanceof Short[]) {
            this.text.append("new Short[] { ");
            Short[] array = (Short[])cst;
            int i = 0;
            int size = array.length;
            while (i < size) {
                this.addNumber(array[i].shortValue(), i != size - 1);
                ++i;
            }
            this.text.append(" }");
        } else if (cst instanceof Character[]) {
            this.text.append("new Character[] { ");
            Character[] array = (Character[])cst;
            int i = 0;
            int size = array.length;
            while (i < size) {
                this.addNumber(array[i].charValue(), i != size - 1);
                ++i;
            }
            this.text.append(" }");
        } else if (cst instanceof Float[]) {
            this.text.append("new Float[] { ");
            Float[] array = (Float[])cst;
            int i = 0;
            int size = array.length;
            while (i < size) {
                this.addNumber(array[i].floatValue(), i != size - 1);
                ++i;
            }
            this.text.append(" }");
        } else if (cst instanceof Double[]) {
            this.text.append("new Double[] { ");
            Double[] array = (Double[])cst;
            int i = 0;
            int size = array.length;
            while (i < size) {
                this.addNumber(array[i], i != size - 1);
                ++i;
            }
            this.text.append(" }");
        } else if (cst instanceof Long[]) {
            this.text.append("new Long[] { ");
            Long[] array = (Long[])cst;
            int i = 0;
            int size = array.length;
            while (i < size) {
                this.addNumber(array[i], i != size - 1);
                ++i;
            }
            this.text.append(" }");
        } else {
            try {
                throw new Exception("Unhandled constant type.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (addComma) {
            this.addComma();
        }
    }

    public void addStringArrayList(List<String> list, boolean addComma) {
        if (list == null) {
            this.text.append("null");
        } else {
            this.text.append("new ArrayList<Label>(Arrays.asList(");
            int i = 0;
            for (String string : list) {
                if (i != 0) {
                    this.text.append(", ");
                }
                this.text.append(string);
                ++i;
            }
            this.text.append("))");
        }
        if (addComma) {
            this.addComma();
        }
    }

    public void addLabelArray(String[] labelNames, boolean addComma) {
        if (labelNames == null) {
            this.addText("null", addComma);
        } else {
            this.addText("new Label[] { ");
            boolean isFirst = true;
            String[] stringArray = labelNames;
            int n = labelNames.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (!isFirst) {
                    this.addComma();
                }
                this.addText(string);
                isFirst = false;
                ++n2;
            }
            this.addText(" }", addComma);
        }
    }

    public void addAccessFlags(int accessFlags, boolean addComma) {
        if (accessFlags == 0) {
            this.text.append('0');
        } else {
            boolean isFirst = true;
            int accessIndex = 0;
            while (accessFlags != 0) {
                if ((accessFlags & 1) != 0) {
                    if (!isFirst) {
                        this.text.append(" + ");
                    }
                    this.text.append(accessStrings[accessIndex]);
                    isFirst = false;
                }
                accessFlags >>>= 1;
                ++accessIndex;
            }
        }
        if (addComma) {
            this.addComma();
        }
    }

    public void appendString(String s) {
        this.text.append('\"');
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '\n') {
                this.text.append("\\n");
            } else if (c == '\r') {
                this.text.append("\\r");
            } else if (c == '\\') {
                this.text.append("\\\\");
            } else if (c == '\"') {
                this.text.append("\\\"");
            } else if (c < ' ' || c > '\u007f') {
                this.text.append("\\u");
                if (c < '\u0010') {
                    this.text.append("000");
                } else if (c < '\u0100') {
                    this.text.append("00");
                } else if (c < '\u1000') {
                    this.text.append('0');
                }
                this.text.append(Integer.toString(c, 16));
            } else {
                this.text.append(c);
            }
            ++i;
        }
        this.text.append('\"');
    }

    public void addNumber(int nb, boolean addComma) {
        this.text.append(nb);
        if (addComma) {
            this.addComma();
        }
    }

    public void addNumber(float nb, boolean addComma) {
        this.text.append(nb);
        this.text.append('f');
        if (addComma) {
            this.addComma();
        }
    }

    public void addNumber(long nb, boolean addComma) {
        this.text.append(nb);
        this.text.append('L');
        if (addComma) {
            this.addComma();
        }
    }

    public void addNumber(double nb, boolean addComma) {
        this.text.append(nb);
        this.text.append('d');
        if (addComma) {
            this.addComma();
        }
    }

    public void addOpcode(int opcode, boolean addComma) {
        String string = AsmDexifierApplicationVisitor.getOpcodeName(opcode);
        if (string == null) {
            string = "0x" + Integer.toHexString(opcode);
        }
        this.text.append(string);
        if (addComma) {
            this.addComma();
        }
    }

    public void addTabulation() {
        int i = 0;
        while (i < this.currentTabulation) {
            this.text.append("\t");
            ++i;
        }
    }
}

