/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.ow2.asmdex.MethodVisitor;
import org.ow2.asmdex.structureCommon.Label;
import org.ow2.asmdex.tree.AbstractInsnNode;
import org.ow2.asmdex.tree.LabelNode;

public class LookupSwitchInsnNode
extends AbstractInsnNode {
    public int register;
    public LabelNode dflt;
    public List<Integer> keys;
    public List<LabelNode> labels;

    public LookupSwitchInsnNode(int register, LabelNode dflt, int[] keys, LabelNode[] labels) {
        super(44);
        this.register = register;
        this.dflt = dflt;
        this.keys = new ArrayList<Integer>(keys == null ? 0 : keys.length);
        this.labels = new ArrayList<LabelNode>(labels == null ? 0 : labels.length);
        if (keys != null) {
            int i = 0;
            while (i < keys.length) {
                this.keys.add(keys[i]);
                ++i;
            }
        }
        if (labels != null) {
            this.labels.addAll(Arrays.asList(labels));
        }
    }

    @Override
    public int getType() {
        return 12;
    }

    @Override
    public void accept(MethodVisitor mv) {
        int[] keys = new int[this.keys.size()];
        int i = 0;
        while (i < keys.length) {
            keys[i] = this.keys.get(i);
            ++i;
        }
        Label[] labels = new Label[this.labels.size()];
        int i2 = 0;
        while (i2 < labels.length) {
            labels[i2] = this.labels.get(i2).getLabel();
            ++i2;
        }
        mv.visitLookupSwitchInsn(this.register, this.dflt.getLabel(), keys, labels);
    }

    @Override
    public AbstractInsnNode clone(Map<LabelNode, LabelNode> labels) {
        LookupSwitchInsnNode clone = new LookupSwitchInsnNode(this.register, LookupSwitchInsnNode.clone(this.dflt, labels), null, LookupSwitchInsnNode.clone(this.labels, labels));
        clone.keys.addAll(this.keys);
        return clone;
    }
}

