/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.tree;

import java.util.Map;
import org.ow2.asmdex.MethodVisitor;
import org.ow2.asmdex.tree.AbstractInsnNode;
import org.ow2.asmdex.tree.LabelNode;

public class ArrayOperationInsnNode
extends AbstractInsnNode {
    public int valueRegister;
    public int arrayRegister;
    public int indexRegister;

    public ArrayOperationInsnNode(int opcode, int valueRegister, int arrayRegister, int indexRegister) {
        super(opcode);
        this.valueRegister = valueRegister;
        this.arrayRegister = arrayRegister;
        this.indexRegister = indexRegister;
    }

    public void setOpcode(int opcode) {
        this.opcode = opcode;
    }

    @Override
    public int getType() {
        return 15;
    }

    @Override
    public void accept(MethodVisitor mv) {
        mv.visitArrayOperationInsn(this.opcode, this.valueRegister, this.arrayRegister, this.indexRegister);
    }

    @Override
    public AbstractInsnNode clone(Map<LabelNode, LabelNode> labels) {
        return new ArrayOperationInsnNode(this.opcode, this.valueRegister, this.arrayRegister, this.indexRegister);
    }
}

