/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.tree;

import java.util.ArrayList;
import java.util.List;
import org.ow2.asmdex.AnnotationVisitor;
import org.ow2.asmdex.ApplicationVisitor;
import org.ow2.asmdex.ClassVisitor;
import org.ow2.asmdex.tree.AnnotationNode;
import org.ow2.asmdex.tree.ClassNode;

public class ApplicationNode
extends ApplicationVisitor {
    public List<ClassNode> classes = new ArrayList<ClassNode>();
    public List<AnnotationNode> visibleAnnotations;
    public List<AnnotationNode> invisibleAnnotations;

    public ApplicationNode(int api) {
        super(api);
    }

    @Override
    public void visit() {
    }

    @Override
    public ClassVisitor visitClass(int access, String name, String[] signature, String superName, String[] interfaces) {
        ClassNode cn = new ClassNode(access, name, signature, superName, interfaces);
        this.classes.add(cn);
        return cn;
    }

    public void accept(ApplicationVisitor av) {
        av.visit();
        for (ClassNode n : this.classes) {
            ClassVisitor cv = av.visitClass(n.access, n.name, ApplicationNode.getStringArray(n.signature), n.superName, ApplicationNode.getStringArray(n.interfaces));
            n.accept(cv);
        }
        av.visitEnd();
    }

    public static String[] getStringArray(List<String> list) {
        String[] array = null;
        if (list != null) {
            int size = list.size();
            array = new String[size];
            int i = 0;
            while (i < size) {
                array[i] = list.get(i);
                ++i;
            }
        }
        return array;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationNode an = new AnnotationNode(desc);
        if (visible) {
            if (this.visibleAnnotations == null) {
                this.visibleAnnotations = new ArrayList<AnnotationNode>(1);
            }
            this.visibleAnnotations.add(an);
        } else {
            if (this.invisibleAnnotations == null) {
                this.invisibleAnnotations = new ArrayList<AnnotationNode>(1);
            }
            this.invisibleAnnotations.add(an);
        }
        return an;
    }
}

