/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.structureWriter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.ow2.asmdex.instruction.Instruction;
import org.ow2.asmdex.lowLevelUtils.ByteVector;
import org.ow2.asmdex.lowLevelUtils.DalvikValueReader;
import org.ow2.asmdex.structureCommon.Label;
import org.ow2.asmdex.structureCommon.LocalVariable;
import org.ow2.asmdex.structureWriter.ConstantPool;
import org.ow2.asmdex.structureWriter.DebugInfoItem;
import org.ow2.asmdex.structureWriter.EncodedCatchHandler;
import org.ow2.asmdex.structureWriter.ExceptionHandler;
import org.ow2.asmdex.structureWriter.Method;
import org.ow2.asmdex.structureWriter.TryCatch;

public class CodeItem {
    private ByteVector codeItemCode;
    private ByteVector codeItemTryCatch;
    public static final int TRIES_SIZE_FIELD_OFFSET = 6;
    private static final int TRY_ITEM_STRUCTURE_SIZE = 8;
    private static final int DEBUG_INFO_OFFSET_OFFSET = 8;
    private static final int HANDLER_OFFSET_IN_TRY_ITEM_STRUCTURE = 6;
    public static final int HEADER_SIZE = 16;
    public static final int INSNS_SIZE_OFFSET = 12;
    private int offset;
    private int size = 0;
    private List<Label> labels = new ArrayList<Label>();
    private int incomingArgumentsSizeInWord = 0;
    private int outgoingArgumentsSizeInWord = 0;
    private int registerSize = 0;
    private int firstLineNumber = 0;
    private ArrayList<TryCatch> tryCatches = new ArrayList();
    private ArrayList<Instruction> instructions = new ArrayList();
    private Method method;
    private DebugInfoItem debugInfoItem;
    private final ConstantPool constantPool;
    private HashSet<EncodedCatchHandler> encodedCatchHandlers = new HashSet();
    private HashMap<TryCatch, EncodedCatchHandler> tryCatchToEncodedCatchHandler = new HashMap();
    private HashMap<EncodedCatchHandler, Integer> encodedCatchHandlerToRelativeOffset = new HashMap();
    private static final byte INDEX_STRING = 1;
    private static final byte INDEX_FIELD = 2;
    private static final byte INDEX_TYPE = 3;
    private static final byte INDEX_METHOD = 4;
    private static final byte[] typeOfIndexInInstructions;

    static {
        byte[] byArray = new byte[256];
        byArray[26] = 1;
        byArray[27] = 1;
        byArray[28] = 3;
        byArray[31] = 3;
        byArray[32] = 3;
        byArray[34] = 3;
        byArray[35] = 3;
        byArray[36] = 3;
        byArray[37] = 3;
        byArray[82] = 2;
        byArray[83] = 2;
        byArray[84] = 2;
        byArray[85] = 2;
        byArray[86] = 2;
        byArray[87] = 2;
        byArray[88] = 2;
        byArray[89] = 2;
        byArray[90] = 2;
        byArray[91] = 2;
        byArray[92] = 2;
        byArray[93] = 2;
        byArray[94] = 2;
        byArray[95] = 2;
        byArray[96] = 2;
        byArray[97] = 2;
        byArray[98] = 2;
        byArray[99] = 2;
        byArray[100] = 2;
        byArray[101] = 2;
        byArray[102] = 2;
        byArray[103] = 2;
        byArray[104] = 2;
        byArray[105] = 2;
        byArray[106] = 2;
        byArray[107] = 2;
        byArray[108] = 2;
        byArray[109] = 2;
        byArray[110] = 4;
        byArray[111] = 4;
        byArray[112] = 4;
        byArray[113] = 4;
        byArray[114] = 4;
        byArray[116] = 4;
        byArray[117] = 4;
        byArray[118] = 4;
        byArray[119] = 4;
        byArray[120] = 4;
        typeOfIndexInInstructions = byArray;
    }

    public CodeItem(Method method, ConstantPool constantPool) {
        this.method = method;
        this.constantPool = constantPool;
        this.debugInfoItem = new DebugInfoItem(constantPool);
    }

    public void free() {
        this.labels = null;
        this.instructions = null;
        this.encodedCatchHandlers = null;
        this.tryCatchToEncodedCatchHandler = null;
        this.encodedCatchHandlerToRelativeOffset = null;
        this.debugInfoItem.free();
    }

    public void addLabel(Label label) {
        if (label != null && label.isResolved()) {
            boolean found = false;
            Iterator<Label> it = this.labels.iterator();
            while (!found && it.hasNext()) {
                boolean bl = found = it.next() == label;
            }
            if (!found) {
                this.labels.add(label);
            }
        }
    }

    public void addInstruction(Instruction instruction) {
        this.instructions.add(instruction);
        this.size += instruction.getSize();
    }

    public void addTryCatch(TryCatch tryCatch) {
        TryCatch foundTc = null;
        Iterator<TryCatch> iterator = this.tryCatches.iterator();
        while (foundTc == null && iterator.hasNext()) {
            TryCatch tc = iterator.next();
            if (tc.getStart() != tryCatch.getStart()) continue;
            foundTc = tc;
        }
        if (foundTc != null) {
            foundTc.addExceptionHandlers(tryCatch.getExceptionHandlers());
        } else {
            this.tryCatches.add(tryCatch);
        }
    }

    public void generateCodeItemCode() {
        boolean mustEncodeMethod;
        this.codeItemCode = new ByteVector();
        List<LocalVariable> localVariables = this.method.getLocalVariables();
        boolean bl = mustEncodeMethod = this.instructions != null && this.instructions.size() > 0;
        if (mustEncodeMethod) {
            this.debugInfoItem.initializeDebugInfoItem(this.method.getParameters(), this, localVariables);
        }
        this.codeItemCode.putShort(this.getRegistersSize());
        this.codeItemCode.putShort(this.incomingArgumentsSizeInWord);
        this.codeItemCode.putShort(this.outgoingArgumentsSizeInWord);
        this.codeItemCode.putShort(this.getTriesSize());
        this.codeItemCode.putInt(0);
        int sizeWord = this.size / 2;
        this.codeItemCode.putInt(sizeWord);
        int offsetByteCode = this.codeItemCode.getLength();
        if (mustEncodeMethod) {
            for (Instruction instruction : this.instructions) {
                this.debugInfoItem.parseDebugInformation(instruction, this.codeItemCode.getLength() - offsetByteCode);
                instruction.write(this.codeItemCode, this.constantPool);
            }
            if (this.getTriesSize() != 0 && sizeWord % 2 != 0) {
                this.codeItemCode.putShort(0);
            }
            this.writeTryCatches(this.constantPool);
            this.debugInfoItem.closeDebugInfoItem();
        }
    }

    public void replaceInstructions(Instruction oldInsn, Instruction newInsn) {
        int indexInsnToReplace = this.instructions.indexOf(oldInsn);
        if (indexInsnToReplace >= 0) {
            this.instructions.remove(indexInsnToReplace);
            this.instructions.add(indexInsnToReplace, newInsn);
            this.size += newInsn.getSize() - oldInsn.getSize();
        }
    }

    public ByteVector mapResolvedIndexesForDebug(ByteVector in, int offsetInputBuffer) {
        return this.debugInfoItem.mapResolvedIndexes(in, offsetInputBuffer);
    }

    public void mapResolvedIndexes() {
        this.mapResolvedIndexesByteCode(this.codeItemCode, 0);
        this.codeItemTryCatch = this.mapResolvedIndexesTryCatch(this.codeItemTryCatch, 0, this.getTriesSize());
    }

    public void mapResolvedIndexesByteCode(ByteVector out, int offsetByteCode) {
        DalvikValueReader reader = new DalvikValueReader(out.getBuffer());
        reader.seek(12 + offsetByteCode);
        int insnsSizeInBytes = reader.uint() * 2;
        int endPos = insnsSizeInBytes + reader.getPos();
        byte indexFoundType = 0;
        while (reader.getPos() < endPos) {
            int savedReaderOffset;
            short opcode = reader.ubyte();
            short secondByte = reader.ubyte();
            int indexSize = 2;
            if (opcode == 0) {
                int bytesToSkip = 0;
                switch (secondByte) {
                    case 1: {
                        int size = reader.ushort();
                        reader.skipInt();
                        bytesToSkip = size * 4;
                        break;
                    }
                    case 2: {
                        int size = reader.ushort();
                        bytesToSkip = size * 4 * 2;
                        break;
                    }
                    case 3: {
                        int width = reader.ushort();
                        int size = reader.uint();
                        bytesToSkip = (size * width + 1) / 2 * 2;
                    }
                }
                if (bytesToSkip <= 0) continue;
                reader.relativeSeek(bytesToSkip);
                continue;
            }
            indexFoundType = typeOfIndexInInstructions[opcode];
            if (opcode == 27) {
                indexSize = 4;
            }
            if (indexFoundType == 0) {
                int instructionSize = Instruction.getInstructionSizeInByte(opcode) - 2;
                if (instructionSize <= 0) continue;
                reader.relativeSeek(instructionSize);
                continue;
            }
            int indexOffset = savedReaderOffset = reader.getPos();
            reader.seek(indexOffset);
            int symbolicIndex = indexSize == 2 ? reader.ushort() : reader.ushort() + (reader.ushort() << 16);
            int resolvedIndex = -1;
            switch (indexFoundType) {
                case 1: {
                    resolvedIndex = this.constantPool.getResolvedStringIndexFromSymbolicStringIndex(symbolicIndex);
                    break;
                }
                case 2: {
                    resolvedIndex = this.constantPool.getResolvedFieldIndexFromSymbolicFieldIndex(symbolicIndex);
                    break;
                }
                case 3: {
                    resolvedIndex = this.constantPool.getResolvedTypeIndexFromSymbolicTypeIndex(symbolicIndex);
                    break;
                }
                case 4: {
                    resolvedIndex = this.constantPool.getResolvedMethodIndexFromSymbolicMethodIndex(symbolicIndex);
                    break;
                }
                default: {
                    try {
                        throw new Exception("Unknown Index type.");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (indexSize == 2) {
                out.putShort(resolvedIndex, indexOffset);
            } else {
                out.putShort(resolvedIndex & 0xFFFF, indexOffset);
                out.putShort(resolvedIndex >> 16 & 0xFFFF, indexOffset + 2);
            }
            int instructionSize = Instruction.getInstructionSizeInByte(opcode) - 2;
            if (instructionSize <= 0) continue;
            reader.seek(savedReaderOffset + instructionSize);
        }
    }

    public ByteVector mapResolvedIndexesTryCatch(ByteVector in, int offsetInInputArray, int nbTries) {
        ByteVector out = new ByteVector();
        if (nbTries == 0) {
            return out;
        }
        DalvikValueReader reader = new DalvikValueReader(in.getBuffer());
        reader.seek(offsetInInputArray);
        int i = 0;
        while (i < nbTries) {
            out.putInt(reader.uint());
            out.putShort(reader.ushort());
            out.putShort(reader.ushort());
            ++i;
        }
        int absoluteOldPos = reader.getPos();
        int absoluteNewPos = out.getLength();
        HashMap<Integer, Integer> oldToNewHandlerOffsets = new HashMap<Integer, Integer>();
        int nbEncodedCatchHandler = reader.uleb128();
        out.putUleb128(nbEncodedCatchHandler);
        int i2 = 0;
        while (i2 < nbEncodedCatchHandler) {
            int readSize;
            int newOffset;
            int oldOffset = reader.getPos() - absoluteOldPos;
            if (oldOffset != (newOffset = out.getLength() - absoluteNewPos)) {
                oldToNewHandlerOffsets.put(oldOffset, newOffset);
            }
            int size = (readSize = reader.sleb128()) >= 0 ? readSize : -readSize;
            out.putSleb128(readSize);
            int j = 0;
            while (j < size) {
                int symbolicIndex = reader.uleb128();
                int resolvedIndex = this.constantPool.getResolvedTypeIndexFromSymbolicTypeIndex(symbolicIndex);
                out.putUleb128(resolvedIndex);
                out.putUleb128(reader.uleb128());
                ++j;
            }
            if (readSize <= 0) {
                out.putUleb128(reader.uleb128());
            }
            ++i2;
        }
        if (oldToNewHandlerOffsets.size() != 0) {
            int offset = 6;
            int i3 = 0;
            while (i3 < nbTries) {
                reader.seek(offsetInInputArray + offset);
                int oldHandlerOffset = reader.ushort();
                Integer newHandlerOffset = (Integer)oldToNewHandlerOffsets.get(oldHandlerOffset);
                if (newHandlerOffset != null) {
                    out.putShort(newHandlerOffset, offset);
                }
                offset += 8;
                ++i3;
            }
        }
        return out;
    }

    public int getSize() {
        return this.size;
    }

    public int getTriesSize() {
        return this.tryCatches.size();
    }

    public void setRegisterSize(int registerSize) {
        this.registerSize = registerSize;
    }

    public int getRegistersSize() {
        return this.registerSize;
    }

    public List<Label> getLabels() {
        return this.labels;
    }

    public int getIncomingArgumentsSizeInWord() {
        return this.incomingArgumentsSizeInWord;
    }

    public void setIncomingArgumentsSizeInWord(int incomingArgumentsSizeInWord) {
        this.incomingArgumentsSizeInWord = incomingArgumentsSizeInWord;
    }

    public int getOutgoingArgumentsSizeInWord() {
        return this.outgoingArgumentsSizeInWord;
    }

    public void setOutgoingArgumentsSizeInWord(int outgoingArgumentsSizeInWord) {
        this.outgoingArgumentsSizeInWord = outgoingArgumentsSizeInWord;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public void setDebugInfoItemOffset(ByteVector out, int debugInfoItemOffset) {
        out.putInt(debugInfoItemOffset, this.offset + 8);
    }

    public void setFirstLineNumber(int firstLineNumber) {
        if (this.firstLineNumber == 0) {
            this.firstLineNumber = firstLineNumber;
        }
    }

    public int getFirstLineNumber() {
        return this.firstLineNumber;
    }

    public ByteVector getCodeItemCode() {
        if (this.codeItemCode == null) {
            this.generateCodeItemCode();
        }
        return this.codeItemCode;
    }

    public ByteVector getCodeItemTryCatch() {
        if (this.codeItemCode == null) {
            this.generateCodeItemCode();
        }
        return this.codeItemTryCatch;
    }

    public ByteVector getDebugInfoItemCode() {
        return this.debugInfoItem.getDebugInfoItemCode();
    }

    public boolean areSymbolicIndexesUsedInDebugCodeItem() {
        return this.debugInfoItem.areSymbolicIndexesUsed();
    }

    private void writeTryCatches(ConstantPool constantPool) {
        if (this.getTriesSize() == 0) {
            return;
        }
        this.codeItemTryCatch = new ByteVector();
        for (TryCatch tc : this.tryCatches) {
            int startAddr = tc.getStart().getOffset();
            int endAddr = tc.getEnd().getOffset();
            this.codeItemTryCatch.putInt(startAddr / 2);
            this.codeItemTryCatch.putShort((endAddr - startAddr) / 2);
            this.codeItemTryCatch.putShort(0);
            EncodedCatchHandler ech = new EncodedCatchHandler(constantPool);
            for (ExceptionHandler eh : tc.getExceptionHandlers()) {
                ech.addTypeAddrPair(eh.getType(), eh.getHandler());
            }
            this.encodedCatchHandlers.add(ech);
            this.tryCatchToEncodedCatchHandler.put(tc, ech);
        }
        int absoluteOffsetEncodedCatchHandlerList = this.codeItemTryCatch.getLength();
        this.codeItemTryCatch.putUleb128(this.encodedCatchHandlers.size());
        for (EncodedCatchHandler ech : this.encodedCatchHandlers) {
            int offsetEncodedCatchHandlerCurrentItem = this.codeItemTryCatch.getLength() - absoluteOffsetEncodedCatchHandlerList;
            this.encodedCatchHandlerToRelativeOffset.put(ech, offsetEncodedCatchHandlerCurrentItem);
            ech.write(this.codeItemTryCatch);
        }
        int offset = 6;
        for (TryCatch tc : this.tryCatches) {
            this.codeItemTryCatch.putShort(this.encodedCatchHandlerToRelativeOffset.get(this.tryCatchToEncodedCatchHandler.get(tc)), offset);
            offset += 8;
        }
    }
}

