/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.structureWriter;

import java.util.ArrayList;
import java.util.List;
import org.ow2.asmdex.encodedValue.EncodedValue;
import org.ow2.asmdex.encodedValue.EncodedValueArray;
import org.ow2.asmdex.encodedValue.EncodedValueFactory;
import org.ow2.asmdex.structureWriter.AnnotationDirectoryItem;
import org.ow2.asmdex.structureWriter.AnnotationItem;
import org.ow2.asmdex.structureWriter.AnnotationSetItem;
import org.ow2.asmdex.structureWriter.ConstantPool;
import org.ow2.asmdex.structureWriter.Field;
import org.ow2.asmdex.structureWriter.IAnnotationsHolder;
import org.ow2.asmdex.structureWriter.Method;
import org.ow2.asmdex.structureWriter.TypeList;

public class ClassDefinitionItem
implements Comparable<ClassDefinitionItem>,
IAnnotationsHolder {
    private final String className;
    private final int accessFlags;
    private final String superClassName;
    private final TypeList interfaceNames;
    private final ConstantPool constantPool;
    private String sourceFileName;
    private final String[] signature;
    private final int hashCode;
    private AnnotationSetItem annotationSetItem = new AnnotationSetItem();
    private ArrayList<Field> staticFields = new ArrayList();
    private ArrayList<Field> instanceFields = new ArrayList();
    private ArrayList<Method> directMethods = new ArrayList();
    private ArrayList<Method> virtualMethods = new ArrayList();
    private EncodedValueArray memberClassArray;
    private AnnotationDirectoryItem annotationDirectoryItem;
    private List<AnnotationItem> annotationItemsForDefaultAnnotation;
    public static final int ACCESS_FLAGS_OFFSET = 4;
    public static final int SUPERCLASS_IDX_OFFSET = 8;
    public static final int INTERFACES_OFFSET = 12;
    public static final int SOURCE_FILE_IDX_OFFSET = 16;
    public static final int ANNOTATIONS_OFF_OFFSET = 20;
    public static final int CLASS_DATA_OFF_OFFSET = 24;

    public ClassDefinitionItem(String className, String superClassName, int accessFlags, TypeList interfaceNames, String[] signature, ConstantPool constantPool) {
        this.className = className;
        this.accessFlags = accessFlags;
        this.superClassName = superClassName;
        this.interfaceNames = interfaceNames;
        this.signature = signature;
        this.constantPool = constantPool;
        this.hashCode = className.hashCode();
    }

    public String getClassName() {
        return this.className;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public TypeList getInterfaces() {
        return this.interfaceNames;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public void setSourceFileName(String sourceFileName) {
        this.sourceFileName = sourceFileName;
    }

    public String[] getSignature() {
        return this.signature;
    }

    public ArrayList<Method> getDirectMethods() {
        return this.directMethods;
    }

    public ArrayList<Method> getVirtualMethods() {
        return this.virtualMethods;
    }

    public ArrayList<Field> getStaticFields() {
        return this.staticFields;
    }

    public ArrayList<Field> getInstanceFields() {
        return this.instanceFields;
    }

    public int getNbDirectMethods() {
        return this.directMethods.size();
    }

    public int getNbVirtualMethods() {
        return this.virtualMethods.size();
    }

    public int getNbStaticFields() {
        return this.staticFields.size();
    }

    public int getNbInstanceFields() {
        return this.instanceFields.size();
    }

    @Override
    public AnnotationSetItem getAnnotationSetItem() {
        return this.annotationSetItem;
    }

    @Override
    public int getNbAnnotations() {
        return this.annotationSetItem.getNbAnnotationItems();
    }

    public int getNbAnnotatedMethods() {
        return this.annotationDirectoryItem == null ? 0 : this.annotationDirectoryItem.getNbAnnotatedMethods();
    }

    public int getNbMethodWithAnnotatedParameters() {
        return this.annotationDirectoryItem == null ? 0 : this.annotationDirectoryItem.getNbAnnotatedParameters();
    }

    public int getNbAnnotatedFields() {
        return this.annotationDirectoryItem == null ? 0 : this.annotationDirectoryItem.getNbAnnotatedFields();
    }

    public EncodedValueArray getMemberClassArray() {
        return this.memberClassArray;
    }

    public AnnotationDirectoryItem getAnnotationDirectoryItem() {
        return this.annotationDirectoryItem;
    }

    public List<AnnotationItem> getAnnotationItemsForDefaultAnnotation() {
        return this.annotationItemsForDefaultAnnotation;
    }

    public boolean isInterface() {
        return (this.accessFlags & 0x200) != 0;
    }

    public void addMethod(Method method) {
        if (method.isVirtual()) {
            this.virtualMethods.add(method);
        } else {
            this.directMethods.add(method);
        }
    }

    public void addField(Field field) {
        if (field.isStatic()) {
            this.staticFields.add(field);
        } else {
            this.instanceFields.add(field);
        }
    }

    public void addAnnotationItem(AnnotationItem annotationItem) {
        this.annotationSetItem.addAnnotationItem(annotationItem);
    }

    public void addMemberClassValue(String memberClassType, ConstantPool constantPool) {
        if (this.memberClassArray == null) {
            this.memberClassArray = new EncodedValueArray();
        }
        constantPool.addTypeToConstantPool(memberClassType);
        EncodedValue encodedValue = EncodedValueFactory.getEncodedValue((Object)memberClassType, 24);
        this.memberClassArray.addEncodedValue(encodedValue);
    }

    public void addAnnotationItemForDefaultAnnotation(AnnotationItem annotationItem) {
        if (this.annotationItemsForDefaultAnnotation == null) {
            this.annotationItemsForDefaultAnnotation = new ArrayList<AnnotationItem>(1);
        }
        this.annotationItemsForDefaultAnnotation.add(annotationItem);
    }

    public void buildAnnotationDirectoryItem() {
        AnnotationDirectoryItem adi = new AnnotationDirectoryItem();
        adi.setClassAnnotationSetItem(this.annotationSetItem);
        boolean foundAnnotation = this.annotationSetItem.getNbAnnotationItems() > 0;
        foundAnnotation |= this.buildAnnotationDirectoryItemForMethods(this.directMethods, adi);
        foundAnnotation |= this.buildAnnotationDirectoryItemForMethods(this.virtualMethods, adi);
        for (Field field : this.staticFields) {
            if (field.getNbAnnotations() <= 0) continue;
            adi.addAnnotatedField(field);
            foundAnnotation = true;
        }
        for (Field field : this.instanceFields) {
            if (field.getNbAnnotations() <= 0) continue;
            adi.addAnnotatedField(field);
            foundAnnotation = true;
        }
        if (foundAnnotation) {
            this.annotationDirectoryItem = adi;
            this.constantPool.addAnnotationDirectoryItem(this.annotationDirectoryItem);
        }
    }

    private boolean buildAnnotationDirectoryItemForMethods(List<Method> methods, AnnotationDirectoryItem adi) {
        boolean foundAnnotation = false;
        for (Method method : methods) {
            if (method.getNbAnnotations() > 0) {
                adi.addAnnotatedMethods(method);
                foundAnnotation = true;
            }
            if (method.getNbParameterAnnotations() <= 0) continue;
            adi.addAnnotatedParameter(method.getAnnotatedParameterSetRefList());
            foundAnnotation = true;
        }
        return foundAnnotation;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ClassDefinitionItem) {
            ClassDefinitionItem cdi = (ClassDefinitionItem)obj;
            return this.className.equals(cdi.className);
        }
        return false;
    }

    @Override
    public int compareTo(ClassDefinitionItem cdi) {
        if (this == cdi) {
            return 0;
        }
        return this.className.compareTo(cdi.className);
    }
}

