/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.structureWriter;

import java.util.Arrays;
import java.util.PriorityQueue;
import org.ow2.asmdex.structureWriter.AnnotationElement;

public class AnnotationItem
implements Comparable<AnnotationItem> {
    private final int visibility;
    private final String annotationType;
    private PriorityQueue<AnnotationElement> annotationElements = new PriorityQueue();
    private boolean isListDirty = true;
    private AnnotationElement[] annotationElementsArray;
    private int hashcode = -1;

    public AnnotationItem(int visibility, String annotationType) {
        this.visibility = visibility;
        this.annotationType = annotationType;
    }

    public AnnotationItem(boolean visible, String annotationType) {
        this(visible ? 1 : 0, annotationType);
    }

    public void addAnnotationElement(AnnotationElement annotationElement) {
        this.annotationElements.add(annotationElement);
        this.hashcode = -1;
        this.isListDirty = true;
    }

    public int getVisibility() {
        return this.visibility;
    }

    public String getAnnotationType() {
        return this.annotationType;
    }

    public PriorityQueue<AnnotationElement> getAnnotationElements() {
        return this.annotationElements;
    }

    public int getNbAnnotationElements() {
        return this.annotationElements.size();
    }

    private AnnotationElement[] getAnnotationElementsArray() {
        if (!this.isListDirty) {
            return this.annotationElementsArray;
        }
        Object[] array = this.annotationElements.toArray();
        Arrays.sort(array);
        int size = array.length;
        this.annotationElementsArray = new AnnotationElement[size];
        int i = 0;
        while (i < size) {
            this.annotationElementsArray[i] = (AnnotationElement)array[i];
            ++i;
        }
        return this.annotationElementsArray;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        boolean result = false;
        if (o instanceof AnnotationItem) {
            int size;
            AnnotationItem annotationItem = (AnnotationItem)o;
            boolean bl = result = this.visibility == annotationItem.visibility && this.annotationType.equals(annotationItem.annotationType);
            if (result && (size = this.annotationElements.size()) == annotationItem.annotationElements.size()) {
                for (AnnotationElement element : this.annotationElements) {
                    result = annotationItem.annotationElements.contains(element);
                    if (!result) break;
                }
            }
        }
        return result;
    }

    public int hashCode() {
        if (this.hashcode != -1) {
            return this.hashcode;
        }
        int res = this.visibility + this.annotationType.hashCode();
        for (AnnotationElement element : this.annotationElements) {
            res += element.hashCode();
        }
        this.hashcode = res;
        return res;
    }

    @Override
    public int compareTo(AnnotationItem ai) {
        if (this == ai) {
            return 0;
        }
        int result = this.annotationType.compareTo(ai.annotationType);
        if (result == 0) {
            AnnotationElement[] ae1 = this.getAnnotationElementsArray();
            AnnotationElement[] ae2 = ai.getAnnotationElementsArray();
            int size1 = ae1.length;
            int size2 = ae2.length;
            int i = 0;
            int size = size1 < size2 ? size1 : size2;
            while (result == 0 && i < size) {
                result = ae1[i].compareTo(ae2[i]);
                ++i;
            }
            if (result == 0) {
                result = size1 == size2 ? 0 : (size1 < size2 ? -1 : 1);
            }
        }
        return result;
    }
}

