/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.lowLevelUtils;

import org.ow2.asmdex.instruction.DebugInstruction;
import org.ow2.asmdex.instruction.DebugInstructionStartLocal;
import org.ow2.asmdex.instruction.DebugInstructionStartLocalExtended;
import org.ow2.asmdex.instruction.Instruction;
import org.ow2.asmdex.instruction.InstructionFormat10T;
import org.ow2.asmdex.instruction.InstructionFormat10X;
import org.ow2.asmdex.instruction.InstructionFormat11N;
import org.ow2.asmdex.instruction.InstructionFormat11X;
import org.ow2.asmdex.instruction.InstructionFormat12X;
import org.ow2.asmdex.instruction.InstructionFormat20T;
import org.ow2.asmdex.instruction.InstructionFormat21C;
import org.ow2.asmdex.instruction.InstructionFormat21H;
import org.ow2.asmdex.instruction.InstructionFormat21S;
import org.ow2.asmdex.instruction.InstructionFormat21T;
import org.ow2.asmdex.instruction.InstructionFormat22B;
import org.ow2.asmdex.instruction.InstructionFormat22C;
import org.ow2.asmdex.instruction.InstructionFormat22S;
import org.ow2.asmdex.instruction.InstructionFormat22T;
import org.ow2.asmdex.instruction.InstructionFormat22X;
import org.ow2.asmdex.instruction.InstructionFormat23X;
import org.ow2.asmdex.instruction.InstructionFormat30T;
import org.ow2.asmdex.instruction.InstructionFormat31C;
import org.ow2.asmdex.instruction.InstructionFormat31I;
import org.ow2.asmdex.instruction.InstructionFormat31T;
import org.ow2.asmdex.instruction.InstructionFormat32X;
import org.ow2.asmdex.instruction.InstructionFormat35C;
import org.ow2.asmdex.instruction.InstructionFormat3RC;
import org.ow2.asmdex.instruction.InstructionFormat51L;
import org.ow2.asmdex.structureCommon.Label;
import org.ow2.asmdex.structureWriter.Field;
import org.ow2.asmdex.structureWriter.Method;

public class InstructionEncoder {
    private static final int MIN_VALUE_4BITS_SIGNED = -8;
    private static final int MAX_VALUE_4BITS_SIGNED = 7;
    private static final int MAX_VALUE_4BITS_UNSIGNED = 15;
    private static final int MAX_VALUE_8BITS_UNSIGNED = 255;
    private static final int MIN_VALUE_16BITS_SIGNED = Short.MIN_VALUE;
    private static final int MAX_VALUE_16BITS_SIGNED = Short.MAX_VALUE;

    public static Instruction encodeMethodInsn(int opcode, Method method, int[] arguments) {
        if (opcode < 116) {
            return new InstructionFormat35C(opcode, method, arguments);
        }
        return new InstructionFormat3RC(opcode, method, arguments);
    }

    public static Instruction encodeVarInsn(int opcode, int destinationRegister, int var) {
        Instruction insn = null;
        switch (opcode) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                insn = InstructionEncoder.createBest12X22X32XInstruction(opcode, destinationRegister, var);
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                if (destinationRegister <= 15 && var <= 7 && var >= -8) {
                    insn = new InstructionFormat11N(18, destinationRegister, var);
                    break;
                }
                if (destinationRegister <= 255 && var <= Short.MAX_VALUE && var >= Short.MIN_VALUE) {
                    insn = new InstructionFormat21S(19, destinationRegister, var);
                    break;
                }
                insn = (var & 0xFFFF) == 0 ? new InstructionFormat21H(21, destinationRegister, var >> 16) : new InstructionFormat31I(20, destinationRegister, var);
                break;
            }
            case 22: 
            case 23: {
                if (var <= Short.MAX_VALUE && var >= Short.MIN_VALUE) {
                    insn = new InstructionFormat21S(22, destinationRegister, var);
                    break;
                }
                insn = new InstructionFormat31I(23, destinationRegister, var);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected opcode : 0x" + Integer.toHexString(opcode));
            }
        }
        return insn;
    }

    public static Instruction encodeVarInsn(int opcode, int destinationRegister, long var) {
        Instruction insn = null;
        switch (opcode) {
            case 24: 
            case 25: {
                insn = (var & 0xFFFFFFFFFFFFL) == 0L ? new InstructionFormat21H(25, destinationRegister, (int)(var >> 48)) : new InstructionFormat51L(24, destinationRegister, var);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected opcode : 0x" + Integer.toHexString(opcode));
            }
        }
        return insn;
    }

    private static Instruction createBest12X22X32XInstruction(int opcode, int destinationRegister, int sourceRegister) {
        if (opcode >= 7) {
            opcode = 7;
        } else if (opcode >= 4) {
            opcode = 4;
        } else if (opcode >= 1) {
            opcode = 1;
        }
        Instruction insn = destinationRegister <= 15 && sourceRegister <= 15 ? new InstructionFormat12X(opcode, destinationRegister, sourceRegister) : (destinationRegister <= 255 ? new InstructionFormat22X(opcode + 1, destinationRegister, sourceRegister) : new InstructionFormat32X(opcode + 2, destinationRegister, sourceRegister));
        return insn;
    }

    public static Instruction encodeInsn(int opcode) {
        return new InstructionFormat10X(opcode);
    }

    public static Instruction encodeOperationInsn(int opcode, int destinationRegister, int firstSourceRegister, int secondSourceRegister, int value) {
        Instruction insn = null;
        if (opcode >= 144 && opcode <= 175) {
            insn = new InstructionFormat23X(opcode, destinationRegister, firstSourceRegister, secondSourceRegister);
        } else if (opcode >= 45 && opcode <= 49) {
            insn = new InstructionFormat23X(opcode, destinationRegister, firstSourceRegister, secondSourceRegister);
        } else if (opcode >= 123 && opcode <= 143) {
            insn = new InstructionFormat12X(opcode, destinationRegister, firstSourceRegister);
        } else if (opcode >= 144 && opcode <= 175) {
            insn = new InstructionFormat23X(opcode, destinationRegister, firstSourceRegister, secondSourceRegister);
        } else if (opcode >= 176 && opcode <= 207) {
            insn = new InstructionFormat12X(opcode, destinationRegister, secondSourceRegister);
        } else if (opcode >= 208 && opcode <= 215) {
            insn = new InstructionFormat22S(opcode, destinationRegister, firstSourceRegister, value);
        } else if (opcode >= 216 && opcode <= 226) {
            insn = new InstructionFormat22B(opcode, destinationRegister, firstSourceRegister, value);
        } else {
            throw new RuntimeException("Unexpected opcode : 0x" + Integer.toHexString(opcode));
        }
        return insn;
    }

    public static Instruction encodeIntInsn(int opcode, int operand) {
        return new InstructionFormat11X(opcode, operand);
    }

    public static Instruction encodeJumpInsn(int opcode, Label label, int registerA, int registerB, int instructionOffset) {
        Instruction insn = null;
        if (opcode == 40) {
            insn = new InstructionFormat10T(opcode, label, instructionOffset);
        } else if (opcode == 41) {
            insn = new InstructionFormat20T(opcode, label, instructionOffset);
        } else if (opcode == 42) {
            insn = new InstructionFormat30T(opcode, label, instructionOffset);
        } else if (opcode >= 50 && opcode <= 55) {
            insn = new InstructionFormat22T(opcode, label, registerA, registerB, instructionOffset);
        } else if (opcode >= 56 && opcode <= 61) {
            insn = new InstructionFormat21T(opcode, label, registerA, instructionOffset);
        } else {
            throw new RuntimeException("Unexpected opcode : 0x" + Integer.toHexString(opcode));
        }
        return insn;
    }

    public static Instruction encodeFillArrayDataInsn(int opcode, int arrayReference, Label arrayLabel, int instructionOffset) {
        return new InstructionFormat31T(opcode, arrayLabel, arrayReference, instructionOffset);
    }

    public static Instruction encodeTypeInsn(int opcode, int destinationRegister, int referenceBearingRegister, int sizeRegister, String type) {
        Instruction insn = null;
        if (opcode == 28) {
            insn = new InstructionFormat21C(opcode, type, destinationRegister);
        } else if (opcode == 31) {
            insn = new InstructionFormat21C(opcode, type, referenceBearingRegister);
        } else if (opcode == 32) {
            insn = new InstructionFormat22C(opcode, type, destinationRegister, referenceBearingRegister);
        } else if (opcode == 34) {
            insn = new InstructionFormat21C(opcode, type, destinationRegister);
        } else if (opcode == 35) {
            insn = new InstructionFormat22C(opcode, type, destinationRegister, sizeRegister);
        } else {
            throw new RuntimeException("Unexpected opcode : 0x" + Integer.toHexString(opcode));
        }
        return insn;
    }

    public static Instruction encodeMultiANewArrayInsn(String type, int[] registers) {
        Instruction insn = null;
        insn = registers.length <= 5 ? new InstructionFormat35C(36, type, registers) : new InstructionFormat3RC(37, type, registers);
        return insn;
    }

    public static Instruction encodeTableSwitchInsn(int register, Label switchTableLabel, int instructionOffset) {
        return new InstructionFormat31T(43, switchTableLabel, register, instructionOffset);
    }

    public static Instruction encodeSparseSwitchInsn(int register, Label switchTableLabel, int instructionOffset) {
        return new InstructionFormat31T(44, switchTableLabel, register, instructionOffset);
    }

    public static Instruction encodeArrayLength(int destinationRegister, int arrayReferenceBearing) {
        return new InstructionFormat12X(33, destinationRegister, arrayReferenceBearing);
    }

    public static Instruction encodeArrayOperation(int opcode, int valueRegister, int arrayRegister, int indexRegister) {
        return new InstructionFormat23X(opcode, valueRegister, arrayRegister, indexRegister);
    }

    public static Instruction encodeStringOperation(int opcode, int destinationRegister, String string) {
        Instruction insn = null;
        if (opcode == 26) {
            insn = new InstructionFormat21C(opcode, string, destinationRegister);
        } else if (opcode == 27) {
            insn = new InstructionFormat31C(opcode, string, destinationRegister);
        } else {
            throw new RuntimeException("Unexpected opcode : 0x" + Integer.toHexString(opcode));
        }
        return insn;
    }

    public static Instruction encodeFieldInsn(int opcode, int valueRegister, int objectRegister, Field field) {
        Instruction insn = null;
        if (opcode >= 82 && opcode <= 95) {
            insn = new InstructionFormat22C(opcode, field, valueRegister, objectRegister);
        } else if (opcode >= 96 && opcode <= 109) {
            insn = new InstructionFormat21C(opcode, field, valueRegister);
        }
        return insn;
    }

    public static DebugInstruction encodeDebugStartLocal(String name, String desc, String signature, int index, Label start) {
        DebugInstruction insn = null;
        insn = signature == null ? new DebugInstructionStartLocal(index, name, desc, start) : new DebugInstructionStartLocalExtended(index, name, desc, signature, start);
        return insn;
    }
}

