/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.instruction;

import org.ow2.asmdex.instruction.IOffsetInstruction;
import org.ow2.asmdex.instruction.IOneRegisterInstruction;
import org.ow2.asmdex.instruction.Instruction;
import org.ow2.asmdex.lowLevelUtils.ByteVector;
import org.ow2.asmdex.lowLevelUtils.IDalvikValueReader;
import org.ow2.asmdex.structureCommon.Label;
import org.ow2.asmdex.structureWriter.ConstantPool;

public class InstructionFormat31T
extends Instruction
implements IOneRegisterInstruction,
IOffsetInstruction {
    private static final int INSTRUCTION_SIZE = 6;
    private int registerA;
    private int offsetB;
    private int instructionOffset;
    private Label label;

    @Override
    public int getRegisterA() {
        return this.registerA;
    }

    @Override
    public int getOffset() {
        return this.offsetB;
    }

    @Override
    public Label getLabel() {
        return this.label;
    }

    public static int getRegisterA(int opcode) {
        return opcode >> 8 & 0xFF;
    }

    public static int getOffset(IDalvikValueReader reader, int opcode) {
        int opcodeOffset = reader.getPos() - 2;
        return reader.sint() * 2 + opcodeOffset;
    }

    public static void skip(IDalvikValueReader reader) {
        reader.relativeSeek(4);
    }

    public InstructionFormat31T(int opcode, Label label, int register, int instructionOffset) {
        super(opcode);
        this.instructionOffset = instructionOffset;
        this.label = label;
        this.registerA = register;
    }

    @Override
    public int getSize() {
        return 6;
    }

    @Override
    public int getInstructionOffset() {
        return this.instructionOffset;
    }

    @Override
    public void setInstructionOffset(int instructionOffset) {
        this.instructionOffset = instructionOffset;
    }

    @Override
    public void write(ByteVector out, ConstantPool constantPool) {
        out.putShort(((this.registerA & 0xFF) << 8) + this.opcodeByte);
        int branchOffset = (this.label.getOffset() - this.instructionOffset) / 2;
        out.putShort(branchOffset & 0xFFFF);
        out.putShort(branchOffset >> 16 & 0xFFFF);
    }
}

