/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.instruction;

import org.ow2.asmdex.instruction.ITwoRegistersInstruction;
import org.ow2.asmdex.instruction.Instruction;
import org.ow2.asmdex.lowLevelUtils.ByteVector;
import org.ow2.asmdex.lowLevelUtils.IDalvikValueReader;
import org.ow2.asmdex.structureWriter.ConstantPool;

public class InstructionFormat22X
extends Instruction
implements ITwoRegistersInstruction {
    private static final int INSTRUCTION_SIZE = 4;
    private int registerA;
    private int registerB;

    @Override
    public int getRegisterA() {
        return this.registerA;
    }

    @Override
    public int getRegisterB() {
        return this.registerB;
    }

    public static int getRegisterA(int opcode) {
        return opcode >> 8 & 0xFF;
    }

    public static int getRegisterB(IDalvikValueReader reader) {
        return reader.ushort();
    }

    public static void skip(IDalvikValueReader reader) {
        reader.relativeSeek(2);
    }

    public InstructionFormat22X(int opcode, int destinationRegister, int var) {
        super(opcode);
        this.registerA = destinationRegister;
        this.registerB = var;
    }

    @Override
    public int getSize() {
        return 4;
    }

    @Override
    public void write(ByteVector out, ConstantPool constantPool) {
        int firstShort = ((this.registerA & 0xFF) << 8) + this.opcodeByte;
        out.putShort(firstShort);
        out.putShort(this.registerB & 0xFFFF);
    }
}

