/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.instruction;

import org.ow2.asmdex.instruction.IIndexInstruction;
import org.ow2.asmdex.instruction.IOneRegisterInstruction;
import org.ow2.asmdex.instruction.Instruction;
import org.ow2.asmdex.lowLevelUtils.ByteVector;
import org.ow2.asmdex.lowLevelUtils.IDalvikValueReader;
import org.ow2.asmdex.structureWriter.ConstantPool;
import org.ow2.asmdex.structureWriter.Field;

public class InstructionFormat21C
extends Instruction
implements IOneRegisterInstruction,
IIndexInstruction {
    private static final int INSTRUCTION_SIZE = 4;
    private int registerA;
    private int indexB;
    private String stringOrType;
    private Field field;

    @Override
    public int getRegisterA() {
        return this.registerA;
    }

    @Override
    public int getIndex() {
        return this.indexB;
    }

    public static int getRegisterA(int opcode) {
        return opcode >> 8 & 0xFF;
    }

    public static int getIndexB(IDalvikValueReader reader) {
        return reader.ushort();
    }

    public InstructionFormat21C(int opcode, String stringOrType, int registerA) {
        super(opcode);
        this.registerA = registerA;
        this.stringOrType = stringOrType;
    }

    public InstructionFormat21C(int opcode, Field field, int registerA) {
        super(opcode);
        this.registerA = registerA;
        this.field = field;
    }

    public static void skip(IDalvikValueReader reader) {
        reader.relativeSeek(2);
    }

    @Override
    public int getSize() {
        return 4;
    }

    @Override
    public void write(ByteVector out, ConstantPool constantPool) {
        out.putShort(((this.registerA & 0xFF) << 8) + this.opcodeByte);
        int index = this.opcodeByte == 26 ? constantPool.getStringIndex(this.stringOrType) : (this.opcodeByte == 28 || this.opcodeByte == 31 || this.opcodeByte == 34 ? constantPool.getTypeIndex(this.stringOrType) : constantPool.getFieldIndex(this.field));
        out.putShort(index);
    }
}

