/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.instruction;

import org.ow2.asmdex.instruction.DebugInstruction;
import org.ow2.asmdex.instruction.IDebugLocalVariableStartInstruction;
import org.ow2.asmdex.instruction.IDebugRegisterInstruction;
import org.ow2.asmdex.lowLevelUtils.ByteVector;
import org.ow2.asmdex.structureCommon.Label;
import org.ow2.asmdex.structureWriter.ConstantPool;

public class DebugInstructionStartLocalExtended
extends DebugInstruction
implements IDebugLocalVariableStartInstruction,
IDebugRegisterInstruction {
    protected int register;
    protected String name;
    protected String type;
    protected String signature;
    protected Label start;

    public DebugInstructionStartLocalExtended(int register, String name, String type, String signature, Label start) {
        this.register = register;
        this.name = name;
        this.type = type;
        this.signature = signature;
        this.start = start;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getSignature() {
        return this.signature;
    }

    @Override
    public int getRegister() {
        return this.register;
    }

    @Override
    public int getOpcode() {
        return 4;
    }

    @Override
    public Label getLabel() {
        return this.start;
    }

    @Override
    public void write(ByteVector out, ConstantPool constantPool) {
        out.putByte(4);
        out.putUleb128(this.register);
        out.putUleb128p1(constantPool.getStringIndex(this.name));
        out.putUleb128p1(constantPool.getTypeIndex(this.type));
        out.putUleb128p1(constantPool.getStringIndex(this.signature));
    }
}

