/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.encodedValue;

import org.ow2.asmdex.encodedValue.EncodedValue;
import org.ow2.asmdex.encodedValue.EncodedValueUtil;
import org.ow2.asmdex.structureWriter.ConstantPool;
import org.ow2.asmdex.structureWriter.Method;

public class EncodedValueMethod
extends EncodedValue {
    private int type = 26;
    private Method value;

    public EncodedValueMethod(Method value) {
        this.value = value;
    }

    public EncodedValueMethod(Object value) {
        this.value = (Method)value;
    }

    @Override
    public byte[] encode(ConstantPool constantPool) {
        int index = constantPool.getMethodIndex(this.value);
        return EncodedValueUtil.encodeUnsignedValue(index, this.type);
    }

    @Override
    public int getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        boolean result = false;
        if (o instanceof EncodedValueMethod) {
            EncodedValueMethod encodedValue = (EncodedValueMethod)o;
            result = this.type == encodedValue.type && this.value.equals(encodedValue.value);
        }
        return result;
    }

    public int hashCode() {
        return this.type + this.value.hashCode() * 401577;
    }

    @Override
    int compareValue(EncodedValue encodedValue) {
        if (this == encodedValue) {
            return 0;
        }
        EncodedValueMethod em = (EncodedValueMethod)encodedValue;
        return this.value.compareTo(em.value);
    }
}

