/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.encodedValue;

import org.ow2.asmdex.encodedValue.EncodedValue;
import org.ow2.asmdex.encodedValue.EncodedValueAnnotation;
import org.ow2.asmdex.encodedValue.EncodedValueArray;
import org.ow2.asmdex.encodedValue.EncodedValueBoolean;
import org.ow2.asmdex.encodedValue.EncodedValueByte;
import org.ow2.asmdex.encodedValue.EncodedValueCharacter;
import org.ow2.asmdex.encodedValue.EncodedValueDouble;
import org.ow2.asmdex.encodedValue.EncodedValueEnum;
import org.ow2.asmdex.encodedValue.EncodedValueField;
import org.ow2.asmdex.encodedValue.EncodedValueFloat;
import org.ow2.asmdex.encodedValue.EncodedValueInteger;
import org.ow2.asmdex.encodedValue.EncodedValueLong;
import org.ow2.asmdex.encodedValue.EncodedValueMethod;
import org.ow2.asmdex.encodedValue.EncodedValueNull;
import org.ow2.asmdex.encodedValue.EncodedValueShort;
import org.ow2.asmdex.encodedValue.EncodedValueString;
import org.ow2.asmdex.encodedValue.EncodedValueType;
import org.ow2.asmdex.encodedValue.EncodedValueUtil;

public class EncodedValueFactory {
    public static EncodedValue getEncodedValue(Object value, String desc) {
        int type = EncodedValueUtil.getTypeFromDescriptor(desc);
        return EncodedValueFactory.getEncodedValue(value, type);
    }

    public static EncodedValue getEncodedValue(Object value, int type) {
        EncodedValue encodedValue = null;
        switch (type) {
            case 0: {
                encodedValue = new EncodedValueByte(value);
                break;
            }
            case 2: {
                encodedValue = new EncodedValueShort(value);
                break;
            }
            case 3: {
                encodedValue = new EncodedValueCharacter(value);
                break;
            }
            case 4: {
                encodedValue = new EncodedValueInteger(value);
                break;
            }
            case 6: {
                encodedValue = new EncodedValueLong(value);
                break;
            }
            case 16: {
                encodedValue = new EncodedValueFloat(value);
                break;
            }
            case 17: {
                encodedValue = new EncodedValueDouble(value);
                break;
            }
            case 23: {
                encodedValue = new EncodedValueString(value);
                break;
            }
            case 24: {
                encodedValue = new EncodedValueType(value);
                break;
            }
            case 25: {
                encodedValue = new EncodedValueField(value);
                break;
            }
            case 26: {
                encodedValue = new EncodedValueMethod(value);
                break;
            }
            case 27: {
                encodedValue = new EncodedValueEnum(value);
                break;
            }
            case 28: {
                encodedValue = new EncodedValueArray();
                break;
            }
            case 29: {
                encodedValue = new EncodedValueAnnotation(value);
                break;
            }
            case 30: {
                encodedValue = new EncodedValueNull();
                break;
            }
            case 31: {
                encodedValue = new EncodedValueBoolean(value);
                break;
            }
            default: {
                try {
                    throw new Exception("Unknown type for this value.");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return encodedValue;
    }

    public static EncodedValue getEncodedEmptyValue(String desc) {
        EncodedValue encodedValue = null;
        if (EncodedValueUtil.isTypeAReference(desc)) {
            encodedValue = new EncodedValueNull();
        } else {
            int type = EncodedValueUtil.getTypeFromDescriptor(desc);
            encodedValue = EncodedValueFactory.getEncodedValue((Object)0, type);
        }
        return encodedValue;
    }

    public static EncodedValue getEncodedNullValue() {
        return new EncodedValueNull();
    }

    public static EncodedValue getEncodedValue(Object value) {
        if (value instanceof Integer) {
            return new EncodedValueInteger(value);
        }
        if (value instanceof Boolean) {
            return new EncodedValueBoolean(value);
        }
        if (value instanceof Byte) {
            return new EncodedValueByte(value);
        }
        if (value instanceof Character) {
            return new EncodedValueCharacter(value);
        }
        if (value instanceof Double) {
            return new EncodedValueDouble(value);
        }
        if (value instanceof Float) {
            return new EncodedValueFloat(value);
        }
        if (value instanceof Long) {
            return new EncodedValueLong(value);
        }
        if (value instanceof Short) {
            return new EncodedValueShort(value);
        }
        if (value instanceof String) {
            return new EncodedValueString(value);
        }
        if (value instanceof int[]) {
            int[] array;
            EncodedValueArray encodedArray = new EncodedValueArray();
            int[] nArray = array = (int[])value;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                int v = nArray[n2];
                encodedArray.addEncodedValue(new EncodedValueInteger(v));
                ++n2;
            }
            return encodedArray;
        }
        if (value instanceof boolean[]) {
            boolean[] array;
            EncodedValueArray encodedArray = new EncodedValueArray();
            boolean[] blArray = array = (boolean[])value;
            int n = array.length;
            int n3 = 0;
            while (n3 < n) {
                boolean v = blArray[n3];
                encodedArray.addEncodedValue(new EncodedValueBoolean(v));
                ++n3;
            }
            return encodedArray;
        }
        if (value instanceof byte[]) {
            byte[] array;
            EncodedValueArray encodedArray = new EncodedValueArray();
            byte[] byArray = array = (byte[])value;
            int n = array.length;
            int n4 = 0;
            while (n4 < n) {
                byte v = byArray[n4];
                encodedArray.addEncodedValue(new EncodedValueByte(v));
                ++n4;
            }
            return encodedArray;
        }
        if (value instanceof char[]) {
            char[] array;
            EncodedValueArray encodedArray = new EncodedValueArray();
            char[] cArray = array = (char[])value;
            int n = array.length;
            int n5 = 0;
            while (n5 < n) {
                char v = cArray[n5];
                encodedArray.addEncodedValue(new EncodedValueCharacter(v));
                ++n5;
            }
            return encodedArray;
        }
        if (value instanceof double[]) {
            double[] array;
            EncodedValueArray encodedArray = new EncodedValueArray();
            double[] dArray = array = (double[])value;
            int n = array.length;
            int n6 = 0;
            while (n6 < n) {
                double v = dArray[n6];
                encodedArray.addEncodedValue(new EncodedValueDouble(v));
                ++n6;
            }
            return encodedArray;
        }
        if (value instanceof float[]) {
            float[] array;
            EncodedValueArray encodedArray = new EncodedValueArray();
            float[] fArray = array = (float[])value;
            int n = array.length;
            int n7 = 0;
            while (n7 < n) {
                float v = fArray[n7];
                encodedArray.addEncodedValue(new EncodedValueFloat(v));
                ++n7;
            }
            return encodedArray;
        }
        if (value instanceof long[]) {
            long[] array;
            EncodedValueArray encodedArray = new EncodedValueArray();
            long[] lArray = array = (long[])value;
            int n = array.length;
            int n8 = 0;
            while (n8 < n) {
                long v = lArray[n8];
                encodedArray.addEncodedValue(new EncodedValueLong(v));
                ++n8;
            }
            return encodedArray;
        }
        if (value instanceof short[]) {
            short[] array;
            EncodedValueArray encodedArray = new EncodedValueArray();
            short[] sArray = array = (short[])value;
            int n = array.length;
            int n9 = 0;
            while (n9 < n) {
                short v = sArray[n9];
                encodedArray.addEncodedValue(new EncodedValueShort(v));
                ++n9;
            }
            return encodedArray;
        }
        if (value instanceof String[]) {
            String[] array;
            EncodedValueArray encodedArray = new EncodedValueArray();
            String[] stringArray = array = (String[])value;
            int n = array.length;
            int n10 = 0;
            while (n10 < n) {
                String v = stringArray[n10];
                encodedArray.addEncodedValue(new EncodedValueString(v));
                ++n10;
            }
            return encodedArray;
        }
        try {
            throw new Exception("Unable to find the type of this Value.");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

