/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.encodedValue;

import java.util.ArrayList;
import org.ow2.asmdex.encodedValue.EncodedValue;
import org.ow2.asmdex.lowLevelUtils.ByteVector;
import org.ow2.asmdex.structureWriter.ConstantPool;

public class EncodedValueArray
extends EncodedValue {
    private int type = 28;
    private ArrayList<EncodedValue> encodedValues = new ArrayList();

    @Override
    public int getType() {
        return this.type;
    }

    public ArrayList<EncodedValue> getEncodedValues() {
        return this.encodedValues;
    }

    public int getNbEncodedValues() {
        return this.encodedValues.size();
    }

    public void addEncodedValue(EncodedValue encodedValue) {
        this.encodedValues.add(encodedValue);
    }

    @Override
    public byte[] encode(ConstantPool constantPool) {
        ByteVector out = new ByteVector();
        out.putByte(28);
        out.putUleb128(this.getNbEncodedValues());
        for (EncodedValue encodedValue : this.encodedValues) {
            out.putByteArray(encodedValue.encode(constantPool));
        }
        return out.getData();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        boolean result = false;
        if (o instanceof EncodedValueArray) {
            EncodedValueArray encodedValue = (EncodedValueArray)o;
            result = this.encodedValues.equals(encodedValue.encodedValues);
        }
        return result;
    }

    public int hashCode() {
        int result = this.type;
        for (EncodedValue encodedValue : this.encodedValues) {
            result += encodedValue.hashCode();
        }
        return result;
    }

    @Override
    int compareValue(EncodedValue encodedValue) {
        int size2;
        EncodedValueArray ea = (EncodedValueArray)encodedValue;
        int size1 = this.encodedValues.size();
        int size = size1 < (size2 = ea.encodedValues.size()) ? size1 : size2;
        int result = 0;
        int i = 0;
        while (result == 0 && i < size) {
            int v2Type;
            EncodedValue v1 = this.encodedValues.get(i);
            EncodedValue v2 = ea.encodedValues.get(i);
            int v1Type = v1.getType();
            int n = v1Type == (v2Type = v2.getType()) ? 0 : (result = v1Type < v2Type ? -1 : 1);
            if (result != 0) continue;
            result = this.encodedValues.get(i).compareTo(ea.encodedValues.get(i));
            ++i;
        }
        if (result == 0) {
            result = size1 == size2 ? 0 : (size1 < size2 ? -1 : 1);
        }
        return result;
    }
}

