/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.ow2.asmdex.AnnotationVisitor;
import org.ow2.asmdex.ApplicationVisitor;
import org.ow2.asmdex.ApplicationWriter;
import org.ow2.asmdex.ClassVisitor;
import org.ow2.asmdex.FieldVisitor;
import org.ow2.asmdex.MethodCodeReader;
import org.ow2.asmdex.MethodVisitor;
import org.ow2.asmdex.MethodWriter;
import org.ow2.asmdex.lowLevelUtils.DexFileReader;
import org.ow2.asmdex.lowLevelUtils.IDalvikValueReader;
import org.ow2.asmdex.specificAnnotationParser.DefaultAnnotationSpecificAnnotationParser;
import org.ow2.asmdex.specificAnnotationParser.EnclosingClassSpecificAnnotationParser;
import org.ow2.asmdex.specificAnnotationParser.EnclosingMethodSpecificAnnotationParser;
import org.ow2.asmdex.specificAnnotationParser.ExceptionSpecificAnnotationParser;
import org.ow2.asmdex.specificAnnotationParser.ISpecificAnnotationParser;
import org.ow2.asmdex.specificAnnotationParser.InnerClassSpecificAnnotationParser;
import org.ow2.asmdex.specificAnnotationParser.MemberClassesSpecificAnnotationParser;
import org.ow2.asmdex.specificAnnotationParser.SignatureSpecificAnnotationParser;
import org.ow2.asmdex.specificAnnotationVisitors.DefaultAnnotationInformation;
import org.ow2.asmdex.specificAnnotationVisitors.DefaultAnnotationVisitor;
import org.ow2.asmdex.specificAnnotationVisitors.EnclosingClassAnnotationVisitor;
import org.ow2.asmdex.specificAnnotationVisitors.EnclosingMethodAnnotationVisitor;
import org.ow2.asmdex.specificAnnotationVisitors.ExceptionAnnotationVisitor;
import org.ow2.asmdex.specificAnnotationVisitors.InnerClassAnnotationVisitor;
import org.ow2.asmdex.specificAnnotationVisitors.MemberClassesAnnotationVisitor;
import org.ow2.asmdex.specificAnnotationVisitors.SignatureAnnotationVisitor;
import org.ow2.asmdex.structureReader.ClassDefinitionItem;
import org.ow2.asmdex.structureReader.FieldIdItem;
import org.ow2.asmdex.structureReader.MethodIdItem;

public class ApplicationReader {
    public final byte[] byteCode;
    private DexFileReader dexFile;
    private HashMap<Integer, Integer> fieldAnnotationOffsetsOfClass;
    private HashMap<Integer, Integer> methodAnnotationOffsetsOfClass;
    private HashMap<Integer, Integer> parameterAnnotationOffsetsOfClass;
    private HashMap<Integer, Integer> typeIdToClassIndexMap;
    private HashMap<String, Integer> classNameToIndex;
    private HashMap<String, DefaultAnnotationInformation> defaultAnnotations = new HashMap();
    public static final boolean DEBUG_DISPLAY_STRUCTURES = false;
    private static final boolean ANNOTATIONS = true;
    private static final boolean WRITER = true;
    public static final int SKIP_CODE = 1;
    public static final int SKIP_DEBUG = 2;
    protected int api;

    public ApplicationReader(int api, byte[] byteCode) {
        this(api, byteCode, 0, byteCode.length);
    }

    public ApplicationReader(int api, byte[] byteCode, int startOffset, int length) {
        this.byteCode = startOffset != 0 || length != byteCode.length ? Arrays.copyOfRange(byteCode, startOffset, length + startOffset) : byteCode;
        this.dexFile = new DexFileReader();
        try {
            this.dexFile.parse(this.byteCode);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ApplicationReader(int api, InputStream inputStream) throws IOException {
        this(api, ApplicationReader.readApplication(inputStream));
    }

    public ApplicationReader(int api, String fileName) throws IOException {
        this(api, ApplicationReader.readApplication(new FileInputStream(new File(fileName))));
    }

    public ApplicationReader(int api, File file) throws IOException {
        this(api, ApplicationReader.readApplication(new FileInputStream(file)));
    }

    public IDalvikValueReader getDexFile() {
        return this.dexFile;
    }

    private static byte[] readApplication(InputStream inputStream) throws IOException {
        byte[] result;
        block11: {
            result = null;
            if (inputStream == null) {
                throw new IOException("Application not found");
            }
            ByteArrayOutputStream buffer = null;
            try {
                try {
                    int nbBytesRead;
                    buffer = new ByteArrayOutputStream();
                    byte[] dataRead = new byte[16384];
                    while ((nbBytesRead = inputStream.read(dataRead)) != -1) {
                        buffer.write(dataRead, 0, nbBytesRead);
                    }
                    buffer.flush();
                    result = buffer.toByteArray();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (buffer != null) {
                        buffer.close();
                    }
                    inputStream.close();
                    break block11;
                }
            }
            catch (Throwable throwable) {
                if (buffer != null) {
                    buffer.close();
                }
                inputStream.close();
                throw throwable;
            }
            if (buffer != null) {
                buffer.close();
            }
            inputStream.close();
        }
        if (result == null) {
            throw new IOException("Application bytecode not initialized");
        }
        return result;
    }

    public void accept(ApplicationVisitor applicationVisitor, String[] classesToVisit, int flags) {
        this.accept(applicationVisitor, classesToVisit, null, flags);
    }

    public void accept(ApplicationVisitor applicationVisitor, int flags) {
        this.accept(applicationVisitor, null, null, flags);
    }

    public void accept(ApplicationVisitor applicationVisitor, String[] classesToVisit, Object attrs, int flags) {
        String className;
        int classIndexRead;
        applicationVisitor.visit();
        int classDefinitionsSize = this.dexFile.getClassDefinitionsSize();
        this.typeIdToClassIndexMap = new HashMap(classDefinitionsSize);
        this.classNameToIndex = new HashMap(classDefinitionsSize);
        int index = 0;
        while (index < classDefinitionsSize) {
            this.dexFile.seek(this.dexFile.getClassDefinitionOffset(index));
            classIndexRead = this.dexFile.uint();
            this.typeIdToClassIndexMap.put(classIndexRead, index);
            className = this.dexFile.getStringItemFromTypeIndex(classIndexRead);
            this.classNameToIndex.put(className, index);
            ++index;
        }
        if (classesToVisit == null) {
            index = 0;
            while (index < classDefinitionsSize) {
                this.dexFile.seek(this.dexFile.getClassDefinitionOffset(index));
                classIndexRead = this.dexFile.uint();
                className = this.dexFile.getStringItemFromTypeIndex(classIndexRead);
                this.visitClass(applicationVisitor, className, flags);
                ++index;
            }
        } else {
            String[] stringArray = classesToVisit;
            int n = classesToVisit.length;
            int n2 = 0;
            while (n2 < n) {
                String className2 = stringArray[n2];
                this.visitClass(applicationVisitor, className2, flags);
                ++n2;
            }
        }
        applicationVisitor.visitEnd();
    }

    private void visitClass(ApplicationVisitor applicationVisitor, String className, int flags) {
        boolean skipCode = (flags & 1) != 0;
        boolean skipDebug = (flags & 2) != 0;
        int classIndex = this.classNameToIndex.get(className);
        ClassDefinitionItem classDefinitionItem = this.dexFile.getClassDefinitionItem(classIndex);
        int accessFlags = classDefinitionItem.getAccessFlags();
        int superclassIndex = classDefinitionItem.getSuperclassIndex();
        int interfacesOffset = classDefinitionItem.getInterfacesOffset();
        int sourceFileIndex = classDefinitionItem.getSourceFileIndex();
        int annotationsOffset = classDefinitionItem.getAnnotationsOffset();
        int classDataOffset = classDefinitionItem.getClassDataOffset();
        int staticValuesOffset = classDefinitionItem.getStaticValuesOffset();
        String[] interfaces = null;
        if (interfacesOffset != 0) {
            this.dexFile.seek(interfacesOffset);
            int interfacesListSize = this.dexFile.uint();
            interfaces = new String[interfacesListSize];
            int noInterface = 0;
            while (noInterface < interfacesListSize) {
                String interfaceName;
                int typeIndex = this.dexFile.ushort();
                interfaces[noInterface] = interfaceName = this.dexFile.getStringItemFromTypeIndex(typeIndex);
                ++noInterface;
            }
        }
        String superName = superclassIndex == -1 ? "Ljava/lang/Object;" : this.dexFile.getStringItemFromTypeIndex(superclassIndex);
        String[] signature = null;
        if (annotationsOffset != 0) {
            this.dexFile.seek(annotationsOffset);
            int classAnnotationsOffset = this.dexFile.uint();
            if (classAnnotationsOffset != 0) {
                this.dexFile.seek(classAnnotationsOffset);
                signature = this.readSignatureAnnotation();
            }
        }
        ClassVisitor classVisitor = applicationVisitor.visitClass(accessFlags, className, signature, superName, interfaces);
        Object[] staticValues = null;
        if (staticValuesOffset != 0) {
            this.dexFile.seek(staticValuesOffset);
            staticValues = this.decodedEncodedArrayAsObjects();
        }
        if (classVisitor != null) {
            classVisitor.visit(0, accessFlags, className, signature, superName, interfaces);
            if (sourceFileIndex != -1) {
                String sourceFile = this.dexFile.getStringItemFromStringIndex(sourceFileIndex);
                classVisitor.visitSource(sourceFile, null);
            }
            int classAnnotationsOffset = 0;
            if (annotationsOffset != 0) {
                this.dexFile.seek(annotationsOffset);
                classAnnotationsOffset = this.dexFile.uint();
                if (classAnnotationsOffset != 0) {
                    this.dexFile.seek(classAnnotationsOffset);
                    this.readOuterClassAnnotations(classVisitor);
                    this.dexFile.seek(classAnnotationsOffset);
                    this.readAndVisitAnnotations(classVisitor, 0, VisitorType.classVisitor);
                    this.dexFile.seek(classAnnotationsOffset);
                    this.readDefaultAnnotations();
                    this.dexFile.seek(annotationsOffset + 4);
                }
                int fieldsSize = this.dexFile.uint();
                int annotatedMethodsSize = this.dexFile.uint();
                int annotatedParametersSize = this.dexFile.uint();
                this.fieldAnnotationOffsetsOfClass = this.dexFile.fillOffsetHashMap(fieldsSize);
                this.methodAnnotationOffsetsOfClass = this.dexFile.fillOffsetHashMap(annotatedMethodsSize);
                this.parameterAnnotationOffsetsOfClass = this.dexFile.fillOffsetHashMap(annotatedParametersSize);
                if (classAnnotationsOffset != 0) {
                    this.dexFile.seek(classAnnotationsOffset);
                    this.readInnerClassAnnotations(classVisitor);
                    this.dexFile.seek(classAnnotationsOffset);
                    this.readMemberClassesAnnotations(classVisitor);
                }
            }
            if (classDataOffset != 0) {
                this.dexFile.seek(classDataOffset);
                int nbStaticFields = this.dexFile.uleb128();
                int nbInstanceFields = this.dexFile.uleb128();
                int nbDirectMethods = this.dexFile.uleb128();
                int nbVirtualMethods = this.dexFile.uleb128();
                this.visitFields(classVisitor, nbStaticFields, staticValues, annotationsOffset);
                this.visitFields(classVisitor, nbInstanceFields, null, annotationsOffset);
                this.visitMethods(classVisitor, nbDirectMethods, annotationsOffset, skipDebug, skipCode);
                this.visitMethods(classVisitor, nbVirtualMethods, annotationsOffset, skipDebug, skipCode);
            }
            classVisitor.visitEnd();
        }
    }

    private void visitFields(ClassVisitor classVisitor, int nbFields, Object[] staticValues, int annotationsOffset) {
        int fieldIndex = 0;
        int nbStaticValues = staticValues != null ? staticValues.length : 0;
        int i = 0;
        while (i < nbFields) {
            FieldVisitor fieldVisitor;
            int readFieldIndex = this.dexFile.uleb128();
            fieldIndex = i == 0 ? readFieldIndex : fieldIndex + readFieldIndex;
            int fieldAccessFlags = this.dexFile.uleb128();
            int saveDexFilePosition = this.dexFile.getPos();
            this.dexFile.seek(this.dexFile.getOffsetFieldIdItem(fieldIndex));
            this.dexFile.skipShort();
            int typeIndexInFieldId = this.dexFile.ushort();
            int nameIndexInFieldId = this.dexFile.uint();
            String fieldName = this.dexFile.getStringItemFromStringIndex(nameIndexInFieldId);
            String fieldType = this.dexFile.getStringItemFromTypeIndex(typeIndexInFieldId);
            Object fieldValue = null;
            if (i < nbStaticValues) {
                fieldValue = staticValues[i];
            }
            String[] signature = null;
            if (annotationsOffset != 0 && this.fieldAnnotationOffsetsOfClass.containsKey(fieldIndex)) {
                this.dexFile.seek(this.fieldAnnotationOffsetsOfClass.get(fieldIndex));
                signature = this.readSignatureAnnotation();
            }
            if ((fieldVisitor = classVisitor.visitField(fieldAccessFlags, fieldName, fieldType, signature, fieldValue)) != null) {
                if (annotationsOffset != 0 && this.fieldAnnotationOffsetsOfClass.containsKey(fieldIndex)) {
                    this.dexFile.seek(this.fieldAnnotationOffsetsOfClass.get(fieldIndex));
                    this.readAndVisitAnnotations(fieldVisitor, 0, VisitorType.fieldVisitor);
                }
                fieldVisitor.visitEnd();
            }
            this.dexFile.seek(saveDexFilePosition);
            ++i;
        }
    }

    private void visitMethods(ClassVisitor classVisitor, int nbMethods, int annotationsOffset, boolean skipDebug, boolean skipCode) {
        int methodIndex = 0;
        int i = 0;
        while (i < nbMethods) {
            MethodVisitor methodVisitor;
            int readMethodIndex = this.dexFile.uleb128();
            methodIndex = i == 0 ? readMethodIndex : methodIndex + readMethodIndex;
            int methodAccessFlags = this.dexFile.uleb128();
            int codeOffset = this.dexFile.uleb128();
            int saveDexFilePosition = this.dexFile.getPos();
            this.dexFile.seek(this.dexFile.getOffsetMethodIdItem(methodIndex));
            this.dexFile.skipShort();
            int protoIndexInFieldId = this.dexFile.ushort();
            int nameIndexInFieldId = this.dexFile.uint();
            String methodName = this.dexFile.getStringItemFromStringIndex(nameIndexInFieldId);
            String methodDescriptor = this.dexFile.getDescriptorFromPrototypeIndex(protoIndexInFieldId);
            Object[] exceptions = null;
            Object[] signature = null;
            if (annotationsOffset != 0 && this.methodAnnotationOffsetsOfClass.containsKey(methodIndex)) {
                this.dexFile.seek(this.methodAnnotationOffsetsOfClass.get(methodIndex));
                List<String> exceptionList = this.readExceptionAnnotations();
                if (exceptionList != null) {
                    exceptions = exceptionList.toArray(new String[exceptionList.size()]);
                }
                this.dexFile.seek(this.methodAnnotationOffsetsOfClass.get(methodIndex));
                signature = this.readSignatureAnnotation();
            }
            if ((methodVisitor = classVisitor.visitMethod(methodAccessFlags, methodName, methodDescriptor, (String[])signature, (String[])exceptions)) != null) {
                if (annotationsOffset != 0) {
                    AnnotationVisitor annotationVisitor;
                    if (this.defaultAnnotations.containsKey(methodName) && (annotationVisitor = methodVisitor.visitAnnotationDefault()) != null) {
                        annotationVisitor.visit(methodName, this.defaultAnnotations.get(methodName).getValue());
                        annotationVisitor.visitEnd();
                    }
                    if (this.methodAnnotationOffsetsOfClass.containsKey(methodIndex)) {
                        this.dexFile.seek(this.methodAnnotationOffsetsOfClass.get(methodIndex));
                        this.readAndVisitAnnotations(methodVisitor, -1, VisitorType.methodVisitor);
                    }
                    if (this.parameterAnnotationOffsetsOfClass.containsKey(methodIndex)) {
                        this.dexFile.seek(this.parameterAnnotationOffsetsOfClass.get(methodIndex));
                        int nbAnnotations = this.dexFile.uint();
                        int annotationIndex = 0;
                        while (annotationIndex < nbAnnotations) {
                            int annotationSetItemOffset = this.dexFile.uint();
                            int saveReaderPosition = this.dexFile.getPos();
                            this.dexFile.seek(annotationSetItemOffset);
                            this.readAndVisitAnnotations(methodVisitor, annotationIndex, VisitorType.methodVisitor);
                            this.dexFile.seek(saveReaderPosition);
                            ++annotationIndex;
                        }
                    }
                }
                boolean isOptimizationUsed = false;
                if (!skipCode) {
                    Object[] otherExceptions;
                    Object[] otherSignature;
                    MethodWriter methodWriter;
                    if (methodVisitor instanceof MethodWriter && (methodWriter = (MethodWriter)methodVisitor).getClassWriter().getApplicationWriter().getApplicationReader() == this && Arrays.equals(signature, otherSignature = methodWriter.getMethod().getSignature()) && Arrays.equals(exceptions, otherExceptions = methodWriter.getMethod().getExceptionNames())) {
                        isOptimizationUsed = true;
                        methodWriter.setStartBytecodeToCopy(codeOffset);
                    }
                    if (!isOptimizationUsed) {
                        MethodCodeReader methodCodeReader = new MethodCodeReader(this.dexFile, methodVisitor, codeOffset, skipDebug);
                        methodCodeReader.visitMethodCode();
                    }
                }
                methodVisitor.visitEnd();
            }
            this.dexFile.seek(saveDexFilePosition);
            ++i;
        }
    }

    private void readEncodedValue(AnnotationVisitor annotationVisitor, String valueName) {
        short value = this.dexFile.ubyte();
        int valueType = value & 0x1F;
        int valueArg = value >> 5 & 7;
        switch (valueType) {
            case 27: {
                int enumIndex = (int)this.dexFile.sizedLong(valueArg);
                String enumValue = this.dexFile.getNameFromFieldIndex(enumIndex);
                String enumDesc = this.dexFile.getTypeNameFromFieldIndex(enumIndex);
                if (annotationVisitor == null) break;
                annotationVisitor.visitEnum(valueName, enumDesc, enumValue);
                break;
            }
            case 28: {
                this.readEncodedArray(annotationVisitor, valueName);
                break;
            }
            case 29: {
                this.readEncodedAnnotation(annotationVisitor, valueName);
                break;
            }
            case 24: {
                int typeIndex = (int)this.dexFile.sizedLong(valueArg);
                String type = this.dexFile.getStringItemFromTypeIndex(typeIndex);
                if (annotationVisitor == null) break;
                annotationVisitor.visitClass(valueName, type);
                break;
            }
            default: {
                Object val = this.interpretEncodedValue(valueType, valueArg);
                if (annotationVisitor == null) break;
                annotationVisitor.visit(valueName, val);
            }
        }
    }

    private Object interpretEncodedValue(int valueType, int valueArg) {
        Object result = null;
        switch (valueType) {
            case 31: {
                result = valueArg != 0;
                break;
            }
            case 0: {
                result = (byte)this.dexFile.completeSignSizedLong(this.dexFile.sizedLong(valueArg), valueArg);
                break;
            }
            case 2: {
                result = (short)this.dexFile.completeSignSizedLong(this.dexFile.sizedLong(valueArg), valueArg);
                break;
            }
            case 3: {
                result = Character.valueOf((char)this.dexFile.sizedLong(valueArg));
                break;
            }
            case 4: {
                result = (int)this.dexFile.completeSignSizedLong(this.dexFile.sizedLong(valueArg), valueArg);
                break;
            }
            case 6: {
                result = this.dexFile.completeSignSizedLong(this.dexFile.sizedLong(valueArg), valueArg);
                break;
            }
            case 16: {
                result = Float.valueOf(Float.intBitsToFloat((int)this.dexFile.sizedLong(valueArg) << 8 * (3 - valueArg)));
                break;
            }
            case 17: {
                long temp = this.dexFile.sizedLong(valueArg) << 8 * (7 - valueArg);
                result = Double.longBitsToDouble(temp);
                break;
            }
            case 25: {
                result = (int)this.dexFile.sizedLong(valueArg);
                break;
            }
            case 26: {
                result = (int)this.dexFile.sizedLong(valueArg);
                break;
            }
            case 23: {
                int stringIndex = (int)this.dexFile.sizedLong(valueArg);
                result = this.dexFile.getStringItemFromStringIndex(stringIndex);
                break;
            }
            case 30: {
                break;
            }
            default: {
                try {
                    throw new Exception("Unknown value format : 0x" + Integer.toHexString(valueType));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    private Object[] decodedEncodedArrayAsObjects() {
        int arraySize = this.dexFile.uleb128();
        Object[] result = new Object[arraySize];
        int i = 0;
        while (i < arraySize) {
            short value = this.dexFile.ubyte();
            int valueType = value & 0x1F;
            int valueArg = value >> 5 & 7;
            result[i] = this.interpretEncodedValue(valueType, valueArg);
            ++i;
        }
        return result;
    }

    private Object decodeEncodedArray() {
        int arraySize = this.dexFile.uleb128();
        if (arraySize == 0) {
            return new int[0];
        }
        short value = this.dexFile.ubyte();
        int valueType = value & 0x1F;
        int valueArg = value >> 5 & 7;
        switch (valueType) {
            case 4: {
                int[] array = new int[arraySize];
                array[0] = (Integer)this.interpretEncodedValue(valueType, valueArg);
                int i = 1;
                while (i < arraySize) {
                    value = this.dexFile.ubyte();
                    array[i] = (Integer)this.interpretEncodedValue(value & 0x1F, value >> 5 & 7);
                    ++i;
                }
                return array;
            }
            case 31: {
                boolean[] array = new boolean[arraySize];
                array[0] = (Boolean)this.interpretEncodedValue(valueType, valueArg);
                int i = 1;
                while (i < arraySize) {
                    value = this.dexFile.ubyte();
                    array[i] = (Boolean)this.interpretEncodedValue(value & 0x1F, value >> 5 & 7);
                    ++i;
                }
                return array;
            }
            case 0: {
                byte[] array = new byte[arraySize];
                array[0] = (Byte)this.interpretEncodedValue(valueType, valueArg);
                int i = 1;
                while (i < arraySize) {
                    value = this.dexFile.ubyte();
                    array[i] = (Byte)this.interpretEncodedValue(value & 0x1F, value >> 5 & 7);
                    ++i;
                }
                return array;
            }
            case 2: {
                short[] array = new short[arraySize];
                array[0] = (Short)this.interpretEncodedValue(valueType, valueArg);
                int i = 1;
                while (i < arraySize) {
                    value = this.dexFile.ubyte();
                    array[i] = (Short)this.interpretEncodedValue(value & 0x1F, value >> 5 & 7);
                    ++i;
                }
                return array;
            }
            case 3: {
                char[] array = new char[arraySize];
                array[0] = ((Character)this.interpretEncodedValue(valueType, valueArg)).charValue();
                int i = 1;
                while (i < arraySize) {
                    value = this.dexFile.ubyte();
                    array[i] = ((Character)this.interpretEncodedValue(value & 0x1F, value >> 5 & 7)).charValue();
                    ++i;
                }
                return array;
            }
            case 6: {
                long[] array = new long[arraySize];
                array[0] = (Long)this.interpretEncodedValue(valueType, valueArg);
                int i = 1;
                while (i < arraySize) {
                    value = this.dexFile.ubyte();
                    array[i] = (Long)this.interpretEncodedValue(value & 0x1F, value >> 5 & 7);
                    ++i;
                }
                return array;
            }
            case 16: {
                float[] array = new float[arraySize];
                array[0] = ((Float)this.interpretEncodedValue(valueType, valueArg)).floatValue();
                int i = 1;
                while (i < arraySize) {
                    value = this.dexFile.ubyte();
                    array[i] = ((Float)this.interpretEncodedValue(value & 0x1F, value >> 5 & 7)).floatValue();
                    ++i;
                }
                return array;
            }
            case 17: {
                double[] array = new double[arraySize];
                array[0] = (Double)this.interpretEncodedValue(valueType, valueArg);
                int i = 1;
                while (i < arraySize) {
                    value = this.dexFile.ubyte();
                    array[i] = (Double)this.interpretEncodedValue(value & 0x1F, value >> 5 & 7);
                    ++i;
                }
                return array;
            }
            case 23: {
                String[] array = new String[arraySize];
                array[0] = (String)this.interpretEncodedValue(valueType, valueArg);
                int i = 1;
                while (i < arraySize) {
                    value = this.dexFile.ubyte();
                    array[i] = (String)this.interpretEncodedValue(value & 0x1F, value >> 5 & 7);
                    ++i;
                }
                return array;
            }
            case 24: 
            case 25: 
            case 26: 
            case 30: {
                Object[] array = new Object[arraySize];
                array[0] = this.interpretEncodedValue(valueType, valueArg);
                int i = 1;
                while (i < arraySize) {
                    value = this.dexFile.ubyte();
                    array[i] = this.interpretEncodedValue(value & 0x1F, value >> 5 & 7);
                    ++i;
                }
                return array;
            }
        }
        try {
            throw new Exception("Unhandled value format : " + Integer.toHexString(valueType));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void readEncodedArray(AnnotationVisitor annotationVisitor, String valueName) {
        if (this.isEncodedArrayPrimitive()) {
            Object primitiveArray = this.decodeEncodedArray();
            if (annotationVisitor != null) {
                annotationVisitor.visit(valueName, primitiveArray);
            }
        } else {
            AnnotationVisitor arrayElementsAnnotationVisitor;
            int nbElements = this.dexFile.uleb128();
            if (annotationVisitor != null && (arrayElementsAnnotationVisitor = annotationVisitor.visitArray(valueName)) != null) {
                int elementIndex = 0;
                while (elementIndex < nbElements) {
                    this.readEncodedValue(arrayElementsAnnotationVisitor, null);
                    ++elementIndex;
                }
                arrayElementsAnnotationVisitor.visitEnd();
            }
        }
    }

    private boolean isEncodedValuePrimitive() {
        boolean isPrimitive = true;
        int saveReaderPosition = this.dexFile.getPos();
        short value = this.dexFile.ubyte();
        int valueType = value & 0x1F;
        switch (valueType) {
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: {
                isPrimitive = false;
            }
        }
        this.dexFile.seek(saveReaderPosition);
        return isPrimitive;
    }

    private boolean isEncodedArrayPrimitive() {
        boolean isPrimitive = true;
        int saveReaderPosition = this.dexFile.getPos();
        int nbElements = this.dexFile.uleb128();
        if (nbElements > 0) {
            isPrimitive = this.isEncodedValuePrimitive();
        }
        this.dexFile.seek(saveReaderPosition);
        return isPrimitive;
    }

    private void readAndVisitAnnotations(Object visitor, int parameterNumber, VisitorType visitorType) {
        int[] annotationOffsets = this.dexFile.getAnnotationItemOffsetsFromAnnotationSetItem();
        int annotationIndex = 0;
        int nbAnnotations = annotationOffsets.length;
        while (annotationIndex < nbAnnotations) {
            this.dexFile.seek(annotationOffsets[annotationIndex]);
            short classVisibility = this.dexFile.ubyte();
            boolean isAnnotationVisible = classVisibility == 1;
            String annotationType = this.dexFile.getStringItemFromTypeIndex(this.dexFile.uleb128());
            if (!(annotationType.equals("Ldalvik/annotation/Throws;") || annotationType.equals("Ldalvik/annotation/EnclosingClass;") || annotationType.equals("Ldalvik/annotation/InnerClass;") || annotationType.equals("Ldalvik/annotation/EnclosingMethod;") || annotationType.equals("Ldalvik/annotation/MemberClasses;") || annotationType.equals("Ldalvik/annotation/AnnotationDefault;") || annotationType.equals("Ldalvik/annotation/Signature;"))) {
                AnnotationVisitor annotationVisitor = null;
                if (visitorType == VisitorType.classVisitor) {
                    annotationVisitor = ((ClassVisitor)visitor).visitAnnotation(annotationType, isAnnotationVisible);
                } else if (visitorType == VisitorType.fieldVisitor) {
                    annotationVisitor = ((FieldVisitor)visitor).visitAnnotation(annotationType, isAnnotationVisible);
                } else if (visitorType == VisitorType.methodVisitor) {
                    annotationVisitor = parameterNumber < 0 ? ((MethodVisitor)visitor).visitAnnotation(annotationType, isAnnotationVisible) : ((MethodVisitor)visitor).visitParameterAnnotation(parameterNumber, annotationType, isAnnotationVisible);
                }
                if (annotationVisitor != null) {
                    int nbAnnotationElements = this.dexFile.uleb128();
                    int i = 0;
                    while (i < nbAnnotationElements) {
                        this.readAnnotationElement(annotationVisitor);
                        ++i;
                    }
                    annotationVisitor.visitEnd();
                }
            }
            ++annotationIndex;
        }
    }

    private List<String> readExceptionAnnotations() {
        ExceptionSpecificAnnotationParser specificAnnotationParser = new ExceptionSpecificAnnotationParser("Ldalvik/annotation/Throws;");
        boolean foundAnnotation = this.parseSpecificAnnotations(new ExceptionAnnotationVisitor(this.api), specificAnnotationParser);
        return foundAnnotation ? specificAnnotationParser.getExceptions() : null;
    }

    private void readDefaultAnnotations() {
        DefaultAnnotationSpecificAnnotationParser specificAnnotationParser = new DefaultAnnotationSpecificAnnotationParser("Ldalvik/annotation/AnnotationDefault;");
        boolean foundAnnotation = this.parseSpecificAnnotations(new DefaultAnnotationVisitor(this.api), specificAnnotationParser);
        if (foundAnnotation) {
            DefaultAnnotationVisitor dav = (DefaultAnnotationVisitor)specificAnnotationParser.getAnnotationVisitor();
            for (DefaultAnnotationInformation info : dav.getDefaultAnnotationInformationList()) {
                String methodName = info.getName();
                this.defaultAnnotations.put(methodName, info);
            }
        } else {
            this.defaultAnnotations.clear();
        }
    }

    private String[] readSignatureAnnotation() {
        String[] result = null;
        SignatureSpecificAnnotationParser specificAnnotationParser = new SignatureSpecificAnnotationParser("Ldalvik/annotation/Signature;");
        boolean foundAnnotation = this.parseSpecificAnnotations(new SignatureAnnotationVisitor(this.api), specificAnnotationParser);
        if (foundAnnotation) {
            result = specificAnnotationParser.getSignature();
        }
        return result;
    }

    private void readMemberClassesAnnotations(ClassVisitor classVisitor) {
        MemberClassesSpecificAnnotationParser specificAnnotationParser = new MemberClassesSpecificAnnotationParser("Ldalvik/annotation/MemberClasses;");
        boolean foundAnnotation = this.parseSpecificAnnotations(new MemberClassesAnnotationVisitor(this.api), specificAnnotationParser);
        if (foundAnnotation) {
            MemberClassesSpecificAnnotationParser parser = specificAnnotationParser;
            List<String> classes = parser.getInnerClasses();
            for (String name : classes) {
                Integer classIndex = this.classNameToIndex.get(name);
                int accessFlags = 0;
                if (classIndex != null && classIndex >= 0) {
                    ClassDefinitionItem cdi = this.dexFile.getClassDefinitionItem(classIndex);
                    accessFlags = cdi.getAccessFlags();
                }
                int i = name.lastIndexOf(36);
                String innerName = name.substring(i + 1, name.length() - 1);
                String outerName = i < 0 ? null : String.valueOf(name.substring(0, i)) + ";";
                classVisitor.visitInnerClass(name, outerName, innerName, accessFlags);
            }
        }
    }

    private void readInnerClassAnnotations(ClassVisitor classVisitor) {
        InnerClassSpecificAnnotationParser innerClassSpecificAnnotationParser = new InnerClassSpecificAnnotationParser("Ldalvik/annotation/InnerClass;");
        EnclosingClassSpecificAnnotationParser enclosingClassSpecificAnnotationParser = new EnclosingClassSpecificAnnotationParser("Ldalvik/annotation/EnclosingClass;");
        boolean foundFirstAnnotation = this.parseSpecificAnnotations(new InnerClassAnnotationVisitor(this.api), innerClassSpecificAnnotationParser);
        boolean foundSecondAnnotation = this.parseSpecificAnnotations(new EnclosingClassAnnotationVisitor(this.api), enclosingClassSpecificAnnotationParser);
        if (foundFirstAnnotation && foundSecondAnnotation) {
            InnerClassSpecificAnnotationParser innerParser = innerClassSpecificAnnotationParser;
            EnclosingClassSpecificAnnotationParser enclosingParser = enclosingClassSpecificAnnotationParser;
            String outerClassName = enclosingParser.getClassName();
            String simpleNameInnerClass = innerParser.getSimpleNameInnerClass();
            String nameInnerClass = null;
            if (simpleNameInnerClass != null && outerClassName != null) {
                nameInnerClass = String.valueOf(outerClassName.replace(';', '$')) + simpleNameInnerClass + ';';
            }
            classVisitor.visitInnerClass(nameInnerClass, outerClassName, simpleNameInnerClass, innerParser.getAccessFlagsInnerClass());
        }
    }

    private void readOuterClassAnnotations(ClassVisitor classVisitor) {
        EnclosingMethodSpecificAnnotationParser enclosingMethodSpecificAnnotationParser = new EnclosingMethodSpecificAnnotationParser("Ldalvik/annotation/EnclosingMethod;");
        InnerClassSpecificAnnotationParser innerClassSpecificAnnotationParser = new InnerClassSpecificAnnotationParser("Ldalvik/annotation/InnerClass;");
        boolean foundFirstAnnotation = this.parseSpecificAnnotations(new EnclosingMethodAnnotationVisitor(this.api), enclosingMethodSpecificAnnotationParser);
        boolean foundSecondAnnotation = this.parseSpecificAnnotations(new InnerClassAnnotationVisitor(this.api), innerClassSpecificAnnotationParser);
        if (foundFirstAnnotation && foundSecondAnnotation) {
            int methodId = enclosingMethodSpecificAnnotationParser.getClassId();
            MethodIdItem methodIdItem = this.dexFile.getMethodIdItem(methodId);
            String nameEnclosingClass = this.dexFile.getStringItemFromTypeIndex(methodIdItem.getClassIndex());
            String methodDescriptor = this.dexFile.getDescriptorFromPrototypeIndex(methodIdItem.getPrototypeIndex());
            String methodName = this.dexFile.getStringItemFromStringIndex(methodIdItem.getNameIndex());
            if (nameEnclosingClass != null) {
                classVisitor.visitOuterClass(nameEnclosingClass, methodName, methodDescriptor);
            }
            InnerClassSpecificAnnotationParser innerParser = innerClassSpecificAnnotationParser;
            String simpleNameInnerClass = innerParser.getSimpleNameInnerClass();
            String outerClassName = this.dexFile.getNameFromMethodIndex(methodId);
            String nameInnerClass = null;
            if (nameEnclosingClass != null && simpleNameInnerClass != null && outerClassName != null) {
                nameInnerClass = String.valueOf(nameEnclosingClass.replace(';', '$')) + '1' + simpleNameInnerClass;
            }
            classVisitor.visitInnerClass(nameInnerClass, outerClassName, simpleNameInnerClass, innerParser.getAccessFlagsInnerClass());
        }
    }

    private boolean parseSpecificAnnotations(AnnotationVisitor av, ISpecificAnnotationParser specificAnnotationParser) {
        int savePositionreader = this.dexFile.getPos();
        boolean foundAnnotation = false;
        int[] annotationOffsets = this.dexFile.getAnnotationItemOffsetsFromAnnotationSetItem();
        int annotationIndex = 0;
        int nbAnnotations = annotationOffsets.length;
        while (annotationIndex < nbAnnotations) {
            this.dexFile.seek(annotationOffsets[annotationIndex]);
            this.dexFile.skipByte();
            String annotationType = this.dexFile.getStringItemFromTypeIndex(this.dexFile.uleb128());
            if (specificAnnotationParser.getAnnotationName().equals(annotationType)) {
                foundAnnotation = true;
                int nbAnnotationElements = this.dexFile.uleb128();
                int i = 0;
                while (i < nbAnnotationElements) {
                    this.readAnnotationElement(av);
                    ++i;
                }
                specificAnnotationParser.treat(this.dexFile, this, av);
            }
            ++annotationIndex;
        }
        this.dexFile.seek(savePositionreader);
        return foundAnnotation;
    }

    private void readAnnotationElement(AnnotationVisitor annotationVisitor) {
        String annotationName = this.dexFile.getStringItemFromStringIndex(this.dexFile.uleb128());
        this.readEncodedValue(annotationVisitor, annotationName);
    }

    private void readEncodedAnnotation(AnnotationVisitor annotationVisitor, String valueName) {
        String annotationType = this.dexFile.getStringItemFromTypeIndex(this.dexFile.uleb128());
        AnnotationVisitor nestedAnnotationVisitor = annotationVisitor.visitAnnotation(valueName, annotationType);
        int nbElements = this.dexFile.uleb128();
        int elementIndex = 0;
        while (elementIndex < nbElements) {
            this.readAnnotationElement(nestedAnnotationVisitor);
            ++elementIndex;
        }
        if (nestedAnnotationVisitor != null) {
            nestedAnnotationVisitor.visitEnd();
        }
    }

    public void copyPool(ApplicationWriter applicationWriter) {
        String className;
        int i = 0;
        int size = this.dexFile.getStringIdsSize();
        while (i < size) {
            String string = this.dexFile.getStringItemFromStringIndex(i);
            applicationWriter.addStringFromApplicationReader(string);
            ++i;
        }
        i = 0;
        size = this.dexFile.getTypeIdsSize();
        while (i < size) {
            String type = this.dexFile.getStringItemFromTypeIndex(i);
            applicationWriter.addTypeNameFromApplicationReader(type);
            ++i;
        }
        i = 0;
        size = this.dexFile.getFieldIdsSize();
        while (i < size) {
            FieldIdItem fii = this.dexFile.getFieldIdItem(i);
            className = this.dexFile.getStringItemFromTypeIndex(fii.getClassIndex());
            String type = this.dexFile.getStringItemFromTypeIndex(fii.getTypeIndex());
            String fieldName = this.dexFile.getStringItemFromStringIndex(fii.getNameIndex());
            applicationWriter.addFieldFromApplicationReader(className, type, fieldName);
            ++i;
        }
        i = 0;
        size = this.dexFile.getMethodIdsSize();
        while (i < size) {
            MethodIdItem mii = this.dexFile.getMethodIdItem(i);
            className = this.dexFile.getStringItemFromTypeIndex(mii.getClassIndex());
            String methodName = this.dexFile.getStringItemFromStringIndex(mii.getNameIndex());
            String prototype = this.dexFile.getDescriptorFromPrototypeIndex(mii.getPrototypeIndex());
            applicationWriter.addMethodFromApplicationReader(className, prototype, methodName);
            ++i;
        }
    }

    private static enum VisitorType {
        classVisitor,
        methodVisitor,
        fieldVisitor;

    }
}

