/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asmdex.tree;

import org.junit.Assert;
import org.junit.Test;
import org.ow2.asmdex.tree.ClassNode;
import org.ow2.asmdex.tree.FieldNode;
import org.ow2.asmdex.tree.InnerClassNode;
import org.ow2.asmdex.tree.MethodNode;

public class ClassNodeTest {
    private ClassNode cn = new ClassNode(262144);

    @Test
    public void testVisit() {
        this.cn.visit(0, 0, "name", null, "superName", null);
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void testVisitField() {
        int access = 1;
        String name = "name";
        String desc = "I";
        Object[] signature = new String[]{"sig1", "sig2"};
        Integer value = 120;
        this.cn.visitField(access, name, desc, (String[])signature, value);
        FieldNode fn = this.cn.fields.get(0);
        Assert.assertEquals((long)access, (long)fn.access);
        Assert.assertEquals((Object)name, (Object)fn.name);
        Assert.assertEquals((Object)desc, (Object)fn.desc);
        Assert.assertArrayEquals((Object[])signature, (Object[])fn.signature);
        Assert.assertEquals((Object)value, (Object)fn.value);
    }

    @Test
    public void testVisitInnerClass() {
        String name = "name";
        String outerName = "outerName";
        String innerName = "innerName";
        int access = 1;
        this.cn.visitInnerClass(name, outerName, innerName, access);
        InnerClassNode icn = this.cn.innerClasses.get(0);
        Assert.assertEquals((Object)name, (Object)icn.name);
        Assert.assertEquals((Object)outerName, (Object)icn.outerName);
        Assert.assertEquals((Object)innerName, (Object)icn.innerName);
        Assert.assertEquals((long)access, (long)icn.access);
    }

    @Test
    public void testVisitMethod() {
        int access = 1;
        String name = "name";
        String desc = "I";
        Object[] signature = new String[]{"sig1", "sig2"};
        Object[] exceptions = new String[]{"exc1", "exc2"};
        this.cn.visitMethod(access, name, desc, (String[])signature, (String[])exceptions);
        MethodNode mn = this.cn.methods.get(0);
        Assert.assertEquals((long)access, (long)mn.access);
        Assert.assertEquals((Object)name, (Object)mn.name);
        Assert.assertEquals((Object)desc, (Object)mn.desc);
        Assert.assertArrayEquals((Object[])signature, (Object[])mn.signature);
        Assert.assertArrayEquals((Object[])exceptions, (Object[])mn.exceptions.toArray());
    }

    @Test
    public void testVisitOuterClass() {
        String owner = "owner";
        String name = "name";
        String desc = "I";
        this.cn.visitOuterClass(owner, name, desc);
        Assert.assertEquals((Object)owner, (Object)this.cn.outerClass);
        Assert.assertEquals((Object)name, (Object)this.cn.outerMethod);
        Assert.assertEquals((Object)desc, (Object)this.cn.outerMethodDesc);
    }

    @Test
    public void testVisitSource() {
        String source = "sourceFile";
        this.cn.visitSource(source, null);
        Assert.assertEquals((Object)source, (Object)this.cn.sourceFile);
    }
}

