/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asmdex;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import org.junit.Assert;
import org.junit.Test;
import org.objectweb.asmdex.TestUtil;
import org.ow2.asmdex.ApplicationReader;
import org.ow2.asmdex.util.AsmDexifierApplicationVisitor;

public class AsmDexifierTest {
    private static boolean SHOW_MESSAGES = true;

    @Test
    public void testAsmDexifier() throws Exception {
        boolean result = true;
        File testCaseFolder = new File("test/case/full/");
        result = this.testAsmDexifierFolder(testCaseFolder, false);
        testCaseFolder = new File("test/case/skipLineNumbers/");
        Assert.assertTrue((String)"Generated dex files aren't equal to the ones from dx.", (boolean)(result &= this.testAsmDexifierFolder(testCaseFolder, true)));
    }

    private boolean testAsmDexifierFolder(File folder, boolean skipLineNumbers) throws Exception {
        boolean result = true;
        File[] fileArray = folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File dexFile = fileArray[n2];
            String dexFileName = dexFile.getName();
            if (dexFileName.toLowerCase().endsWith(".dex")) {
                if (SHOW_MESSAGES) {
                    System.out.print("AsmDexifier test with " + dexFileName + ". ");
                }
                result = AsmDexifierTest.testDexFile(dexFile, skipLineNumbers);
                Assert.assertTrue((String)("Dex file isn't equal : " + dexFileName), (boolean)result);
            }
            ++n2;
        }
        return result;
    }

    private static boolean testDexFile(File dexFile, boolean skipLineNumbers) throws Exception {
        TestUtil.removeTemporaryFolder();
        TestUtil.createTemporaryFolders(new String[]{"test/", "conform/"});
        FileOutputStream out = new FileOutputStream("tmpAsmDexTest/test/conform/TestDump.java");
        String packageStr = "test/conform/";
        packageStr = packageStr.replace('/', '.');
        packageStr = packageStr.substring(0, packageStr.length() - 1);
        AsmDexifierApplicationVisitor ad = new AsmDexifierApplicationVisitor(262144, new PrintWriter(out), packageStr, "tmpAsmDexTest/");
        AsmDexifierApplicationVisitor.setDexFileName("Test");
        ApplicationReader ar = new ApplicationReader(262144, dexFile);
        ar.accept(ad, null, 0);
        if (SHOW_MESSAGES) {
            System.out.print("Compiling... ");
        }
        Process p = Runtime.getRuntime().exec("javac -sourcepath src -d tmpAsmDexTest/ tmpAsmDexTest/test/conform/TestDump.java");
        try {
            p.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        int result = p.exitValue();
        if (result != 0) {
            System.err.println("Exit value = " + p.exitValue());
            System.err.println(TestUtil.getStringFromStream(p.getErrorStream()));
            return false;
        }
        if (SHOW_MESSAGES) {
            System.out.print("Running... ");
        }
        p = Runtime.getRuntime().exec("java -classpath tmpAsmDexTest/ test/conform/TestDump tmpAsmDexTest/generated.dex");
        try {
            p.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        result = p.exitValue();
        if (result != 0) {
            System.err.println("Exit value = " + result);
            System.err.println(TestUtil.getStringFromStream(p.getErrorStream()));
            return false;
        }
        File createdDexFile = new File("tmpAsmDexTest/generated.dex");
        Assert.assertTrue((String)"Unequal Map between the original and the generated file.", (boolean)TestUtil.testMapDexFiles(createdDexFile, dexFile));
        TestUtil.baksmali(new String[]{dexFile.getAbsolutePath(), "-otmpAsmDexTest/expected/"});
        TestUtil.baksmali(new String[]{"tmpAsmDexTest/generated.dex", "-otmpAsmDexTest/generated/"});
        boolean areFolderIdentical = TestUtil.testSmaliFoldersEquality("tmpAsmDexTest/generated/", "tmpAsmDexTest/expected/", skipLineNumbers);
        TestUtil.removeTemporaryFolder();
        if (areFolderIdentical && SHOW_MESSAGES) {
            System.out.println("OK!");
        }
        return areFolderIdentical;
    }
}

