/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asmdex;

import java.io.File;
import java.io.IOException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.objectweb.asmdex.TestUtil;
import org.ow2.asmdex.ApplicationReader;
import org.ow2.asmdex.ApplicationWriter;
import org.ow2.asmdex.tree.ApplicationNode;

public class ApplicationWriterTreeTest {
    @AfterClass
    public static void testAfter() {
        TestUtil.removeTemporaryFolder();
    }

    @Test
    public void testApplicationWriter() {
        new ApplicationWriter();
    }

    @Test
    public void testToByteArray() throws IOException {
        File testCaseFolder = new File("test/case/full/");
        boolean result = this.testGenerationToByteArray(testCaseFolder, false);
        testCaseFolder = new File("test/case/skipLineNumbers/");
        Assert.assertTrue((String)"Generated dex files aren't equal to the ones from dx.", (boolean)(result &= this.testGenerationToByteArray(testCaseFolder, true)));
    }

    private boolean testGenerationToByteArray(File folder, boolean skipLineNumbers) throws IOException {
        boolean areFolderIdentical = true;
        File[] fileArray = folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File dexFile = fileArray[n2];
            String dexFileName = dexFile.getName();
            if (dexFileName.toLowerCase().endsWith(".dex")) {
                String fullDexFileName = String.valueOf(folder.getPath()) + "/" + dexFileName;
                TestUtil.removeTemporaryFolder();
                TestUtil.baksmali(new String[]{fullDexFileName, "-otmpAsmDexTest/expected/"});
                ApplicationReader ar = new ApplicationReader(262144, fullDexFileName);
                ApplicationNode an = new ApplicationNode(262144);
                ar.accept(an, 0);
                ApplicationWriter aw = new ApplicationWriter();
                an.accept(aw);
                byte[] generatedDexFile = aw.toByteArray();
                String fullGeneratedDexFileName = "tmpAsmDexTest/generated.dex";
                File createdDexFile = TestUtil.createFileFromByteArray(generatedDexFile, fullGeneratedDexFileName);
                Assert.assertTrue((String)("Unequal Map between " + dexFileName + " and the generated file."), (boolean)TestUtil.testMapDexFiles(createdDexFile, dexFile));
                TestUtil.baksmali(new String[]{fullGeneratedDexFileName, "-otmpAsmDexTest/generated/"});
                areFolderIdentical = TestUtil.testSmaliFoldersEquality("tmpAsmDexTest/generated/", "tmpAsmDexTest/expected/", skipLineNumbers);
                Assert.assertTrue((String)"Generated .smali files differ.", (boolean)areFolderIdentical);
                TestUtil.removeTemporaryFolder();
            }
            ++n2;
        }
        return areFolderIdentical;
    }
}

