/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asmdex;

import java.io.File;
import java.io.IOException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.objectweb.asmdex.TestUtil;
import org.objectweb.asmdex.applicationAdapterTest.ApplicationAdapterAddCode;
import org.objectweb.asmdex.applicationAdapterTest.ApplicationAdapterAddMethod;
import org.objectweb.asmdex.applicationAdapterTest.ApplicationAdapterAddSwitchCase;
import org.objectweb.asmdex.applicationAdapterTest.ApplicationAdapterRemoveMethod;
import org.objectweb.asmdex.applicationAdapterTest.ApplicationAdapterResizeGoto8Bits;
import org.objectweb.asmdex.applicationAdapterTest.ApplicationAdapterResizeGoto8BitsDoubleRefs;
import org.objectweb.asmdex.applicationAdapterTest.ApplicationAdapterResizeGoto8BitsDoubleRefsDoubleLabels;
import org.objectweb.asmdex.applicationAdapterTest.ApplicationAdapterShiftSwitchCase;
import org.objectweb.asmdex.applicationAdapterTest.GenerateBasicDexFile;
import org.objectweb.asmdex.applicationAdapterTest.GenerateDexFileShiftedSwitchCase;
import org.objectweb.asmdex.applicationAdapterTest.GenerateDexFileSwitchCase;
import org.objectweb.asmdex.applicationAdapterTest.GenerateExpectedDexFileAddAndRemoveMethod;
import org.objectweb.asmdex.applicationAdapterTest.GenerateExpectedDexFileAddCode;
import org.objectweb.asmdex.applicationAdapterTest.GenerateExpectedDexFileAddMethod;
import org.objectweb.asmdex.applicationAdapterTest.GenerateExpectedDexFileRemoveMethod;
import org.objectweb.asmdex.applicationAdapterTest.GenerateExpectedDexFileResizeGoto8Bits;
import org.objectweb.asmdex.applicationAdapterTest.GenerateExpectedDexFileResizeGoto8BitsDoubleRefs;
import org.objectweb.asmdex.applicationAdapterTest.GenerateExpectedDexFileResizeGoto8BitsDoubleRefsDoubleLabels;
import org.objectweb.asmdex.applicationAdapterTest.GenerateOriginalDexFileResizeGoto8Bits;
import org.objectweb.asmdex.applicationAdapterTest.GenerateOriginalDexFileResizeGoto8BitsDoubleRefs;
import org.objectweb.asmdex.applicationAdapterTest.GenerateOriginalDexFileResizeGoto8BitsDoubleRefsDoubleLabels;
import org.ow2.asmdex.ApplicationReader;
import org.ow2.asmdex.ApplicationVisitor;
import org.ow2.asmdex.ApplicationWriter;

public class ApplicationAdapterTest {
    @Before
    public void initializeAdapterTest() {
        TestUtil.removeTemporaryFolder();
        TestUtil.createTemporaryFolder();
    }

    @After
    public void endAdapterTest() {
        TestUtil.removeTemporaryFolder();
    }

    @Test
    public void testAdapterDoNothing() throws IOException {
        byte[] originalBytes = GenerateBasicDexFile.generate();
        ApplicationWriter aw = new ApplicationWriter();
        ApplicationReader ar = new ApplicationReader(262144, originalBytes);
        ApplicationVisitor aa = new ApplicationVisitor(262144, aw){};
        ar.accept(aa, 0);
        Assert.assertTrue((boolean)this.testAdapter(aw.toByteArray(), originalBytes));
    }

    @Test
    public void testAdapterSimpleAddInstructions() throws IOException {
        byte[] originalBytes = GenerateBasicDexFile.generate();
        byte[] expectedBytes = GenerateExpectedDexFileAddCode.generate();
        ApplicationWriter aw = new ApplicationWriter();
        ApplicationReader ar = new ApplicationReader(262144, originalBytes);
        ApplicationAdapterAddCode aa = new ApplicationAdapterAddCode(aw);
        ar.accept(aa, 0);
        Assert.assertTrue((boolean)this.testAdapter(aw.toByteArray(), expectedBytes));
    }

    @Test
    public void testAdapterResizeGoto8Bits() throws IOException {
        byte[] originalBytes = GenerateOriginalDexFileResizeGoto8Bits.generate();
        byte[] expectedBytes = GenerateExpectedDexFileResizeGoto8Bits.generate();
        ApplicationWriter aw = new ApplicationWriter();
        ApplicationReader ar = new ApplicationReader(262144, originalBytes);
        ApplicationAdapterResizeGoto8Bits aa = new ApplicationAdapterResizeGoto8Bits(aw);
        ar.accept(aa, 0);
        Assert.assertTrue((boolean)this.testAdapter(aw.toByteArray(), expectedBytes));
    }

    @Test
    public void testAdapterResizeGoto8BitsDoubleRefs() throws IOException {
        byte[] originalBytes = GenerateOriginalDexFileResizeGoto8BitsDoubleRefs.generate();
        byte[] expectedBytes = GenerateExpectedDexFileResizeGoto8BitsDoubleRefs.generate();
        ApplicationWriter aw = new ApplicationWriter();
        ApplicationReader ar = new ApplicationReader(262144, originalBytes);
        ApplicationAdapterResizeGoto8BitsDoubleRefs aa = new ApplicationAdapterResizeGoto8BitsDoubleRefs(aw);
        ar.accept(aa, 0);
        Assert.assertTrue((boolean)this.testAdapter(aw.toByteArray(), expectedBytes));
    }

    @Test
    public void testAdapterResizeGoto8BitsDoubleRefsDoubleLabels() throws IOException {
        byte[] originalBytes = GenerateOriginalDexFileResizeGoto8BitsDoubleRefsDoubleLabels.generate();
        byte[] expectedBytes = GenerateExpectedDexFileResizeGoto8BitsDoubleRefsDoubleLabels.generate();
        ApplicationWriter aw = new ApplicationWriter();
        ApplicationReader ar = new ApplicationReader(262144, originalBytes);
        ApplicationAdapterResizeGoto8BitsDoubleRefsDoubleLabels aa = new ApplicationAdapterResizeGoto8BitsDoubleRefsDoubleLabels(aw);
        ar.accept(aa, 0);
        Assert.assertTrue((boolean)this.testAdapter(aw.toByteArray(), expectedBytes));
    }

    @Test
    public void testAdapterRemoveMethod() throws IOException {
        byte[] originalBytes = GenerateBasicDexFile.generate();
        byte[] expectedBytes = GenerateExpectedDexFileRemoveMethod.generate();
        ApplicationWriter aw = new ApplicationWriter();
        ApplicationReader ar = new ApplicationReader(262144, originalBytes);
        ApplicationAdapterRemoveMethod aa = new ApplicationAdapterRemoveMethod(aw);
        ar.accept(aa, 0);
        Assert.assertTrue((boolean)this.testAdapter(aw.toByteArray(), expectedBytes));
    }

    @Test
    public void testAdapterAddMethod() throws IOException {
        byte[] originalBytes = GenerateBasicDexFile.generate();
        byte[] expectedBytes = GenerateExpectedDexFileAddMethod.generate();
        ApplicationWriter aw = new ApplicationWriter();
        ApplicationReader ar = new ApplicationReader(262144, originalBytes);
        ApplicationAdapterAddMethod aa = new ApplicationAdapterAddMethod(aw);
        ar.accept(aa, 0);
        Assert.assertTrue((boolean)this.testAdapter(aw.toByteArray(), expectedBytes));
    }

    @Test
    public void testAdapterAddAndRemoveMethod() throws IOException {
        byte[] originalBytes = GenerateBasicDexFile.generate();
        byte[] expectedBytes = GenerateExpectedDexFileAddAndRemoveMethod.generate();
        ApplicationWriter aw = new ApplicationWriter();
        ApplicationReader ar = new ApplicationReader(262144, originalBytes);
        ApplicationAdapterRemoveMethod aa2 = new ApplicationAdapterRemoveMethod(aw);
        ApplicationAdapterAddMethod aa1 = new ApplicationAdapterAddMethod(aa2);
        ar.accept(aa1, 0);
        Assert.assertTrue((boolean)this.testAdapter(aw.toByteArray(), expectedBytes));
    }

    @Test
    public void testAdapterAddSwitchCase() throws IOException {
        byte[] originalBytes = GenerateBasicDexFile.generate();
        byte[] expectedBytes = GenerateDexFileSwitchCase.generate();
        ApplicationWriter aw = new ApplicationWriter();
        ApplicationReader ar = new ApplicationReader(262144, originalBytes);
        ApplicationAdapterAddSwitchCase aa = new ApplicationAdapterAddSwitchCase(aw);
        ar.accept(aa, 0);
        Assert.assertTrue((boolean)this.testAdapter(aw.toByteArray(), expectedBytes));
    }

    @Test
    public void testAdapterShiftSwitchCase() throws IOException {
        byte[] originalBytes = GenerateDexFileSwitchCase.generate();
        byte[] expectedBytes = GenerateDexFileShiftedSwitchCase.generate();
        ApplicationWriter aw = new ApplicationWriter();
        ApplicationReader ar = new ApplicationReader(262144, originalBytes);
        ApplicationAdapterShiftSwitchCase aa = new ApplicationAdapterShiftSwitchCase(aw);
        ar.accept(aa, 0);
        Assert.assertTrue((boolean)this.testAdapter(aw.toByteArray(), expectedBytes));
    }

    private boolean testAdapter(byte[] adapterBytes, byte[] expectedBytes) throws IOException {
        File adaptedFile = TestUtil.createFileFromByteArray(adapterBytes, "tmpAsmDexTest/adapted.dex");
        TestUtil.baksmali(new String[]{adaptedFile.getAbsolutePath(), "-otmpAsmDexTest/generated/"});
        File expectedFile = TestUtil.createFileFromByteArray(expectedBytes, "tmpAsmDexTest/expected.dex");
        TestUtil.baksmali(new String[]{expectedFile.getAbsolutePath(), "-otmpAsmDexTest/expected/"});
        boolean result = TestUtil.testSmaliFoldersEquality("tmpAsmDexTest/generated/", "tmpAsmDexTest/expected/", false);
        return result;
    }
}

