/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2;

import com.google.common.collect.Maps;
import com.google.common.collect.RangeMap;
import java.util.EnumMap;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.VersionMap;

public class Opcodes {
    public final int api;
    public final int artVersion;
    @Nonnull
    private final Opcode[] opcodesByValue = new Opcode[255];
    @Nonnull
    private final EnumMap<Opcode, Short> opcodeValues;
    @Nonnull
    private final HashMap<String, Opcode> opcodesByName;

    @Nonnull
    public static Opcodes forApi(int api) {
        return new Opcodes(api, VersionMap.mapApiToArtVersion(api), false);
    }

    @Nonnull
    public static Opcodes forApi(int api, boolean experimental) {
        return new Opcodes(api, VersionMap.mapApiToArtVersion(api), experimental);
    }

    @Nonnull
    public static Opcodes forArtVersion(int artVersion) {
        return Opcodes.forArtVersion(artVersion, false);
    }

    @Nonnull
    public static Opcodes forArtVersion(int artVersion, boolean experimental) {
        return new Opcodes(VersionMap.mapArtVersionToApi(artVersion), artVersion, experimental);
    }

    @Deprecated
    public Opcodes(int api) {
        this(api, false);
    }

    @Deprecated
    public Opcodes(int api, boolean experimental) {
        this(api, VersionMap.mapApiToArtVersion(api), experimental);
    }

    private Opcodes(int api, int artVersion, boolean experimental) {
        this.api = api;
        this.artVersion = artVersion;
        this.opcodeValues = new EnumMap(Opcode.class);
        this.opcodesByName = Maps.newHashMap();
        int version = this.isArt() ? artVersion : api;
        for (Opcode opcode : Opcode.values()) {
            RangeMap<Integer, Short> versionToValueMap = this.isArt() ? opcode.artVersionToValueMap : opcode.apiToValueMap;
            Short opcodeValue = versionToValueMap.get(version);
            if (opcodeValue == null || opcode.isExperimental() && !experimental) continue;
            if (!opcode.format.isPayloadFormat) {
                this.opcodesByValue[opcodeValue.shortValue()] = opcode;
            }
            this.opcodeValues.put(opcode, opcodeValue);
            this.opcodesByName.put(opcode.name.toLowerCase(), opcode);
        }
    }

    @Nullable
    public Opcode getOpcodeByName(@Nonnull String opcodeName) {
        return this.opcodesByName.get(opcodeName.toLowerCase());
    }

    @Nullable
    public Opcode getOpcodeByValue(int opcodeValue) {
        switch (opcodeValue) {
            case 256: {
                return Opcode.PACKED_SWITCH_PAYLOAD;
            }
            case 512: {
                return Opcode.SPARSE_SWITCH_PAYLOAD;
            }
            case 768: {
                return Opcode.ARRAY_PAYLOAD;
            }
        }
        if (opcodeValue >= 0 && opcodeValue < this.opcodesByValue.length) {
            return this.opcodesByValue[opcodeValue];
        }
        return null;
    }

    @Nullable
    public Short getOpcodeValue(@Nonnull Opcode opcode) {
        return this.opcodeValues.get((Object)opcode);
    }

    public boolean isArt() {
        return this.artVersion != -1;
    }
}

