/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.binutils.hex.util;

import java.io.IOException;
import java.io.Reader;
import java.nio.ByteOrder;
import nl.lxtreme.binutils.hex.util.ByteOrderUtils;

public final class HexUtils {
    private HexUtils() {
    }

    public static int parseHexByte(char[] cArray) throws IllegalArgumentException {
        if (cArray == null) {
            throw new IllegalArgumentException("Input cannot be null!");
        }
        return HexUtils.parseHexByte(new String(cArray), 0);
    }

    public static int parseHexByte(CharSequence charSequence, int n) throws IllegalArgumentException {
        if (charSequence == null) {
            throw new IllegalArgumentException("Input cannot be null!");
        }
        try {
            return Integer.parseInt(charSequence.subSequence(n, n + 2).toString(), 16);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("No such offset: " + n + "; length = " + charSequence.length());
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Not a hex-digit string: " + charSequence);
        }
    }

    public static int parseHexByte(Reader reader) throws IllegalArgumentException, IOException {
        return HexUtils.parseHexNumber(reader, 1);
    }

    public static int[] parseHexBytes(CharSequence charSequence, int n, int n2) throws IllegalArgumentException {
        if (charSequence == null) {
            throw new IllegalArgumentException("Input cannot be null!");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Byte count cannot be less than one!");
        }
        try {
            int[] nArray = new int[n2];
            int n3 = n;
            int n4 = 0;
            while (n4 < n2) {
                nArray[n4] = Integer.parseInt(charSequence.subSequence(n3, n3 + 2).toString(), 16);
                ++n4;
                n3 += 2;
            }
            return nArray;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("No such offset: " + n + "; length = " + charSequence.length());
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Not a hex-digit string!");
        }
    }

    public static int parseHexNumber(CharSequence charSequence, int n, int n2) throws IllegalArgumentException {
        if (charSequence == null) {
            throw new IllegalArgumentException("Input cannot be null!");
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("Byte count cannot be less than one!");
        }
        int[] nArray = HexUtils.parseHexBytes(charSequence, n, n2);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 |= nArray[i];
            if (i >= n2 - 1) continue;
            n3 <<= 8;
        }
        return n3;
    }

    public static int parseHexNumber(Reader reader, int n) throws IllegalArgumentException, IOException {
        if (reader == null) {
            throw new IllegalArgumentException("Input cannot be null!");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("Byte count cannot be less or equal to zero!");
        }
        char[] cArray = new char[2 * n];
        if (reader.read(cArray) != cArray.length) {
            throw new IOException("Unexpected end-of-stream?!");
        }
        int n2 = 0;
        for (char c : cArray) {
            int n3 = Character.digit(c, 16);
            if (n3 < 0) {
                throw new IOException("Unexpected character: " + c);
            }
            n2 *= 16;
            n2 |= n3;
        }
        return n2;
    }

    public static int parseHexWord(char[] cArray) throws IllegalArgumentException {
        if (cArray == null) {
            throw new IllegalArgumentException("Input cannot be null!");
        }
        return HexUtils.parseHexWord(new String(cArray), 0);
    }

    public static int parseHexWord(CharSequence charSequence, int n) throws IllegalArgumentException {
        if (charSequence == null) {
            throw new IllegalArgumentException("Input cannot be null!");
        }
        try {
            int n2 = Integer.parseInt(charSequence.subSequence(n + 0, n + 2).toString(), 16);
            int n3 = Integer.parseInt(charSequence.subSequence(n + 2, n + 4).toString(), 16);
            return ByteOrderUtils.createWord(ByteOrder.BIG_ENDIAN, n2, n3);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("No such offset: " + n + "; length = " + charSequence.length());
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Not a hex-digit string!");
        }
    }

    public static int parseHexWord(Reader reader) throws IllegalArgumentException, IOException {
        return HexUtils.parseHexNumber(reader, 2);
    }
}

