/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.binutils.hex.util;

import java.nio.ByteOrder;

public class ByteOrderUtils {
    private ByteOrderUtils() {
    }

    public static int createWord(ByteOrder byteOrder, int n, int n2) {
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            return n << 8 & 0xFF00 | n2 & 0xFF;
        }
        return n2 << 8 & 0xFF00 | n & 0xFF;
    }

    public static int createWord(int n, int n2) {
        return ByteOrderUtils.createWord(ByteOrder.nativeOrder(), n, n2);
    }

    public static long decode(ByteOrder byteOrder, byte ... byArray) {
        long l;
        block3: {
            block2: {
                int n = byArray.length;
                int n2 = n - 1;
                l = 0L;
                if (byteOrder != ByteOrder.BIG_ENDIAN) break block2;
                for (int i = 0; i < n; ++i) {
                    l <<= 8;
                    l |= (long)(byArray[i] & 0xFF);
                }
                break block3;
            }
            if (byteOrder != ByteOrder.LITTLE_ENDIAN) break block3;
            for (int i = n2; i >= 0; --i) {
                l <<= 8;
                l |= (long)(byArray[i] & 0xFF);
            }
        }
        return l;
    }

    public static int swap16(int n) {
        return (n & 0xFF) << 8 | (n & 0xFF00) >> 8;
    }

    public static int swap32(int n) {
        return (n & 0xFF) << 24 | (n & 0xFF00) << 8 | (n & 0xFF000000) >>> 24 | (n & 0xFF0000) >>> 8;
    }
}

