/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.binutils.hex;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.ByteOrder;
import nl.lxtreme.binutils.hex.util.ByteOrderUtils;

public abstract class AbstractReader {
    protected final Reader reader;

    public AbstractReader(Reader reader) {
        this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public abstract long getAddress() throws IOException;

    public void mark() throws IOException {
        this.reader.mark(1024);
    }

    public abstract int readByte() throws IOException;

    public int readLongWord() throws IOException {
        byte[] byArray = this.readBytes(4);
        if (byArray == null) {
            return -1;
        }
        return (int)ByteOrderUtils.decode(this.getByteOrder(), byArray);
    }

    public int readWord() throws IOException {
        byte[] byArray = this.readBytes(2);
        if (byArray == null) {
            return -1;
        }
        return (int)ByteOrderUtils.decode(ByteOrder.LITTLE_ENDIAN, byArray);
    }

    public void reset() throws IOException {
        this.reader.reset();
    }

    protected abstract ByteOrder getByteOrder();

    protected final byte[] readBytes(int n) throws IOException, IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException("Count cannot be less or equal to zero!");
        }
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            int n2 = this.readByte();
            if (n2 == -1) {
                return null;
            }
            byArray[i] = (byte)n2;
        }
        return byArray;
    }

    protected final char[] readChars(int n) throws IOException, IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid count!");
        }
        char[] cArray = new char[n];
        if (this.reader.read(cArray) != n) {
            throw new IOException("Unexpected end of stream!");
        }
        return cArray;
    }

    protected final int readSingleByte() throws IOException {
        int n;
        while ((n = this.reader.read()) != -1 && Character.isWhitespace(n)) {
        }
        return n;
    }
}

