/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.binutils.elf;

public class SegmentType {
    public static final SegmentType NULL = new SegmentType(0, "Program header table entry unused");
    public static final SegmentType LOAD = new SegmentType(1, "Loadable program segment");
    public static final SegmentType DYNAMIC = new SegmentType(2, "Dynamic linking information");
    public static final SegmentType INTERP = new SegmentType(3, "Program interpreter");
    public static final SegmentType NOTE = new SegmentType(4, "Auxiliary information");
    public static final SegmentType SHLIB = new SegmentType(5, "Reserved");
    public static final SegmentType PHDR = new SegmentType(6, "Entry for header table itself");
    public static final SegmentType TLS = new SegmentType(7, "Thread-local storage segment");
    public static final SegmentType GNU_EH_FRAME = new SegmentType(1685382480, "GCC .eh_frame_hdr segment");
    public static final SegmentType GNU_STACK = new SegmentType(1685382481, "Stack executability");
    public static final SegmentType GNU_RELRO = new SegmentType(1685382482, "Read-only after relocation");
    public static final SegmentType SUNWBSS = new SegmentType(0x6FFFFFFA, "Sun Specific segment");
    public static final SegmentType SUNWSTACK = new SegmentType(0x6FFFFFFB, "Sun Stack segment");
    public static final SegmentType[] VALUES = new SegmentType[]{NULL, LOAD, DYNAMIC, INTERP, NOTE, SHLIB, PHDR, TLS, GNU_EH_FRAME, GNU_STACK, GNU_RELRO, SUNWBSS, SUNWSTACK};
    private static final int PT_LOOS = 0x60000000;
    private static final int PT_HIOS = 0x6FFFFFFF;
    private static final int PT_LOPROC = 0x70000000;
    private static final int PT_HIPROC = Integer.MAX_VALUE;
    private final int no;
    private final String desc;

    private SegmentType(int n, String string) {
        this.no = n;
        this.desc = string;
    }

    public static SegmentType valueOf(int n) {
        for (SegmentType segmentType : VALUES) {
            if (segmentType.no != n) continue;
            return segmentType;
        }
        if (n >= 0x60000000 && n <= 0x6FFFFFFF) {
            return new SegmentType(n, "OS-specific segment");
        }
        if (n >= 0x70000000 && n <= Integer.MAX_VALUE) {
            return new SegmentType(n, "Processor-specific segment");
        }
        throw new IllegalArgumentException("Invalid segment type!");
    }

    public int ordinal() {
        return this.no;
    }

    public String name() {
        return this.desc;
    }

    public String toString() {
        return this.desc;
    }
}

