/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.binutils.elf;

public class SectionType {
    public static final SectionType NULL = new SectionType(0, "Section header table entry unused");
    public static final SectionType PROGBITS = new SectionType(1, "Program data");
    public static final SectionType SYMTAB = new SectionType(2, "Symbol table");
    public static final SectionType STRTAB = new SectionType(3, "String table");
    public static final SectionType RELA = new SectionType(4, "Relocation entries with addends");
    public static final SectionType HASH = new SectionType(5, "Symbol hash table");
    public static final SectionType DYNAMIC = new SectionType(6, "Dynamic linking information");
    public static final SectionType NOTE = new SectionType(7, "Notes");
    public static final SectionType NOBITS = new SectionType(8, "Program space with no data (bss)");
    public static final SectionType REL = new SectionType(9, "Relocation entries, no addends");
    public static final SectionType SHLIB = new SectionType(10, "Reserved");
    public static final SectionType DYNSYM = new SectionType(11, "Thread-local storage segment");
    public static final SectionType INIT_ARRAY = new SectionType(14, "Array of constructors");
    public static final SectionType FINI_ARRAY = new SectionType(15, "Array of destructors");
    public static final SectionType PREINIT_ARRAY = new SectionType(16, "Array of pre-constructors");
    public static final SectionType GROUP = new SectionType(17, "Section group");
    public static final SectionType SYMTAB_SHNDX = new SectionType(18, "Extended section indeces");
    public static final SectionType GNU_ATTRIBUTES = new SectionType(0x6FFFFFF5, "GNU object attributes");
    public static final SectionType GNU_HASH = new SectionType(0x6FFFFFF6, "GNU-style hash table");
    public static final SectionType GNU_LIBLIST = new SectionType(0x6FFFFFF7, "GNU Prelink library list");
    public static final SectionType CHECKSUM = new SectionType(0x6FFFFFF8, "Checksum for DSO content");
    public static final SectionType SUNW_MOVE = new SectionType(0x6FFFFFFA, "SUNW_MOVE");
    public static final SectionType SUNW_COMDAT = new SectionType(0x6FFFFFFB, "SUNW_COMDAT");
    public static final SectionType SUNW_SYMINFO = new SectionType(0x6FFFFFFC, "SUNW_SYMINFO");
    public static final SectionType GNU_VERDEF = new SectionType(0x6FFFFFFD, "GNU version definition section");
    public static final SectionType GNU_VERNEED = new SectionType(0x6FFFFFFE, "GNU version needs section");
    public static final SectionType GNU_VERSYM = new SectionType(0x6FFFFFFF, "GNU version symbol table");
    private static final SectionType[] VALUES = new SectionType[]{NULL, PROGBITS, SYMTAB, STRTAB, RELA, HASH, DYNAMIC, NOTE, NOBITS, REL, SHLIB, DYNSYM, INIT_ARRAY, FINI_ARRAY, PREINIT_ARRAY, GROUP, SYMTAB_SHNDX, GNU_ATTRIBUTES, GNU_HASH, GNU_LIBLIST, CHECKSUM, SUNW_MOVE, SUNW_COMDAT, SUNW_SYMINFO, GNU_VERDEF, GNU_VERNEED, GNU_VERSYM};
    private static final int SHT_LOOS = 0x60000000;
    private static final int SHT_HIOS = 0x6FFFFFFF;
    private static final int SHT_LOPROC = 0x70000000;
    private static final int SHT_HIPROC = Integer.MAX_VALUE;
    private static final int SHT_LOUSER = 0x70000000;
    private static final int SHT_HIUSER = Integer.MAX_VALUE;
    private final int no;
    private final String desc;

    public static SectionType valueOf(int n) {
        for (SectionType sectionType : VALUES) {
            if (sectionType.no != n) continue;
            return sectionType;
        }
        if (n >= 0x60000000 && n <= 0x6FFFFFFF) {
            return new SectionType(n, "OS-specific segment");
        }
        if (n >= 0x70000000 && n <= Integer.MAX_VALUE) {
            return new SectionType(n, "Processor-specific segment");
        }
        if (n >= 0x70000000 && n <= Integer.MAX_VALUE) {
            return new SectionType(n, "User-specific segment");
        }
        throw new IllegalArgumentException("Invalid segment type!");
    }

    private SectionType(int n, String string) {
        this.no = n;
        this.desc = string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SectionType sectionType = (SectionType)object;
        return this.no == sectionType.no;
    }

    public int hashCode() {
        return 37 + this.no;
    }

    public String name() {
        return this.desc;
    }

    public int ordinal() {
        return this.no;
    }

    public String toString() {
        return this.desc;
    }
}

