/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.binutils.coff;

import java.io.IOException;
import java.nio.ByteBuffer;
import nl.lxtreme.binutils.coff.CoffMagic;

public class OptionalHeader {
    public final CoffMagic magic;
    public final int versionStamp;
    public final int textSize;
    public final int initDataSize;
    public final int uninitDataSize;
    public final int entryPoint;
    public final int textStart;
    public final int dataStart;

    public OptionalHeader(ByteBuffer byteBuffer) throws IOException {
        this.magic = CoffMagic.valueOf(byteBuffer.getShort());
        this.versionStamp = byteBuffer.getShort();
        this.textSize = byteBuffer.getInt();
        this.initDataSize = byteBuffer.getInt();
        this.uninitDataSize = byteBuffer.getInt();
        this.entryPoint = byteBuffer.getInt();
        this.textStart = byteBuffer.getInt();
        this.dataStart = byteBuffer.hasRemaining() ? byteBuffer.getInt() : -1;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((Object)this.magic);
        stringBuilder.append(", entry point: 0x").append(Integer.toHexString(this.entryPoint));
        stringBuilder.append(", code start: 0x").append(Integer.toHexString(this.textStart));
        stringBuilder.append(", code size: ").append(this.textSize);
        stringBuilder.append(", data start: 0x").append(Integer.toHexString(this.dataStart));
        stringBuilder.append(", data size: ").append(this.initDataSize).append("+").append(this.uninitDataSize);
        return stringBuilder.toString();
    }
}

