/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.binutils.coff;

public enum MachineType {
    UNKNOWN(0, "Unknown"),
    ALPHA(388, "Alpha AXP"),
    ARM(448, "ARM"),
    ALPHA64(644, "Alpha AXP-64"),
    I386(332, "i386 compatible"),
    IA64(512, "Intel IA64"),
    M68K(616, "m68k"),
    MIPS16(614, "MIPS-16"),
    MIPS_FPU(870, "MIPS with FPU"),
    MIPS_FPU16(1126, "MIPS-16 with FPU"),
    POWERPC(496, "PowerPC little-endian"),
    R3000(354, "MIPS R3000 little-endian"),
    R4000(358, "MIPS R4000 little-endian"),
    R10000(360, "MIPS R10000 little-endian"),
    SH3(418, "Hitachi SH3"),
    SH4(422, "Hitachi SH4"),
    THUMB(450, "ARM thumb");

    private final int no;
    private final String desc;

    private MachineType(int n2, String string2) {
        this.no = n2;
        this.desc = string2;
    }

    static MachineType valueOf(int n) {
        for (MachineType machineType : MachineType.values()) {
            if (machineType.no != n) continue;
            return machineType;
        }
        throw new IllegalArgumentException("Invalid machine type: " + n);
    }

    public String toString() {
        return this.desc;
    }
}

