/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.binutils.coff;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import nl.lxtreme.binutils.coff.Coff;
import nl.lxtreme.binutils.coff.MachineType;

public class FileHeader {
    public static final int F_RELFLG = 1;
    public static final int F_EXEC = 2;
    public static final int F_LNNO = 4;
    public static final int F_LSYMS = 8;
    public static final int F_AGGRESSIVE_WS_TRIM = 16;
    public static final int F_LARGE_ADDRESS_AWARE = 32;
    public static final int F_FILE_16BIT_MACHINE = 64;
    public static final int F_AR16WR = 128;
    public static final int F_AR32WR = 256;
    public static final int F_AR32W = 512;
    public static final int F_REMOVABLE_RUN_FROM_SWAP = 1024;
    public static final int F_DYNLOAD = 4096;
    public static final int F_SHROBJ = 8192;
    public static final int F_UP_SYSTEM_ONLY = 16384;
    public static final int F_AR32BE = 32768;
    public final MachineType machineType;
    public final int sectionCount;
    public final long timestamp;
    public final long symbolFilePtr;
    public final int symbolCount;
    public final int optionalHeaderSize;
    public final int flags;

    public FileHeader(FileChannel fileChannel) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(20);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        Coff.readFully(fileChannel, byteBuffer, "Unable to read file header!");
        this.machineType = MachineType.valueOf(byteBuffer.getShort());
        this.sectionCount = byteBuffer.getShort();
        this.timestamp = byteBuffer.getInt();
        this.symbolFilePtr = byteBuffer.getInt();
        this.symbolCount = byteBuffer.getInt();
        this.optionalHeaderSize = byteBuffer.getShort();
        this.flags = byteBuffer.getShort();
    }

    public boolean isStripped() {
        return this.symbolFilePtr == 0L && this.symbolCount == 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((Object)this.machineType);
        if (this.timestamp != 0L) {
            stringBuilder.append("created at ").append(this.timestamp);
        }
        if (this.isStripped()) {
            stringBuilder.append(" (stripped)");
        } else {
            stringBuilder.append(" (").append(this.symbolCount).append(" symbols)");
        }
        if (this.flags != 0) {
            stringBuilder.append(" flags = 0x").append(Integer.toHexString(this.flags));
        }
        return stringBuilder.toString();
    }

    public ByteOrder getByteOrder() {
        ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
        if ((this.flags & 0x8000) != 0 || (this.flags & 0x200) != 0) {
            byteOrder = ByteOrder.BIG_ENDIAN;
        }
        return byteOrder;
    }
}

