/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.binutils.coff;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.StandardOpenOption;
import nl.lxtreme.binutils.coff.FileHeader;
import nl.lxtreme.binutils.coff.LineNumber;
import nl.lxtreme.binutils.coff.OptionalHeader;
import nl.lxtreme.binutils.coff.RelocationInfo;
import nl.lxtreme.binutils.coff.SectionHeader;
import nl.lxtreme.binutils.coff.Symbol;

public class Coff
implements Closeable {
    public final FileHeader fileHeader;
    public final OptionalHeader optHeader;
    public final SectionHeader[] sectionHeaders;
    public final Symbol[] symbols;
    private FileChannel channel;

    public Coff(File file) throws IOException {
        this(FileChannel.open(file.toPath(), StandardOpenOption.READ));
    }

    public Coff(FileChannel fileChannel) throws IOException {
        int n;
        this.channel = fileChannel;
        this.fileHeader = new FileHeader(fileChannel);
        ByteBuffer byteBuffer = ByteBuffer.allocate(Math.max(40, this.fileHeader.optionalHeaderSize));
        byteBuffer.limit(this.fileHeader.optionalHeaderSize);
        byteBuffer.order(this.fileHeader.getByteOrder());
        Coff.readFully(fileChannel, byteBuffer, "Unable to read optional header!");
        this.optHeader = new OptionalHeader(byteBuffer);
        byteBuffer.clear();
        byteBuffer.limit(40);
        this.sectionHeaders = new SectionHeader[this.fileHeader.sectionCount];
        for (int i = 0; i < this.sectionHeaders.length; ++i) {
            Coff.readFully(fileChannel, byteBuffer, "Unable to read section header #" + (i + 1));
            this.sectionHeaders[i] = new SectionHeader(byteBuffer);
        }
        byte[] byArray = new byte[]{};
        long l = this.fileHeader.symbolFilePtr + (long)(this.fileHeader.symbolCount * 18);
        if (l > 0L && l < fileChannel.size()) {
            fileChannel.position(l);
            byteBuffer.clear();
            byteBuffer.limit(4);
            Coff.readFully(fileChannel, byteBuffer, "Unable to read string table size!");
            n = byteBuffer.getInt();
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(n);
            Coff.readFully(fileChannel, byteBuffer2, "Unable to read string table!");
            byArray = byteBuffer2.array();
        }
        byteBuffer.clear();
        byteBuffer.limit(18);
        this.symbols = new Symbol[this.fileHeader.symbolCount];
        for (n = 0; n < this.symbols.length; ++n) {
            Coff.readFully(fileChannel, byteBuffer, "Unable to read symbol #" + (n + 1));
            this.symbols[n] = new Symbol(byteBuffer, byArray);
        }
    }

    static void readFully(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer, String string) throws IOException {
        byteBuffer.rewind();
        int n = readableByteChannel.read(byteBuffer);
        if (n != byteBuffer.limit()) {
            throw new IOException(string + " Read only " + n + " of " + byteBuffer.limit() + " bytes!");
        }
        byteBuffer.flip();
    }

    static String getZString(byte[] byArray, int n) {
        int n2;
        for (n2 = n; n2 < byArray.length && byArray[n2] != 0; ++n2) {
        }
        return new String(byArray, n, n2 - n);
    }

    @Override
    public void close() throws IOException {
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }

    public LineNumber[] getLineNumbers(SectionHeader sectionHeader) throws IOException {
        if (sectionHeader == null) {
            throw new IllegalArgumentException("Header cannot be null!");
        }
        if (this.channel == null) {
            throw new IOException("ELF file is already closed!");
        }
        if (sectionHeader.lineNumberOffset == 0 || sectionHeader.lineNumberSize == 0) {
            return new LineNumber[0];
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(10);
        byteBuffer.order(this.fileHeader.getByteOrder());
        this.channel.position(sectionHeader.lineNumberOffset);
        LineNumber[] lineNumberArray = new LineNumber[sectionHeader.lineNumberSize];
        for (int i = 0; i < lineNumberArray.length; ++i) {
            Coff.readFully(this.channel, byteBuffer, "Unable to read line number information!");
            lineNumberArray[i] = new LineNumber(byteBuffer);
        }
        return lineNumberArray;
    }

    public RelocationInfo[] getRelocationInfo(SectionHeader sectionHeader) throws IOException {
        if (sectionHeader == null) {
            throw new IllegalArgumentException("Header cannot be null!");
        }
        if (this.channel == null) {
            throw new IOException("ELF file is already closed!");
        }
        if (sectionHeader.relocTableOffset == 0 || sectionHeader.relocTableSize == 0) {
            return new RelocationInfo[0];
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(10);
        byteBuffer.order(this.fileHeader.getByteOrder());
        this.channel.position(sectionHeader.relocTableOffset);
        RelocationInfo[] relocationInfoArray = new RelocationInfo[sectionHeader.relocTableSize];
        for (int i = 0; i < relocationInfoArray.length; ++i) {
            Coff.readFully(this.channel, byteBuffer, "Unable to read relocation information!");
            relocationInfoArray[i] = new RelocationInfo(byteBuffer);
        }
        return relocationInfoArray;
    }

    public ByteBuffer getSectionData(SectionHeader sectionHeader) throws IOException {
        if (sectionHeader == null) {
            throw new IllegalArgumentException("Header cannot be null!");
        }
        if (this.channel == null) {
            throw new IOException("ELF file is already closed!");
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(sectionHeader.size);
        byteBuffer.order(this.fileHeader.getByteOrder());
        this.channel.position(sectionHeader.dataOffset);
        Coff.readFully(this.channel, byteBuffer, "Unable to read section completely!");
        return byteBuffer;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("COFF ");
        stringBuilder.append(this.fileHeader).append("; ");
        stringBuilder.append(this.optHeader).append("\n");
        for (int i = 0; i < this.sectionHeaders.length; ++i) {
            stringBuilder.append("\t").append(this.sectionHeaders[i]).append("\n");
        }
        return stringBuilder.toString();
    }
}

