/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.binutils.ar;

import java.io.IOException;
import java.io.RandomAccessFile;
import nl.lxtreme.binutils.ar.AR;

public class AREntry {
    private static final int NAME_IDX = 0;
    private static final int NAME_LEN = 16;
    private static final int MTIME_IDX = 16;
    private static final int MTIME_LEN = 12;
    private static final int UID_IDX = 28;
    private static final int UID_LEN = 6;
    private static final int GID_IDX = 34;
    private static final int GID_LEN = 6;
    private static final int MODE_IDX = 40;
    private static final int MODE_LEN = 8;
    private static final int SIZE_IDX = 48;
    private static final int SIZE_LEN = 10;
    private static final int MAGIC_IDX = 58;
    private static final int MAGIC_LEN = 2;
    private static final int HEADER_LEN = 60;
    private String fileName;
    private long fileOffset;
    private long modificationTime;
    private int uid;
    private int gid;
    private int mode;
    private long size;

    private AREntry() {
    }

    static AREntry create(AR aR, RandomAccessFile randomAccessFile) throws IOException {
        int n;
        AREntry aREntry = new AREntry();
        byte[] byArray = new byte[60];
        randomAccessFile.readFully(byArray);
        aREntry.fileOffset = randomAccessFile.getFilePointer();
        aREntry.fileName = new String(byArray, 0, 16).trim();
        aREntry.size = Long.parseLong(new String(byArray, 48, 10).trim());
        if (!aREntry.isSpecial()) {
            aREntry.modificationTime = Long.parseLong(new String(byArray, 16, 12).trim());
            aREntry.uid = Integer.parseInt(new String(byArray, 28, 6).trim());
            aREntry.gid = Integer.parseInt(new String(byArray, 34, 6).trim());
            aREntry.mode = Integer.parseInt(new String(byArray, 40, 8).trim(), 8);
            if (byArray[58] != 96 && byArray[59] != 10) {
                throw new IOException("Not a valid AR archive! No file header magic found.");
            }
        }
        if (aREntry.isBSDArExtendedFileName()) {
            try {
                n = Integer.parseInt(aREntry.fileName.substring(3));
                if (n > 0) {
                    byArray = new byte[n];
                    randomAccessFile.readFully(byArray);
                    aREntry.fileName = new String(byArray).trim();
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("Invalid AR archive! (BSD) Extended filename invalid?!");
            }
        }
        if (aREntry.isGNUArExtendedFileName()) {
            try {
                long l = Long.parseLong(aREntry.fileName.substring(1));
                aREntry.fileName = aR.nameFromStringTable(l);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("Invalid AR archive! (GNU) Extended filename invalid?!");
            }
        }
        if ((n = aREntry.fileName.length()) > 2 && aREntry.fileName.charAt(n - 1) == '/') {
            aREntry.fileName = aREntry.fileName.substring(0, n - 1);
        }
        return aREntry;
    }

    static boolean isARHeader(byte[] byArray) {
        return byArray.length >= 7 && byArray[0] == 33 && byArray[1] == 60 && byArray[2] == 97 && byArray[3] == 114 && byArray[4] == 99 && byArray[5] == 104 && byArray[6] == 62;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AREntry aREntry = (AREntry)object;
        if (this.fileName == null ? aREntry.fileName != null : !this.fileName.equals(aREntry.fileName)) {
            return false;
        }
        if (this.fileOffset != aREntry.fileOffset) {
            return false;
        }
        if (this.gid != aREntry.gid) {
            return false;
        }
        if (this.mode != aREntry.mode) {
            return false;
        }
        if (this.modificationTime != aREntry.modificationTime) {
            return false;
        }
        if (this.size != aREntry.size) {
            return false;
        }
        return this.uid == aREntry.uid;
    }

    public int getFileMode() {
        return this.mode;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getGID() {
        return this.gid;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public long getSize() {
        return this.size;
    }

    public int getUID() {
        return this.uid;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (int)(this.modificationTime ^ this.modificationTime >>> 32);
        n = 31 * n + (this.fileName == null ? 0 : this.fileName.hashCode());
        n = 31 * n + (int)(this.fileOffset ^ this.fileOffset >>> 32);
        n = 31 * n + (int)(this.size ^ this.size >>> 32);
        n = 31 * n + this.gid;
        n = 31 * n + this.mode;
        n = 31 * n + this.uid;
        return n;
    }

    public boolean isSpecial() {
        return this.fileName.charAt(0) == '/';
    }

    public boolean isStringTableSection() {
        return this.fileName.equals("//");
    }

    final long getFileOffset() {
        return this.fileOffset;
    }

    final boolean isBSDArExtendedFileName() {
        return this.fileName.matches("^#1/\\d+$");
    }

    final boolean isGNUArExtendedFileName() {
        return this.fileName.matches("^/\\d+$");
    }
}

