/*
 * Decompiled with CFR 0.152.
 */
package com.google.classyshark.updater.networking;

import com.google.classyshark.updater.models.Release;
import com.google.classyshark.updater.networking.AbstractDownloader;
import java.io.File;
import java.util.Scanner;

public class CliDownloader
extends AbstractDownloader {
    private static final AbstractDownloader instance = new CliDownloader();

    private CliDownloader() {
    }

    @Override
    boolean warnAboutNew(Release release) {
        String string = "New ClassyShark version available!\n" + release.getReleaseName() + "\n" + release.getChangelog() + "\n" + "Do you wish to download it? (y/N)";
        System.out.println(string);
        Scanner scanner = new Scanner(System.in);
        return scanner.next().equalsIgnoreCase("y");
    }

    @Override
    void onReleaseDownloaded(File file, Release release) {
        String string = "New ClassyShark version available offline!\nThe new release " + release.getReleaseName() + " has been downloaded to " + file.getAbsolutePath();
        System.out.println(string);
    }

    public static AbstractDownloader getInstance() {
        return instance;
    }
}

