/*
 * Decompiled with CFR 0.152.
 */
package com.google.classyshark.silverghost.translator.xml;

import com.google.common.io.LittleEndianDataInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class XmlDecompressor {
    private static final int PACKED_XML_IDENTIFIER = 524291;
    private static final int END_DOC_TAG = 257;
    private static final int START_ELEMENT_TAG = 258;
    private static final int END_ELEMENT_TAG = 259;
    private static final int CDATA_TAG = 260;
    private static final int ATTRS_MARKER = 0x140014;
    private static final int RES_XML_RESOURCE_MAP_TYPE = 384;
    private static final int RES_XML_FIRST_CHUNK_TYPE = 256;
    private static final int REX_XML_STRING_TABLE = 1;
    private static final int RES_TYPE_NULL = 0;
    private static final int RES_TYPE_REFERENCE = 1;
    private static final int RES_TYPE_ATTRIBUTE = 2;
    private static final int RES_TYPE_STRING = 3;
    private static final int RES_TYPE_FLOAT = 4;
    private static final int RES_TYPE_DIMENSION = 5;
    private static final int RES_TYPE_FRACTION = 6;
    private static final int RES_TYPE_DYNAMIC_REFERENCE = 7;
    private static final int RES_TYPE_INT_DEC = 16;
    private static final int RES_TYPE_INT_HEX = 17;
    private static final int RES_TYPE_INT_BOOLEAN = 18;
    private static final int COMPLEX_UNIT_SHIFT = 0;
    private static final int COMPLEX_UNIT_MASK = 15;
    private static final int COMPLEX_MANTISSA_SHIFT = 8;
    private static final int COMPLEX_MANTISSA_MASK = 0xFFFFFF;
    private static final int COMPLEX_RADIX_SHIFT = 4;
    private static final int COMPLEX_RADIX_MASK = 3;
    private static final int COMPLEX_UNIT_FRACTION = 0;
    private static final int COMPLEX_UNIT_FRACTION_PARENT = 1;
    private static final float MANTISSA_MULT = 0.00390625f;
    private static final float[] RADIX_MULTS = new float[]{0.00390625f, 3.0517578E-5f, 1.1920929E-7f, 4.656613E-10f};
    private static final int RES_VALUE_TRUE = -1;
    private static final int RES_VALUE_FALSE = 0;
    private static char[] SPACE_FILL = new char[160];
    private static final int IDENT_SIZE = 2;
    private static final int ATTR_IDENT_SIZE = 4;
    private static final String ERROR_INVALID_MAGIC_NUMBER = "Invalid packed XML identifier. Expecting 0x%08X, found 0x%08X\n";
    private static final String ERROR_INVALID_STRING_TABLE_ID = "Invalid String table identifier. Expecting 0x%08X, found 0x%08X\n";
    private static final String ERROR_UNKNOWN_TAG = "Unknown Tag 0x%04X\n";
    private static final String ERROR_ATTRIBUTE_MARKER = "Expecting %08X, Found %08X\n";
    private boolean appendNamespaces = false;
    private boolean appendCData = true;

    public void setAppendNamespaces(boolean bl) {
        this.appendNamespaces = bl;
    }

    public void setAppendCData(boolean bl) {
        this.appendCData = bl;
    }

    public String decompressXml(byte[] byArray) throws IOException {
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);){
            String string = this.decompressXml(byteArrayInputStream);
            return string;
        }
    }

    public String decompressXml(InputStream inputStream) throws IOException {
        StringBuilder stringBuilder = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        try (LittleEndianDataInputStream littleEndianDataInputStream = new LittleEndianDataInputStream(inputStream);){
            int n = littleEndianDataInputStream.readInt();
            if (n != 524291) {
                throw new IOException(String.format(ERROR_INVALID_MAGIC_NUMBER, 524291, n));
            }
            littleEndianDataInputStream.skipBytes(4);
            List<String> list = this.parseStrings(littleEndianDataInputStream);
            int n2 = 0;
            short s = littleEndianDataInputStream.readShort();
            do {
                short s2 = littleEndianDataInputStream.readShort();
                int n3 = littleEndianDataInputStream.readInt();
                switch (s) {
                    case 256: {
                        littleEndianDataInputStream.skipBytes(n3 - 8);
                        break;
                    }
                    case 384: {
                        littleEndianDataInputStream.skipBytes(n3 - 8);
                        break;
                    }
                    case 258: {
                        this.parseStartTag(stringBuilder, littleEndianDataInputStream, list, n2);
                        ++n2;
                        break;
                    }
                    case 259: {
                        this.parseEndTag(stringBuilder, littleEndianDataInputStream, list, --n2);
                        break;
                    }
                    case 260: {
                        this.parseCDataTag(stringBuilder, littleEndianDataInputStream, list, n2);
                        break;
                    }
                    default: {
                        System.err.println(String.format(ERROR_UNKNOWN_TAG, s));
                    }
                }
            } while ((s = littleEndianDataInputStream.readShort()) != 257);
            String string = stringBuilder.toString();
            return string;
        }
    }

    private void parseCDataTag(StringBuilder stringBuilder, DataInput dataInput, List<String> list, int n) throws IOException {
        dataInput.skipBytes(8);
        int n2 = dataInput.readInt();
        dataInput.skipBytes(8);
        if (this.appendCData) {
            stringBuilder.append(SPACE_FILL, 0, n * 2);
            stringBuilder.append("<![CDATA[\n");
            stringBuilder.append(SPACE_FILL, 0, n * 2 + 1);
            stringBuilder.append(list.get(n2));
            stringBuilder.append(SPACE_FILL, 0, n * 2);
            stringBuilder.append("]]>\n");
        }
    }

    private void parseEndTag(StringBuilder stringBuilder, DataInput dataInput, List<String> list, int n) throws IOException {
        stringBuilder.append(SPACE_FILL, 0, n * 2);
        stringBuilder.append("</");
        dataInput.skipBytes(8);
        int n2 = dataInput.readInt();
        if (this.appendNamespaces && n2 >= 0) {
            stringBuilder.append(list.get(n2)).append(":");
        }
        int n3 = dataInput.readInt();
        stringBuilder.append(list.get(n3)).append(">\n");
    }

    private void parseStartTag(StringBuilder stringBuilder, DataInput dataInput, List<String> list, int n) throws IOException {
        stringBuilder.append(SPACE_FILL, 0, n * 2);
        stringBuilder.append("<");
        dataInput.skipBytes(8);
        int n2 = dataInput.readInt();
        if (this.appendNamespaces && n2 >= 0) {
            stringBuilder.append(list.get(n2)).append(":");
        }
        int n3 = dataInput.readInt();
        stringBuilder.append(list.get(n3));
        this.parseAttributes(stringBuilder, dataInput, list, n);
        stringBuilder.append(">\n");
    }

    private void parseAttributes(StringBuilder stringBuilder, DataInput dataInput, List<String> list, int n) throws IOException {
        int n2 = dataInput.readInt();
        if (n2 != 0x140014) {
            System.err.printf(ERROR_ATTRIBUTE_MARKER, 0x140014, n2);
        }
        int n3 = dataInput.readInt();
        dataInput.skipBytes(4);
        for (int i = 0; i < n3; ++i) {
            String string;
            String string2;
            stringBuilder.append("\n").append(SPACE_FILL, 0, n * 2 + 4);
            int n4 = dataInput.readInt();
            int n5 = dataInput.readInt();
            int n6 = dataInput.readInt();
            dataInput.skipBytes(3);
            byte by = dataInput.readByte();
            int n7 = dataInput.readInt();
            if (this.appendNamespaces && n4 >= 0) {
                stringBuilder.append(list.get(n4)).append(":");
            }
            if ((string2 = list.get(n5)).isEmpty()) {
                string2 = "unknown";
            }
            switch (by) {
                case 0: {
                    string = n7 == 0 ? "<undefined>" : "<empty>";
                    break;
                }
                case 1: {
                    string = String.format("@res/0x%08X", n7);
                    break;
                }
                case 2: {
                    string = String.format("@attr/0x%08X", n7);
                    break;
                }
                case 3: {
                    string = list.get(n6);
                    break;
                }
                case 4: {
                    string = Float.toString(Float.intBitsToFloat(n7));
                    break;
                }
                case 5: {
                    float f = XmlDecompressor.resValue(n7);
                    String string3 = XmlDecompressor.getDimensionType(n7);
                    string = f + string3;
                    break;
                }
                case 6: {
                    float f = XmlDecompressor.resValue(n7);
                    String string3 = XmlDecompressor.getFractionType(n7);
                    string = f + string3;
                    break;
                }
                case 7: {
                    string = String.format("@dyn/0x%08X", n7);
                    break;
                }
                case 16: {
                    string = Integer.toString(n7);
                    break;
                }
                case 17: {
                    string = String.format("0x%08X", n7);
                    break;
                }
                case 18: {
                    string = n7 == -1 ? "true" : "false";
                    break;
                }
                default: {
                    string = String.format("0x%08X", n7);
                }
            }
            stringBuilder.append(string2).append("='").append(string).append("'");
        }
    }

    private List<String> parseStrings(DataInput dataInput) throws IOException {
        String string;
        int n;
        boolean bl;
        short s = dataInput.readShort();
        if (s != 1) {
            throw new IOException(String.format(ERROR_INVALID_MAGIC_NUMBER, 524291, (int)s));
        }
        short s2 = dataInput.readShort();
        int n2 = dataInput.readInt();
        int n3 = dataInput.readInt();
        int n4 = dataInput.readInt();
        int n5 = dataInput.readInt();
        int n6 = dataInput.readInt();
        int n7 = dataInput.readInt();
        boolean bl2 = bl = (n5 & 0x100) > 0;
        if (bl) {
            n = 1;
            string = "UTF-8";
        } else {
            n = 2;
            string = "UTF-16LE";
        }
        return XmlDecompressor.parseUsingByteBuffer(n2, s2, n3, n4, bl, n, string, dataInput);
    }

    private static List<String> parseUsingByteBuffer(int n, int n2, int n3, int n4, boolean bl, int n5, String string, DataInput dataInput) throws IOException {
        int n6;
        int n7 = n - n2;
        byte[] byArray = new byte[n7];
        ByteBuffer byteBuffer = ByteBuffer.allocate(n7);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        dataInput.readFully(byArray);
        byteBuffer.put(byArray);
        byteBuffer.rewind();
        ArrayList<String> arrayList = new ArrayList<String>(n3);
        int[] nArray = new int[n3];
        for (n6 = 0; n6 < n3; ++n6) {
            nArray[n6] = byteBuffer.getInt();
        }
        n6 = byteBuffer.position();
        for (int i = 0; i < n3; ++i) {
            int n8;
            byteBuffer.position(n6 + nArray[i]);
            if (bl) {
                n8 = XmlDecompressor.getUnsignedByte(byteBuffer);
                byteBuffer.get();
            } else {
                n8 = XmlDecompressor.getUnsignedShort(byteBuffer);
            }
            int n9 = n8 * n5;
            String string2 = new String(byArray, n6 + nArray[i] + 2, n9, string);
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static int getUnsignedShort(ByteBuffer byteBuffer) {
        return byteBuffer.getShort() & 0xFFFF;
    }

    public static int getUnsignedByte(ByteBuffer byteBuffer) {
        return byteBuffer.get() & 0xFF;
    }

    public static long getUnsignedInt(ByteBuffer byteBuffer) {
        return (long)byteBuffer.getInt() & 0xFFFFFFFFL;
    }

    private static String getDimensionType(int n) {
        switch (n >> 0 & 0xF) {
            case 0: {
                return "px";
            }
            case 1: {
                return "dp";
            }
            case 2: {
                return "sp";
            }
            case 3: {
                return "pt";
            }
            case 4: {
                return "in";
            }
            case 5: {
                return "mm";
            }
        }
        return " (unknown unit)";
    }

    private static String getFractionType(int n) {
        switch (n >> 0 & 0xF) {
            case 0: {
                return "%%";
            }
            case 1: {
                return "%%p";
            }
        }
        return "(unknown unit)";
    }

    private static float resValue(int n) {
        float f = (float)(n & 0xFFFFFF00) * RADIX_MULTS[n >> 4 & 3];
        return f;
    }

    static {
        Arrays.fill(SPACE_FILL, ' ');
    }
}

