/*
 * Decompiled with CFR 0.152.
 */
package com.google.classyshark.silverghost.translator.xml;

import com.google.classyshark.silverghost.TokensMapper;
import com.google.classyshark.silverghost.translator.Translator;
import com.google.classyshark.silverghost.translator.xml.XmlDecompressor;
import com.google.classyshark.silverghost.translator.xml.XmlHighlighter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class AndroidXmlTranslator
implements Translator {
    private static final String DEFAULT_CLASS_NAME = "AndroidManifest.xml";
    private final File archiveFile;
    private final String xmlName;
    private String xml;
    private XmlHighlighter xmlHighlighter = new XmlHighlighter();
    private XmlDecompressor xmlDecompressor = new XmlDecompressor();

    public AndroidXmlTranslator(String string, File file) {
        this.xmlName = string;
        this.archiveFile = file;
    }

    public AndroidXmlTranslator(File file) {
        this(DEFAULT_CLASS_NAME, file);
    }

    @Override
    public String getClassName() {
        return this.xmlName;
    }

    @Override
    public void addMapper(TokensMapper tokensMapper) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply() {
        InputStream inputStream = null;
        ZipFile zipFile = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            int n;
            long l;
            Object object;
            if (this.archiveFile.getName().endsWith(".apk") || this.archiveFile.getName().endsWith(".zip") || this.archiveFile.getName().endsWith(".aar")) {
                zipFile = new ZipFile(this.archiveFile);
                object = zipFile.getEntry(this.xmlName);
                l = ((ZipEntry)object).getSize();
                inputStream = zipFile.getInputStream((ZipEntry)object);
            } else {
                l = this.archiveFile.length();
                inputStream = new FileInputStream(this.archiveFile);
            }
            if (l > Integer.MAX_VALUE) {
                throw new IOException("File larger than 2147483647 bytes not supported");
            }
            byteArrayOutputStream = new ByteArrayOutputStream((int)l);
            object = new byte[1024];
            while ((n = inputStream.read((byte[])object)) > 0) {
                byteArrayOutputStream.write((byte[])object, 0, n);
            }
            this.xml = this.archiveFile.getName().endsWith(".aar") ? byteArrayOutputStream.toString() : this.xmlDecompressor.decompressXml(byteArrayOutputStream.toByteArray());
            this.closeResource(inputStream);
            this.closeResource(zipFile);
            this.closeResource(byteArrayOutputStream);
        }
        catch (Exception exception) {
            try {
                System.err.println("Error reading AndroidManifext.xml " + exception.getMessage());
                exception.printStackTrace(System.err);
                this.closeResource(inputStream);
                this.closeResource(zipFile);
                this.closeResource(byteArrayOutputStream);
            }
            catch (Throwable throwable) {
                this.closeResource(inputStream);
                this.closeResource(zipFile);
                this.closeResource(byteArrayOutputStream);
                throw throwable;
            }
        }
    }

    private void closeResource(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            System.err.println("Error closing resource: " + iOException.getMessage());
            iOException.printStackTrace(System.err);
        }
    }

    @Override
    public List<Translator.ELEMENT> getElementsList() {
        return this.xmlHighlighter.getElements(this.xml);
    }

    @Override
    public List<String> getDependencies() {
        return new ArrayList<String>();
    }

    public String toString() {
        return this.xml;
    }

    public static void main(String[] stringArray) throws Exception {
        String string = System.getProperty("user.home") + "/Desktop/Scenarios/ 2 Samples/app-debug.apk";
        AndroidXmlTranslator androidXmlTranslator = new AndroidXmlTranslator(new File(string));
        androidXmlTranslator.apply();
        System.out.print(androidXmlTranslator.toString());
    }
}

