/*
 * Decompiled with CFR 0.152.
 */
package com.google.classyshark.silverghost.translator.elf;

import com.google.classyshark.silverghost.TokensMapper;
import com.google.classyshark.silverghost.io.SherlockHash;
import com.google.classyshark.silverghost.translator.Translator;
import com.google.classyshark.silverghost.translator.elf.ElfReader;
import com.google.classyshark.silverghost.translator.jar.JarInfoTranslator;
import java.io.File;
import java.io.FileInputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import nl.lxtreme.binutils.elf.Elf;

public class ElfTranslator
implements Translator {
    private File archiveFile;
    private File resource;
    private String elfName;
    private String dependencies;
    private StringBuilder dynamicSymbols;

    public ElfTranslator(String string, File file) {
        this.archiveFile = file;
        this.elfName = string;
        this.dynamicSymbols = new StringBuilder();
    }

    @Override
    public String getClassName() {
        return this.archiveFile.getName();
    }

    @Override
    public void addMapper(TokensMapper tokensMapper) {
    }

    @Override
    public void apply() {
        this.dependencies = "";
        this.resource = ElfTranslator.extractElf(this.elfName, this.archiveFile);
        try {
            Elf elf = new Elf(this.resource);
            List<String> list = elf.getSharedDependencies();
            for (String object : list) {
                this.dependencies = this.dependencies + "    " + object + "\n";
            }
            ElfReader elfReader = ElfReader.read(this.resource);
            for (String string : elfReader.getDynamicSymbols()) {
                this.dynamicSymbols.append("    --  " + string + "\n");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public List<Translator.ELEMENT> getElementsList() {
        LinkedList<Translator.ELEMENT> linkedList = new LinkedList<Translator.ELEMENT>();
        linkedList.add(new Translator.ELEMENT("File size - ", Translator.TAG.DOCUMENT));
        linkedList.add(new Translator.ELEMENT(JarInfoTranslator.readableFileSize(this.resource.length()), Translator.TAG.DOCUMENT));
        linkedList.add(new Translator.ELEMENT("\n\nNative Dependencies\n\n", Translator.TAG.IDENTIFIER));
        linkedList.add(new Translator.ELEMENT(this.dependencies, Translator.TAG.DOCUMENT));
        linkedList.add(new Translator.ELEMENT("\n\n\n\nDynamic Symbols\n\n", Translator.TAG.IDENTIFIER));
        linkedList.add(new Translator.ELEMENT(this.dynamicSymbols.toString(), Translator.TAG.DOCUMENT));
        return linkedList;
    }

    @Override
    public List<String> getDependencies() {
        return new LinkedList<String>();
    }

    public static File extractElf(String string, File file) {
        File file2 = new File("classes.dex");
        try {
            ZipEntry zipEntry;
            ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (!zipEntry.getName().equals(string)) continue;
                String string2 = string;
                String string3 = "so";
                file2 = SherlockHash.INSTANCE.getFileFromZipStream(file, zipInputStream, string2, string3);
                break;
            }
            zipInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return file2;
    }
}

